
const padNum = (num) => {
  if (typeof num === 'number') {
    return num.toLocaleString();
  } else {
    return num;
  }
};

export default {
  name: 'footer-page',
  isInner: true,
  created() {
    this.el.classList.add('video-footer-wrapper');
    this.el.innerHTML = `
      <div class="app-content">
        <div class="app-logo"></div>
        <div class="app-desc">
          <div class="app-name"></div>
          <div class="app-comment">
            <div class="app-star-num"></div>
            <div class="app-comment-num">个评分</div>
          </div>
        </div>
      </div>
      <div class="app-button"></div>
    `;
    this.appNameEl = this.el.querySelector('.app-name');
    this.appCommentNumEl = this.el.querySelector('.app-comment-num');
    this.appLogoEl = this.el.querySelector('.app-logo');
    this.appButtonEl = this.el.querySelector('.app-button');
    this.appIcon = this.el.querySelector('.app-logo');
    this.starNumEl = this.el.querySelector('.app-star-num');
    this.el.addEventListener('click', (e) => {
      if (e.target === this.appButton) {
        this.$player.event.emit('$footerPageClick', e);
        this.$player.event.emit('$footerPageButtonClick', e);
      } else {
        this.$player.event.emit('$footerPageClick', e);
      }
    });
  },
  methods: {
    renderStarNum(num) {
      let dom = '';
      let renderNum = 5;
      while (renderNum > 0) {
        if (num >= 1) {
          dom += '<div class="app-star-yellow app-star-icon"></div>';
        } else if (num === 0.5) {
          dom += '<div class="app-star-half app-star-icon"></div>';
        } else {
          dom += '<div class="app-star-gray app-star-icon"></div>';
        }
        renderNum -= 1;
        num -= 1;
      }
      console.log(dom);
      this.starNumEl.innerHTML = dom;
    },
    hide() {
      this.el.style.display = 'none';
    },
    show() {
      this.el.style.display = 'flex';
    }
  },
  event: {
    $footerPageChangeApp({ name, commentNum, starNum, appIcon, buttonText }, show = true) {
      if (!show) {
        console.log('hidehide');
        this.hide();
        return;
      } else {
        this.show();
      }
      if (name) {
        console.log(name);
        this.appNameEl.innerText = name;
      };
      if (commentNum) {
        this.appCommentNumEl.innerText = `${padNum(commentNum)}个评分`;
      }
      if (typeof starNum === 'number') {
        this.renderStarNum(starNum);
      };
      if (buttonText) {
        this.appButtonEl.innerText = buttonText;
      }
      if (appIcon) {
        this.appIcon.style.backgroundImage = `url(${appIcon})`;
      }
    }
  }
};
