
let nameId = 0;
class VideoPlugin {
  isAbstract: any;
  isInner: any;
  poinerEvents: any;
  configRaw: any;
  name: any;
  $wrapper: any;
  $video: any;
  $contanier: any;
  $player: any;
  el: HTMLDivElement;
  $wapper(arg0: any): any {
    throw new Error("Method not implemented.");
  }
  _removed: any;
  constructor(config) {
    this.isAbstract = config.isAbstract || false;
    this.isInner = config.isInner || false;
    this.poinerEvents = config.poinerEvents;
    this.configRaw = config;
    nameId += 1;
    this.name = config.name || nameId;
    // 当前video实例
    this.$wrapper = config.$wrapper || '';
    this.$video = config.$video || '';
    this.$contanier = config.$contanier || '';
    this.$player = config.$player || '';
    this.proxyMethods(config);
    // 初始化事件
    for (const i in config.event) {
      if (i && typeof config.event[i] === 'function') {
        this.$player.on(i, config.event[i].bind(this));
      }
    }
  }

  // 代理methods
  proxyMethods(config) {
    if (config.methods) {
      const that = this;
      for (const i in config.methods) {
        Object.defineProperty(this, i, {
          get() {
            return config.methods[i].bind(that);
          }
        });
      }
    }
  }

  // 创建
  created() {
    if (!this.isAbstract) {
      this.el = document.createElement('div');
      console.log(this.poinerEvents);
      this.poinerEvents === 'none' && (this.el.style.pointerEvents = 'none');
      if (this.isInner) {
        this.el.classList.add('video-inner-plugin');
      } else {
        this.el.classList.add('video-plugin');
        if (this.configRaw.zIndex) {
          this.el.style.zIndex = this.configRaw.zIndex;
        } else {
          this.el.style.zIndex = nameId+"";
        }
      }
    };
    if (this.configRaw.created) {
      this.configRaw.created.apply(this);
    }
  }

  // 挂载完成
  mounted() {
    if (this.isInner) {
      console.log(this.$wapper);
      this.$wrapper.appendChild(this.el);
    } else {
      this.$contanier.appendChild(this.el);
    }
    if (this.configRaw.mounted) {
      this.configRaw.mounted.apply(this);
    }
  }

  // 移除
  remove() {
    if (this._removed) {
      return;
    };
    if (this.isAbstract) {
      return;
    }
    if (this.isInner) {
      this.$wrapper.removeChild(this.el);
      this._removed = true;
    } else {
      console.log(this.el);
      this.$contanier.removeChild(this.el);
      this._removed = true;
    }
  }

  // 卸载
  destory() {
    this.el = null;
  }
};

export default VideoPlugin;
