import defaultVideoConfig from './defaultVideoConfig';
import VideoPlugin from './plugins';
import EventEmitter from './event';
import { videoEvent, videoProps } from './videoEvent';

const clone = (obj) => {
  return JSON.parse(JSON.stringify(obj));
};

const plugins = [];

class AdVideo {
  eventType: any[];
  event: EventEmitter;
  $contanier: any;
  $video: HTMLVideoElement;
  $wrapper: HTMLDivElement;
  url: any;
  videoCoinfg: any;
  plugins: any[];
  static install: (plugConfig: any) => void;
  constructor(config) {
    this.eventType = [];
    this.event = new EventEmitter();
    this.initVideoConfig(config);
    this.init(config);
  }

  // 初始化容器
  initVideoConfig(config) {
    if (!config.el) {
      console.warn('player: no element');
      return;
    };
    this.event = new EventEmitter();
    this.$contanier = config.el;
    this.$contanier.classList.add('video-contanier');
    this.$video = document.createElement('video');
    this.$wrapper = document.createElement('div');
    this.$wrapper.classList.add('video-wrapper');
    this.$video.classList.add('video-instance');
  }

  // 初始化
  init(config) {
    this.url = config.url || '';
    this.videoCoinfg = Object["assign"](
      clone(defaultVideoConfig),
      config.videoConfig,
      { url: '' });
    for (const i in this.videoCoinfg) {
      if (videoProps["findIndex"](e => e === i) > -1) {
        this.$video[i] = this.videoCoinfg[i];
      } else {
        this.$video.setAttribute(i, this.videoCoinfg[i]);
      }
    };
    this.plugins = plugins || [];
    this.plugins = this.plugins.map(e => {
      return new VideoPlugin(Object["assign"](e, {
        $video: this.$video,
        $contanier: this.$contanier,
        $wrapper: this.$wrapper,
        $player: this
      }));
    });
    this.$wrapper.appendChild(this.$video);
    this.$contanier.appendChild(this.$wrapper);
    this.plugins.forEach(e => {
      e.created();
    });
    this.$wrapper.appendChild(this.$video);
    this.$contanier.appendChild(this.$wrapper);
    this.plugins.forEach(e => {
      e.mounted();
    });
    // 准备播放;
    if (this.url) {
      this.$video.src = config.url;
    }
  }

  // 初始化事件监听
  on(i, fn) {
    if (typeof i === 'string' && typeof fn === 'function') {
      const isNative = videoEvent["findIndex"](e => e === i) > -1;
      if (isNative && this.eventType["findIndex"](e => e === i) === -1) {
        this.eventType.push(i);
        this.$video.addEventListener(i, (e) => {
          this.event.emit(i, e);
        });
      }
      this.event.on(i, fn);
    }
  }

  // 触发事件
  emit(...args) {
    const event = args[0];
    // 不能触发原生事件。
    if (videoEvent["findIndex"](e => e === event) > -1) {
      return;
    }
    const params = [].slice.call(args, 1);
    this.event.emit(event, ...params);
  }

  // 加载视频
  load(url) {
    this.$video.src = url;
  }

  play() {
    if (this.$video && this.$video.play) {
      this.$video.play();
    }
  }

  pause() {
    if (this.$video) {
      this.$video.pause();
    }
  }

  _removeAll() {
    this.event.removeAll();
  }
};

AdVideo.install = (plugConfig) => {
  plugins.push(plugConfig);
};

export default AdVideo;
