import MobileDetect from './video-core/mobile-detect';
function getCookie(key) {
  var arr1 = document.cookie.split("; ");//由于cookie是通过一个分号+空格的形式串联起来的，所以这里需要先按分号空格截断,变成[name=Jack,pwd=123456,age=22]数组类型；
  for (var i = 0; i < arr1.length; i++) {
      var arr2 = arr1[i].split("=");//通过=截断，把name=Jack截断成[name,Jack]数组；
      if (arr2[0] == key) {
          return decodeURIComponent(arr2[1]);
      }
  }
  return null
}
export const getUrl = (name) => {
  var str = getCookie("dcustom");
  if (str) {
      //&分割
      var arr = str.split("&");
      for (var i = 0; i < arr.length; i++) {
          if (arr[i].indexOf(name + "=") == 0) {
              return arr[i].replace(name + "=", "") || '';
          }
      }
  }
  return '';
};
// 获取网络信息
// 0- 未知网络 2- 2G
// 3- 3G
// 4- 4G
// 5- 5G
// 100-WIFI 101—ETHERNET 999--NEW_TYPE
const reflectObj = {
  wifi: 100,
  '2g': 2,
  '3g': 3,
  '4g': 4,
  '5g': 5,
  other: 0
};
export function getNetworkType(obj = {}) {
  const ua = navigator.userAgent;
  let networkStr = ua.match(/NetType\/\w+/) ? ua.match(/NetType\/\w+/)[0] : 'NetType/other';
  networkStr = networkStr.toLowerCase().replace('nettype/', '');
  let networkType;
  switch (networkStr) {
    case 'wifi':
      networkType = 'wifi';
      break;
    case '4g':
      networkType = '4g';
      break;
    case '3g':
      networkType = '3g';
      break;
    case '3gnet':
      networkType = '3g';
      break;
    case '2g':
      networkType = '2g';
      break;
    default:
      networkType = 'other';
  }
  if (obj.hasOwnProperty(networkType)) {
    return obj[networkType];
  }
  return networkType;
}

interface appInfo {
  appId: string,
  appPackage: string,
  appName: string,
  appVersion: string,
  slotId: string,
  ip: string,
  connectionType: number,
  operatorType: number
}
// 1- 中国移动 2- 中国电信 3- 中国联通
const yunyingShang = {
  '移动': 1,
  '中国移动': 1,
  '联通': 2,
  '中国联通': 2,
  '电信': 3,
  '中国电信': 3,
  '其他': 99
}
// 获取平台信息， app相关的，slotId , ip。
export function getAppInfo(type):Promise<appInfo> {
  const tSlotId = getUrl('tSlotId') || 10000;
  console.log();
  return window.fetch(`https://activity.tuia.cn/commercialloanv/common/config/video/get?slotId=${tSlotId}`)
    .then(res => {
      return res.json();
    }).then(res => {
      console.log(res);
      if (res.code === '0000000' && res.data) {
        const config = res.data.config || [];
        console.log(type);
        const appInfo = config.find(e => e.platform === 'dianxing' && Number(e.type) === type)
        const ipInfo = res.data.ipInfoDetail || {};
        const ip = ipInfo.ip
        const op = ipInfo.isp || '未知'
        const operatorType = yunyingShang[op] || 99;
        appInfo.ip = ip;
        appInfo.operatorType = operatorType;
        appInfo.connectionType = getNetworkType(reflectObj);
        return appInfo;
      } else {
        return 'error';
      }
    });
}

// 根据ip 生成唯一的值。
export function createUnique(ip) {
  return ip + (+ new Date());
}

// ost (平台 1.安卓，2ios), 自行分析
// idfa(苹果唯一标示码)， 必须传递
// model(设备型号)， 优先传递
// osv（操作系统版本号), 优先传递
// imei(安卓平台的号码) 必须传递
// androidid(必须传递) 必须传递
// mac（mac 地址) 必须传递
// vendor(设备厂商) 优先传递
// brand(手机厂商) 有限传递
// imsi() 不做要求。
// ppi
// connt(网络状况) 优先传递

let defaultConfig;
export function getDefaultConfig() {
  if (defaultConfig) return defaultConfig;
  defaultConfig = {};
  const md = new MobileDetect(window.navigator.userAgent);
  if (md.os() === 'iOS') {
    defaultConfig.ost = 2;
    defaultConfig.idfa = getUrl('idfa');
    defaultConfig.ppi = Math.min(window.devicePixelRatio, 3);
    defaultConfig.model = getUrl('model') || md.versionStr('Mobile');
    defaultConfig.osv = getUrl('osv') || md.versionStr('iPhone');
    defaultConfig.imei = '';
    defaultConfig.androidId = '';
    defaultConfig.imsi = '';
  } else {
    defaultConfig.ost = 1;
    defaultConfig.imei = getUrl('imei') || '866333026939494';
    defaultConfig.ppi = 1;
    defaultConfig.model = getUrl('model') || md.versionStr('Build');
    defaultConfig.osv = getUrl('osv') || md.version('Android').toString();
    defaultConfig.androidId = getUrl('androidid') || '';
    defaultConfig.imsi = getUrl('imsi') || '';
    defaultConfig.idfa = '';
  }
  defaultConfig.mac = getUrl('mac');
  defaultConfig.sw = document.body.clientWidth;
  defaultConfig.sh = document.body.clientHeight;
  defaultConfig.vendor = getUrl('vendor') || md.phone();
  defaultConfig.brand = getUrl('vendor') || md.phone();
  return defaultConfig;
}

export function replaceUrl(url, replaceConfig) {
  for (const i in replaceConfig) {
    if (replaceConfig[i]) {
      url = url.replace(i, replaceConfig[i]);
    }
  }
  return url;
}

export const reportGet = (e) => {
  const img = new Image();
  img.src = e;
};