import { getAppInfo, getDefaultConfig, createUnique, reportGet, replaceUrl} from './utils';

const reflectConfig = {
  ost: 'osType',
  osv: 'osVersion',
  sw: 'screenWidth',
  sh: 'screenHeight',
  connt: 'connectionType',
  androidId: 'androidId',
}


const defautToNew = (raw, reflect) => {
  const newObj = {};
  for (let i in raw) {
    if (reflect[i]) {
      newObj[reflect[i]]= raw[i];
    } else {
      newObj[i] = raw[i];
    }
  }
  return newObj;
};

let config = null;
function createConfig (appInfo, device) {
  config = {};
  console.log(device);
  let  { slotId, appId, appVersion, appName, appPackage, ip, connectionType, operatorType} = appInfo
  config['app'] = {
    appId: appId,
    appVersion,
    appName,
    appPackage
  };
  config['slot'] = {
    slotId,
    adtype: 5,
    slotheight: 250,
    slotwidth: 350
  }
  config['device'] = Object['assign']({
    deviceType: 1, 
    screenOrientation: 1,
    ua: window.navigator.userAgent}, device);
  // config['device'] = {
  //   "idfa": "abcdef123456789",
  //   "imei": "abcdef123456789", 
  //   "mac": "12:34:56:78:90:ab", 
  //   "androidId": 
  //   "TestAndroidId123",
  //   "deviceType": 1,
  //   "osType": 1,
  //   "osVersion": "4.2.2",
  //   "vendor": "MEIZU",
  //   "brand": "MEIZU",
  //   "model": "MX5",
  //   "screenHeight": 1080,
  //   "screenWidth": 1920,
  //   "ua": 'Mozilla/5.0 (Linux; U; Android 9.0; en-us; Redmi Build/HRI39) AppleWebKit/534.13 (KHTML, like Gecko) Version/4.0 Safari/534.13',
  //   "screenOrientation": 0,
  //   "imsi": "MEIZU",
  //   "ppi": 1
  // }
  config['network'] = {
    ip,
    connectionType: connectionType,
    operatorType: operatorType,
    lat: 0,
    lon: 0
  }
  return config;
}

interface adRes  {
  errorCode: number,
  ads: Array<any>
};

async function getVideo(type) {
    let videoRes = {};
    try {
      const appInfo = await getAppInfo(type)
      console.log(appInfo);
      console.log(getDefaultConfig());
      const defaultConfig = defautToNew(getDefaultConfig(), reflectConfig);
      console.log(defaultConfig);
      config = createConfig(appInfo, defaultConfig);
     config['requsetId'] = createUnique(config['network']['ip'])
      const res: any = await window.fetch('http://47.95.31.238/adx/ssp/dspAdVideo', {
        body: JSON.stringify(config),
        headers: {
          'content-type': 'application/json;charset=UTF-8',
        },
        method: 'POST'
      }).then(response => {
        return response.json();
      })
      // console.log(res.json());
      // const adRes = res.json();
      console.log(res);
      if (res.errorCode === "200" && res.ads && res.ads.length > 0) {
        return videoRes = res.ads[0];
      } else {
        return false;
      }
    } catch(err) {
      console.log(err);
      return false;
    }
  }


function dianxingReplace(raw, url, times, event) {
  let pagesX, pagesY
  const date = +new Date();
  let clickId = raw.metaGroup[0].clickid
  if (event) {
    pagesX = event.screenX
    pagesY = event.screenY
  }
  return replaceUrl(url, {
    __DOWN_X__: pagesX,
    __DOWN_Y__: pagesY,
    __WIDTH__: document.body.clientWidth,
    __HEIGHT__: document.body.clientHeight,
    __UP_X__: pagesX,
    __UP_Y__: pagesY,
    __EVENT_TIME_START__: date,
    __EVENT_TIME_END__: date,
    __VIDEO_TIME__: times.duration,
    __BEGIN_TIME__: 0,
    __END_TIME__: times.duration,
    __PLAY_FIRST_FRAME__: 1,
    __PLAY_LAST_FRAME__: 1,
    __SCENE__: 3,
    __TYPE__: 1,
    __BEHAVIOR__: 1,
    __STATUS__: 0,
    __CLICK_ID__: clickId
  })
}
const report = {
  isChanged: false,
  isReportDownload: false,
  isReportClick: false,
  // 加载完成
  videoLoad(raw, times) {
    const winLoadUrls = raw.metaGroup[0].winLoadUrls;
    if (winLoadUrls) {
      winLoadUrls.forEach(e => {
        reportGet(dianxingReplace(raw, e, times, null));
      })
    }
  },
  reset() {
    this.isChanged = false;
    this.isReportDownload = false;
    this.isReportClick = false;
  },
  // 开始播放（曝光), 0进度
  videoPlayStart(raw, times) {
    // 重置内部状态
    this.reset();
    // 曝光
    const winNoticeUrls = raw.metaGroup[0].winNoticeUrls;
    if (winNoticeUrls) {
      winNoticeUrls.forEach(e => {
        reportGet(dianxingReplace(raw, e, times, null));
      })
    }
    // 进度是0;
    const track = raw.tracks
    console.log('进度0')
    track.forEach(e => {
      if (e.type === 0) {
        e.urls.forEach(url => {
          reportGet(dianxingReplace(raw, url, times, null));
        })
      }
    })
  },
  // 25进度
  process25(raw, times) {
    console.log('进度25')
    const track = raw.tracks
    track.forEach(e => {
      if (e.type === 1) {
        e.urls.forEach(url => {
          reportGet(dianxingReplace(raw, url, times, null));
        })
      }
    })
  },
  // 50进度
  process50(raw, times) {
    console.log('进度50')
    const track = raw.tracks
    track.forEach(e => {
      if (e.type === 2) {
        e.urls.forEach(url => {
          reportGet(dianxingReplace(raw, url, times, null));
        })
      }
    })
  },
  process75(raw, times) {
    console.log('进度75')
    const track = raw.tracks
    track.forEach(e => {
      if (e.type === 3) {
        e.urls.forEach(url => {
          reportGet(dianxingReplace(raw, url, times, null));
        })
      }
    })
  },
  // 广告点击
  async videoClick(raw, times, event) {
    const winCNoticeUrls = raw.metaGroup[0].winCNoticeUrls;
    if (winCNoticeUrls && !this.isReportClick) {
      this.isReportClick = true;
      winCNoticeUrls.forEach(e => {
        reportGet(dianxingReplace(raw, e, times, event));
      })
    }
  },
  async changeUrl(raw, times, event) {
    if (this.isChanged) {
      return;
    }
    this.isChanged = true;
    let {interactionType, protocolType, clickUrl} = raw.metaGroup[0];
    if (interactionType === 2 && protocolType === 1) {
      try {
        const res = await window.fetch(dianxingReplace(raw, clickUrl, times, event));
        let resJson: any = res.json();
        if (resJson.data.dstlink) {
          return resJson.data.dstlink;
        }
        this.isChanged = false;
      } catch (err) {
        this.isChanged = false;
        console.log('替换地址请求出错');
        return null;
      }
    } else {
      this.isChanged = false;
      return clickUrl
    }
  },
  // 广告关闭
  videoClose(raw, times, event, cb) {
    const winCloseUrls = raw.metaGroup[0].winCloseUrls;
    if (winCloseUrls && !this.isReportClick) {
      this.isReportClick = true;
      winCloseUrls.forEach(e => {
        reportGet(dianxingReplace(raw, e, times, event));
      })
    }
  },
  // 开始下载
  async appDownload(raw, times, event, cb) {
    const winDownloadUrls = raw.metaGroup[0].winDownloadUrls;
    if (winDownloadUrls && !this.isReportDownload) {
      this.isReportDownload = true;
      winDownloadUrls.forEach(e => {
        reportGet(dianxingReplace(raw, e, times, event));
      })
    }
    const url = await this.changeUrl(raw, times, event)
    console.log(raw);
    if (raw.metaGroup[0].interactionType === 2) {
      window.location.href = url;
      return;
    }
    cb(url);
  },
  // 播放完毕, 进度100.
  videoPlayEnd(raw, times) {
    const track = raw.tracks
    console.log('进度100')
    track.forEach(e => {
      if (e.type === 4) {
        e.urls.forEach(url => {
          reportGet(dianxingReplace(raw, url, times, null));
        })
      }
    })
    // 激励完成
    const winCompleteUrls = raw.metaGroup[0].winCompleteUrls
    if (winCompleteUrls) {
      winCompleteUrls.forEach(e => {
        reportGet(dianxingReplace(raw, e, times, event));
      })
    }
  },
}

export function resolveParams(raw) {
  console.log(raw);
  const ads = {
    url: '',
    name: '',
    appIcon: '',
    slogen: '',
    // 类型1.下载 2.查看
    type: 2
  };
  const metaGroup = raw.metaGroup 
  if (metaGroup && metaGroup.length > 0) {
    let videoRaw = metaGroup[0]
    videoRaw.videoUrl && (ads.url = videoRaw.videoUrl);
    videoRaw.adTitle && (ads.name = videoRaw.adTitle);
    videoRaw.iconUrls && videoRaw.iconUrls.length > 0 && (ads.appIcon = videoRaw.iconUrls[0]);
    videoRaw.descs && videoRaw.descs.length > 0 && (ads.slogen = videoRaw.descs[0]);
    if (videoRaw.interactionType === 2) {
      console.log('下载类')
      ads.type = 1
    } else {
      console.log('链接类')
      ads.type = 2
    }
  }
  console.log(ads);
  return ads;
}

export default {
  getVideo,
  report,
  resolveParams,
}