import AdVideo from './video-core/index';
import loadingPlugin from './video-core/videoPlugin/loadingPlugin/index';
import videoControlPlugin from './video-core/videoPlugin/videoControl/index';
import footerPagePlugin from './video-core/videoPlugin/footerPagePlugin/index';
import landPagePlugin from './video-core/videoPlugin/landPagePlugin/index';
import DianXing from './dianxiangVideo';


AdVideo.install(loadingPlugin);
AdVideo.install(videoControlPlugin);
AdVideo.install(footerPagePlugin);
AdVideo.install(landPagePlugin);

interface appContent {
  name: string,
  slogen: string,
  type: number,
  appIcon: string
}
class MyAdvideo {
  el: any;
  player: AdVideo;
  _times: any;
  url: string;
  isVideoIng: boolean;
  process25: boolean;
  process50: boolean;
  process75: boolean;
  videoRaw: {};
  playResolve: any;
  playPromise: Promise<{}>;
  strategy: any;
  stragegyFn: any;
  appContent: appContent;
  isPlayEnd: boolean;
  isPlaying: boolean;
  playSuccessCloseCb : any;
  constructor(config) {
    this.el = config.el;
    this._times = {
      _readyTime: '',
      _responseTime: '',
      _showTime: ''
    }
    this.hide();
    this.player = new AdVideo(config);
    this.reset();
    this.initListener();
    this.isPlayEnd = false;
  }

  // 重置一些状态
  reset() {
    // 各种时间。
    this._times = {
      _readyTime: '',
      _responseTime: '',
      _showTime: ''
    }
    // 视频地址
    this.url = '';
    // 播放 25%;
    this.process25 = false;
    // 播放 50%;
    this.process50 = false;
    // 播放 100%;
    this.process75 = false;
    this.videoRaw = {};
    // 视频播放的 Promise
    this.playResolve = null;
    this.playPromise = new Promise((resolve) => {
      this.playResolve = resolve;
    });
    this.isPlayEnd = false;
    // 平台策略相关
    this.strategy = null;
    this.stragegyFn = {
      'dianxing': DianXing
    }
  }

  // 请求完成
  initListener() {
    // 页面不可见
    document.addEventListener('visibilitychange', () => {
      // 用户离开了当前页面
      if (document.visibilityState === 'hidden') {
        this.player.$video.pause();
      }
      // 用户打开或回到页面
      if (document.visibilityState === 'visible' && !this.isPlayEnd) {
        this.player.$video.play();
      }
    });
    this.player.on('play', () => {
      this._times.duration = this.player.$video.duration
      if (this.player.$video.currentTime === 0) {
        this.isPlaying = true;
        this._times._readyTime = +new Date();
        this.stragegyFn[this.strategy].report.videoLoad(this.videoRaw, this._times);
        this._times._showTime = +new Date();
        this.stragegyFn[this.strategy].report.videoPlayStart(this.videoRaw, this._times);
      }
    });
    this.player.on('$footerPageClick', (e) => {
      // 回调参数
      const cb = (url) => {
        if (url && window['bridge'] && window['bridge'].jumpAdUrl) {
          window['bridge'].jumpAdUrl(url);
        }
      }
      this.stragegyFn[this.strategy].report.videoClick(this.videoRaw, this._times, e, cb);
      this.stragegyFn[this.strategy].report.appDownload(this.videoRaw, this._times, e, cb);
    });
    this.player.on('$process', (e) => {
      if (e > 25 && !this.process25) {
        this.process25 = true;
        this.stragegyFn[this.strategy].report.process25(this.videoRaw, this._times);
      };
      if (e > 50 && !this.process50) {
        this.process50 = true;
        this.stragegyFn[this.strategy].report.process50(this.videoRaw, this._times);
      }
      if (e > 75 && !this.process75) {
        this.process75 = true;
        this.stragegyFn[this.strategy].report.process75(this.videoRaw, this._times);
      }
    });
    this.player.on('ended', () => {
      this.isPlaying = false;
      this.stragegyFn[this.strategy].report.videoPlayEnd(this.videoRaw, this._times);
      this.isPlayEnd = true;
      this.playResolve();
    });
    this.player.on('$videoClose', () => {
      this.isPlaying = false;
      this.stragegyFn[this.strategy].report.videoClose(this.videoRaw, this._times);
      this.isVideoIng = false;
      this.isPlayEnd = false;
      if (this.playSuccessCloseCb) {
        this.playSuccessCloseCb();
      }
      this.hide();
    });
  }

  // 请求视频的来源
  async getVideo(type = 1) {
    if (this.isVideoIng) {
      return;
    }
    this.reset();
    this.isVideoIng = true;
    this.strategy = 'dianxing';
    const res = await this.stragegyFn[this.strategy].getVideo(type);
    console.log(res);
    if (res) {
      // 上报app？
      if (window["helpbridge"] && window["helpbridge"].adShowing) window["helpbridge"].adShowing();
      this.videoRaw = res;
      const { url, appIcon, name, slogen, type } = this.stragegyFn[this.strategy].resolveParams(this.videoRaw);
      this.url = url;
      this.appContent = {
        appIcon,
        name,
        slogen,
        type
      }
      return true;
    } else {
      this.isVideoIng = false;
      return false;
    }
  }

  show() {
    this.el.style.display = 'block';
  }

  hide() {
    this.el.style.display = 'none';
  }

  play() {
    if (this.url) {
      this.show();
      this.player.load(this.url);
      if (this.appContent) {
        const starNum = [4, 4.5, 5][Math.floor(Math.random() * 3)];
        const commentNum = Math.floor(Math.random() * 5000 + 5000);
        const buttonText = this.appContent.type === 1 ? '立即下载' : '立即查看';
        this.player.emit('$landPageChangeApp',
          Object["assign"]({ starNum, buttonText, commentNum },
            this.appContent), true);
        this.player.emit('$footerPageChangeApp',
          Object["assign"]({ starNum, buttonText, commentNum },
            this.appContent), true);
      } else {
        this.player.emit('$landPageChangeApp', {}, null);
        this.player.emit('$footerPageChangeApp', {}, null);
      }
      this.player.emit('$videoReset');
      this.player.play();
      return this.playPromise;
    } else {
      this.isVideoIng = false;
      return Promise.reject(new Error('url 不存在'));
    }
  }
};

export default MyAdvideo;
