export enum CouponJoinScene{
    BlindBox=0,//盲盒
    //星级宝箱
    StarBox1,
    StarBox2,
    StarBox3,
    //通关
    Checkpoint,
    Buoy,
}
export interface CouponJoinOptions{
    scene:CouponJoinScene,//场景
    beforeUse:Function,//跳转前
    afterClose:Function,//关闭
}
export interface ShowTurnCircleOptions{
    afterClose:Function,//关闭转盘
}
interface ShowVideoOptions{
    afterClose:Function
}
interface ShowMeituanExchangeOptions{
    afterClose:Function
}
export default class Utils {
    constructor() {

    }

    /**
     * 获取连接上的参数，以对象的形式返回
     * @constructor
     */
    public static getRequest() {
        const url = location.search;   //获取url中"?"符后的字串
        let theRequest = {};
        if(url.indexOf("?") != -1) {
            let str = url.substr(1);
            let strs = str.split("&");
            for(let i = 0; i < strs.length; i++) {
                theRequest[strs[i].split("=")[0]] = unescape(strs[i].split("=")[1]);
            }
        }
        return theRequest;
    }

    /**
     * 通过Key获取连接上的参数
     * @param key
     */
    public static getRequestByKey(key: string) {
        return this.getRequest()[key];
    }

    /**
     * 时间戳转几时几分几秒
     * @param time 时间戳
     */
    public static convertTime(time: number) {
        let hour = ~~(time / 3600000);                              // 小时
        let min = ~~((time - hour * 3600000) / 60000);              // 分
        let sec = ~~((time - hour * 3600000 - min * 60000) / 1000); // 秒

        return {
            hour: Utils.prefixInteger(hour, 2),
            min: Utils.prefixInteger(min, 2),
            sec: Utils.prefixInteger(sec, 2)
        }
    }

    /**
     * 数字补0
     * @param num 数字
     * @param length 位数
     */
    public static prefixInteger(num, length) {
        return (Array(length).join('0') + num).slice(-length);
    }

    /**
     * 对象/数组 深拷贝
     * @param {Object} src - 来源对象
     * @param {Object} dst - 目标对象
     * @returns {Object} obj - 拷贝完成的对象
     */
    public static deepClone(src, dst = undefined) {
        if(src){
            return src;
        }
        let _obj = dst || (src instanceof Array ? [] : {});
        for(let key in src) {
            let prop = src[key];
            if(prop === _obj) { // 避免相互引用对象导致死循环，如src.a = dst的情况
                continue;
            }
            _obj[key] = ((typeof prop === 'object') ? this.deepClone(prop) : _obj[key] = prop);
            // if (typeof prop === 'object') { // 如果这是个对象则递归调用
            //     _obj[key] = _deepClone(prop);
            // } else {
            //     _obj[key] = prop;
            // }
        }
        return _obj;
    };

    /**
     * 产生一个固定范围的随机数(左闭右开)
     * @param start
     * @param end
     */
    public static Random(start: number, end: number) {
        return Math.random() * (end - start) + start;
    }

    /**
     * 产生一个固定范围的随机整数(左闭右开)
     * @param start
     * @param end
     */
    public static RandomInt(start: number, end: number) {
        return Math.floor(Math.random() * (end - start) + start);
    }

    /**
     * obj是否在array中
     * @param obj
     * @param array
     */
    public static isInArray(obj: any, array: any[]) {
        for(let i in array) {
            if(obj == array[i]) {
                return true;
            }
        }
        return false;
    }

    /**
     * 简单的碰撞检测
     * @param obj1
     * @param obj2
     */
    public static hitTest(obj1: any, obj2: any): boolean {
        let rect1: egret.Rectangle = obj1.getBounds();
        let rect2: egret.Rectangle = obj2.getBounds();
        rect1.x = obj1.x;
        rect1.y = obj1.y;
        rect2.x = obj2.x;
        rect2.y = obj2.y;
        return rect1.intersects(rect2);
    }

    //奖品相关弹窗
    static couponJoin(scene:CouponJoinScene,beforeUse=()=>{},afterClose=()=>{}):void{
        let options:CouponJoinOptions = {
            scene:scene,
            beforeUse:beforeUse,
            afterClose:afterClose
        }
        console.error("奖品弹窗点击===》",scene);
        beforeUse&&beforeUse();
        afterClose&&afterClose();
    }
    //展示大转盘
    static showTurnCircle(afterClose=()=>{}):void{
        let options:ShowTurnCircleOptions = {
            afterClose,
        }
        afterClose&&afterClose();
    }
    //打开视频
    static showVideo(afterClose=(suc)=>{}){
        let options:ShowVideoOptions = {
            afterClose,
        };
        afterClose&&afterClose(true);
    }
    //美团碎片弹窗
    static showMeituanExchange(afterClose=()=>{}){
        let options:ShowMeituanExchangeOptions = {
            afterClose,
        };
        afterClose&&afterClose();
    }
}