import { Data } from "../../Data";
import { ICustomOptionData } from "./ICustomOptionData";
import { IElementData } from "./IElementData";
import IcreditsConf from "./IcreditsConf";

export class ReconAjaxElementData extends Data {
    /**
     * 闯关信息
     */
    public throughCurrent: number;

    /**
     * 闯关模式
     */
    public throughMode: number;

    /**
     * 关卡ID
     */
    public throughNum: number;

    /**
     * 站点位置
     */
    public throughCurrentStep: number;

    /**
     * 弹层js
     */
    public jsTest: string;

    /**
     * 弹层css
     */
    public cssTest: string;

    /**
     * 活动规则
     */
    public rule: any;

    /**
     * 活动类型
     */
    public type: string;

    /**
     * 奖项列表
     */
    public options: ICustomOptionData[];


    /**
     * 页面展示信息
     */
    public element: IElementData;

    creditsConf: IcreditsConf;
    thanksOpt: ICustomOptionData;

    public update(result: any): void {
        if (!result) {
            return;
        }
        super.update(result);
        this.throughCurrent = result.throughCurrent;
        this.throughMode = result.throughMode;
        this.throughNum = result.throughNum;
        this.throughCurrentStep = result.throughCurrentStep;
        this.jsTest = result.jsTest;
        this.cssTest = result.cssTest;
        this.rule = result.rule;
        this.type = result.type;
        this.options = result.options;
        this.element = result.element;
        this.creditsConf = result.creditsConf;
        const thanksList = this.options.filter(opt => opt.prizeType == 'thanks');
        if (thanksList) this.thanksOpt = thanksList[0]
    }
}