import { ModuleTypes } from "../types/sceneTypes";
import Panel from "../components/Panel";
import Loading from "../components/Loading";
import wait from "../../new_tc/wait";

export default class PanelCtrl {
    addToShowPanels(panelName: string) {
        this._panels.unshift(panelName);
    }

    _params: any[]
    private _panels: any[]
    _callback: any;

    showPanels(panels: any[], params: any[], callback: Function) {
        this._panels = panels;
        this._params = params;
        this._callback = callback;
        if(panels.length <= 0) {
            this._callback();
            this._callback = null;
        }
        if(this._panels.length <= 0) return;
        const panel = this._panels.shift();
        const param = this._params.shift();
        PanelCtrl.instance.show(panel, param);
    }

    checkPanels() {
        if(this._panels && this._panels.length <= 0) {
            this._panels = [];
            if(this._callback) this._callback();
        }
        if(!this._panels || this._panels.length <= 0) return;
        wait(300);
        const panel = this._panels.shift();
        const param = this._params.shift();
        PanelCtrl.instance.show(panel, param);
    }

    private _parent: egret.Sprite;
    _mask: egret.Sprite;
    static _instance: PanelCtrl;
    static get instance() {
        return PanelCtrl._instance || (PanelCtrl._instance = new PanelCtrl())
    }

    init(parent: egret.Sprite) {
        this._parent = parent;
    }

    private noLoadingList = ['StartPanel', 'StartPanelNew', 'failed', 'prize2', ModuleTypes.PRIZE_PANEL, ModuleTypes.NO_PRIZE_PANEL];

    show(type: any, data?) {
        this.closeCurrent(true);
        const cls = this._panelClassMap[type];
        const panel: Panel = new cls(data);
        this.addMask();
        if(!window['development']) {
            if(this.noLoadingList.indexOf(type) == -1)
                Loading.instace.show();
            const key = panel.skinKey.toLowerCase();
            const reskey = panel.skinResKey || key;
            const p = Promise.all([RES.getResAsync(`${reskey}_json`), RES.getResAsync(`${reskey}_png`)]);
            p.then(() => {
                Loading.instace.hide();
                this.showAfterLoadAtlas(panel, data);
            })
        } else {
            this.showAfterLoadAtlas(panel, data);
        }
        return panel;
    }

    showAfterLoadAtlas(panel: Panel, data) {
        panel.loadSkin();
        this._current = panel;
        panel.start(data);
        this.add(panel);
        // egret.Tween.get(panel).set({ y: -200 }).to({ y: 0 }, 500, egret.Ease.quartOut);
        panel.onShowAnim();
    }

    addMask() {
        if(!this._mask) {
            this._mask = new egret.Sprite();
            this._mask.touchEnabled = true;
            this._mask.graphics.beginFill(0, .7);
            this._mask.graphics.drawRect(0, 0, 750, 1624);
            this._mask.graphics.endFill();
        }
        this._mask.alpha = 1;
        this._parent.addChild(this._mask);
    }

    removeMask(rightNow = false) {
        if(this._mask) {
            if(rightNow) {
                this._parent.removeChild(this._mask);
            } else
                egret.Tween.get(this._mask).to({alpha: 0}, 300, egret.Ease.quartIn).call(
                    () => this._parent.removeChild(this._mask), this);
        }
    }

    private add(panel: Panel) {
        this._parent.addChild(panel);
        panel.addEventListener('onDestroy', this.onPanelHide, this);
    }

    private remove(panel: Panel, rightNow = true) {
        if(rightNow) {
            this._parent.removeChild(panel);
            this.removeMask(rightNow);
            return;
        }
        const tw = egret.Tween.get(panel);
        tw.to({y: panel.stage.stageHeight}, 300, egret.Ease.quartIn)
            .call(() => {
                this._parent.removeChild(panel);
                this.removeMask();
            }, this);
    }

    private onPanelHide(e: egret.Event) {
        const panel = e.target as Panel;
        panel.removeEventListener('onDestroy', this.onPanelHide, this);
        this.remove(panel);
        this._current = null;
        this.checkPanels();
    }

    private _panelClassMap: any;

    registerPanel(name, config) {
        this._panelClassMap = this._panelClassMap || {};
        this._panelClassMap[name] = config.cls;
    }


    _current: Panel;

    closeCurrent(rightNow = false) {
        if(this._current) {
            this.remove(this._current, rightNow);
            this._current = null;
        }
    }
}