import { HtmlTextParser } from "../HtmlTextParser";
import Panel from "./Panel";
import { loadSvga } from "../../../src/loadSvga";
import getResPath from "../../new_tc/getResPath";
import PanelCtrl from "../ctrls/panelCtrl";

export default class TurnRulePanel extends Panel {
    public labContent: eui.Label;
    public scroller: eui.Scroller;
    start() {
        super.start();

        this.addRule();
    }

    group: eui.Group;
    private addRule() {
        const text = `<br>抽奖说明
1、游戏期间，用户每成功闯过5个新关卡即可获得1次免费抽奖机会，免费抽奖机会可累计。
2、若免费抽奖机会全部用完，玩家还可以使用元宝进行抽奖。
3、转盘为概率中奖；奖励有红包、刮刮卡、体力、元宝、随机道具共5种奖励类型。
4、发放的奖励请在规定的有效时间内尽快领取或使用，逾期未领取或使用的会失效哦。
5、活动过程中，凡以不正当手段（包括但不限于作弊、恶意套现、扰乱系统、网络攻击等违规行为）参与本次活动的用户，苏宁易购有权终止其参加活动，并取消其获得奖励的资格。
6、极少数特殊情况下，若用户在完成活动的任务中被系统判定异常账户或风控账户，则可能导致奖励发放异常。
7、如遇不可抗力（包括但不限于重大自然灾害事件、活动受政府机关指令需要停止举办或调整的、活动遭受严重网络攻击不能正常进行的），苏宁易购有权取消、修改或暂停活动。<br>`;

        this.labContent.textFlow = (new HtmlTextParser).parser(text);
    }
    onTouchTap_closeBtn() {
        super.onTouchTap_closeBtn();
        loadSvga(getResPath() + 'resource/assets/svgas/turntable.svga').then(async (mv: any) => {
            // await wait(100);
            PanelCtrl.instance.show('turnTable', { mv: mv });
        })
    }
    get skinKey() { return 'TurnRule' }
}