
import { getlogItem } from "../../../src/Main";
import { addRankFriendList } from "../../../src/mapScene/RankFriendList";
import { changeMapScene } from "../../../src/startScene/StartScene";
import wait from "../../new_tc/wait";
import { DataManager } from "../../tw/manager/DataManager";
import { NetManager } from "../../tw/manager/NetManager";
import Panel from "./Panel";
import { handleVideo } from "../../../src/myVideo/videoCtrl";
import handleInspireVideo from "../../../src/inspireVideo";
import Loading from "./Loading";
import { showToast } from "../ctrls/toastCtrl";

export default class PrizePanel extends Panel {
    _level;

    updateOption(option: any) {
        const { categoryType, img, num, propType, realValue } = option;// 2次数  3道具 4元宝 5实物 6优惠券 7虚拟商品

        this['propnums'].text = 'x1';
        this['propnums2'].text = 'x1';
        if (num) {
            this['propnums'].text = 'x' + num;
            this['propnums2'].text = 'x' + num;
        }
        switch (categoryType) {
            case 2:
                this['blood'].visible = true;
                this['numsgroup'].visible = true;
                break;
            case 3:
                this['numsgroup'].visible = true;
                this['img2'].visible = true;
                this.data.url2 = `common_prop${propType}_png`;
                break;
            case 4:
                this['numsgroup'].visible = false;
                this['propnums2'].visible = true;
                this['money'].visible = true;
                this['propnums2'].text = realValue;
                break;
            default:
                this['img'].visible = true;
                this.data.url = img;
                break;
        }
    }

    start(data) {
        super.start();
        console.log('initscreen')
        this.initTTScreen()
        this._level = parseInt(data.level + '');
        this['lvTxt'].text = `关卡${this._level}`

        this.updateOption(data.option);

        this['goBtn'].addEventListener(egret.TouchEvent.TOUCH_TAP, () => {
            this.hidePanel();
            if (this._level + 1 <= window['last_level'])
                changeMapScene({ level: this._level + 1 });
            else
                changeMapScene();
        }, this);

        NetManager.ins.hc_home(() => { }, window['collectRuleId']);

        const hc_submitData = DataManager.ins.getData('hc_submit').data;

        this.setStar(hc_submitData.stars);

        addRankFriendList(84, 889.74, this);

        //曝光
        NetManager.ins.showLog(getlogItem(5))

        //新增看视频双倍
        this["doubleBtn"].addEventListener(egret.TouchEvent.TOUCH_TAP, () => {
            NetManager.ins.clickLog(getlogItem(6))
            handleInspireVideo(
                (s) => {
                    if (s) {
                        //居中
                        this['goBtn'].horizontalCenter = 0;
                        //隐藏
                        this['doubleBtn'].visible = false;
                        Loading.instace.show()
                        NetManager.ins.getIncentiveAward(
                            (s) => {
                                Loading.instace.hide()
                                if (s) {
                                    showToast("翻倍成功");
                                    NetManager.ins.hc_home(() => {
                                    }, window['collectRuleId']);
                                } else {
                                    showToast("加倍失败");
                                }
                            },
                            25
                        )
                    } else {
                        showToast("广告未成功观看，无法加倍领取");
                    }
                },
                () => {
                    NetManager.ins.getIncentiveAward(
                        () => { },
                        25
                    )
                },
                window["slotid"]
            )
        }, this)
    }

    initTTScreen() {
        // 插屏互动已经调用的次数
        const configData = DataManager.ins.getData('getConfig')
        const surplusNum = configData.data.num
        if (surplusNum && surplusNum <= 3) {
            // 每天在通过成功后只出3次插屏互动
            NetManager.ins.getUserConfig(() => {})
            const signConfigData = configData.data.list.filter(item => item.id === 5)
            if (signConfigData.length) {
                if (signConfigData[0].index === 0) {
                    window['bridge'] && window['bridge']["showGamerAd"] && window['bridge']["showGamerAd"](window["TTPauseScreen"], 3)
                } else if (signConfigData[0].index === 1) {
                    window['bridge'] && window['bridge']["showGamerAd"] && window['bridge']["showGamerAd"](window["TAPauseScreen"], 4)
                }
            }
        }
    }

    async setStar(nums: number) {
        this['pic1'].visible = this['pic2'].visible = this['pic3'].visible = false;
        // this['light'].visible = false;
        await wait(500);
        if (nums == 1) {
            this['pic1'].visible = true;
            await this.playAni1();
        }
        if (nums == 2) {
            this['pic1'].visible = true;
            await this.playAni1();
            this['pic2'].visible = true;
            await this.playAni2();
        }
        if (nums == 3) {
            this['pic1'].visible = true;
            await this.playAni1();
            this['pic2'].visible = true;
            await this.playAni2();
            this['pic3'].visible = true;
            await this.playAni3();
        }
        if (nums >= 1) {
            // this['light'].visible = false;
            // egret.Tween.get(this['light']).set({ scaleX: 0, scaleY: 0, alpha: 0, }).to({ scaleX: 1, scaleY: 1, alpha: 1 }, 300).call(() => {
            //     egret.Tween.get(this['light'], { loop: true }).to({ rotation: 360 }, 3000);
            // });
        }

    }

    async playAni1() {
        return new Promise(r => {
            egret.Tween.get(this['pic1']).set({ scaleX: 0, scaleY: 0 }).to({ scaleX: -1, scaleY: 1 }, 400, egret.Ease.getBackOut(1)).call(r)
        })
    }
    async playAni2() {
        return new Promise(r => {
            egret.Tween.get(this['pic2']).set({ scaleX: 0, scaleY: 0 }).to({ scaleX: 1, scaleY: 1 }, 400, egret.Ease.getBackOut(1)).call(r)
        })
    }
    async playAni3() {
        return new Promise(r => {
            egret.Tween.get(this['pic3']).set({ scaleX: 0, scaleY: 0 }).to({ scaleX: 1, scaleY: 1 }, 400, egret.Ease.getBackOut(1)).call(r)
        })
    }

    destroy() {
        super.destroy();
        // egret.Tween.removeTweens(this['light']);
    }

    onTouchTap_closeBtn(): any {
        super.onTouchTap_closeBtn();
        changeMapScene();
    }

    get picBigWidth() { return 510 };
    get bigPicRatio() { return 640 / 300 }

    img: eui.Image;
    useBtn: eui.Button;
    get skinKey() { return 'Prize' }

    protected get closeBtns(): eui.Button[] { return [this['closeBtn']] }
}