// tslint:disable: no-var-keyword
// tslint:disable: prefer-const
import { loadSvga } from "../../src/loadSvga";
import MainScene from "../../src/mainScene/MainScene";
import MapScene from "../../src/mapScene/MapScene";
import BloodPanel from "../../src/panels/BloodPanel";
import Box2Panel from "../../src/panels/Box2Panel";
import BoxPanel from "../../src/panels/BoxPanel";
import Buy1Panel from "../../src/panels/Buy1Panel";
import Buy2Panel from "../../src/panels/Buy2Panel";
import Buy3Panel from "../../src/panels/Buy3Panel";
import FailedPanel from "../../src/panels/FailedPanel";
import { getlogItem } from "../../src/Main";
import GoldPanel from "../../src/panels/GoldPanel";
import Prize2Panel from "../../src/panels/Prize2Panel";
import QuitPanel from "../../src/panels/QuitPanel";
import ShopPanel from "../../src/panels/ShopPanel";
import SignPanel from "../../src/panels/SignPanel";
import StartPanel from "../../src/panels/StartPanel";
import StartPanelNew from "../../src/panels/StartPanelNew";
import { getSoundOn, playBg, stopBg } from "../../src/soundCtrl";
import { playGameBg, stopGamebg } from "../../src/soundCtrl2";
import StartScene from "../../src/startScene/StartScene";
import getResPath from "../new_tc/getResPath";
import { DataManager } from "../tw/manager/DataManager";
import { NetManager } from "../tw/manager/NetManager";
import { Buried } from "../tw/util/Buried";
import AssetAdapter from "./adapter/AssetAdapter";
import ThemeAdapter from "./adapter/ThemeAdapter";
import Alert from "./components/Alert";
import Loading from "./components/Loading";
import NoPrizePanel from "./components/NoPrizePanel";
import PrizePanel from "./components/PrizePanel";
import RulePanel from "./components/RulePanel";
import PanelCtrl from "./ctrls/panelCtrl";
import SceneCtrl from "./ctrls/sceneCtrl";
import { ModuleTypes } from "./types/sceneTypes";
import layers from "./views/layers";
import SignPrizePanel from "../../src/panels/SignPrizePanel";
import getHomeData, { BLOOD_NUMS_MAX } from "../../src/getHomeData";
import BloodPanel2 from "../../src/panels/BloodPanel2";
import ExchangePanel from "../../src/panels/ExchangePanel";
import { initstatistics } from "../../src/statistics";
import ADPanel from "../../src/panels/ADPanel";
import FriendPanel from "../../src/panels/FriendPanel";
import BagPanel from "../../src/panels/BagPanel";
import BagQuitPanel from "../../src/panels/BagQuitPanel";
import getRedBombAward from "../../src/getRedBombAward";
import BombTipsPanel from "../../src/panels/BombTipsPanel";
import RedBombRule from "../../src/panels/RedBombRule";
import RedBombAlertPanel from "../../src/panels/RedBombAlertPanel";
import { GFun } from "../tc/util/GFun";
import { GDispatcher } from "../tc/util/GDispatcher";
import DailyIconPrizePanel from "../../src/panels/DailyIconPrizePanel";
import VideoBuyPanel from "../../src/panels/VideoBuyPanel";

export default class MainBase extends eui.UILayer {
    constructor() {
        super();
        // 等待开屏广告结束之后再放背景音乐
        stopGamebg()
        // 注册和客户端通信的方法
        this.initNativeEvent()
        Loading.instace.loadImage();
        DataManager.ins.customCfgData = window['CFG'];
        this.getData();

    }

    protected registerModules() {
        const panels = [
            [ModuleTypes.ALERT_PANEL, { cls: Alert }],

            [ModuleTypes.RULE_PANEL, { cls: RulePanel }],
            [ModuleTypes.PRIZE_PANEL, { cls: PrizePanel }],
            [ModuleTypes.NO_PRIZE_PANEL, { cls: NoPrizePanel }],
            ['bag', { cls: BagPanel }],
            ['bagquit', { cls: BagQuitPanel }],
            ['bloodPanel', { cls: BloodPanel }],
            ['blood2Panel', { cls: BloodPanel2 }],
            ['GoldPanel', { cls: GoldPanel }],
            ['Shop', { cls: ShopPanel }],
            ['StartPanel', { cls: StartPanel }],
            ['StartPanelNew', { cls: StartPanelNew }],
            ['Buy1', { cls: Buy1Panel }],
            ['Buy2', { cls: Buy2Panel }],
            ['Buy3', { cls: Buy3Panel }],
            ['ExchangePanel', { cls: ExchangePanel }],
            ['failed', { cls: FailedPanel }],
            ['quit', { cls: QuitPanel }],
            ['box', { cls: BoxPanel }],
            ['box2', { cls: Box2Panel }],
            ['prize2', { cls: Prize2Panel }],
            ['sign', { cls: SignPanel }],
            ['signPrize', { cls: SignPrizePanel }],


            ['friend', { cls: FriendPanel }],
            ['ad', { cls: ADPanel }],
            ['BombTipsPanel', { cls: BombTipsPanel }],
            ['RedBombAlert', { cls: RedBombAlertPanel }],
            ['RedBombRule', { cls: RedBombRule }],

            ['DailyIconPrizePanel', { cls: DailyIconPrizePanel }],
            ['VideoBuyPanel', { cls: VideoBuyPanel }],
        ];

        const scenes = [
            [ModuleTypes.START_SCENE, { cls: StartScene }],
            [ModuleTypes.MAP_SCENE, { cls: MapScene }],
            [ModuleTypes.MAIN_SCENE, { cls: MainScene }]
        ];

        panels.forEach(item => PanelCtrl.instance.registerPanel(item[0], item[1]));
        scenes.forEach(item => SceneCtrl.instance.registerScene(item[0], item[1]));

        // NetManager.ins.onNotSuccess = (msg) => {
        //    s
        // }
    }

    protected getData() {

    }

    protected initNativeEvent() {
        return;
        // 穿山甲广告位
        // 首页&游戏中banner
        // window["TTIndexBanner"] = '945073403'
        window["TTIndexBanner"] = '945071317'
        // 暂停插屏广告
        // window["TTPauseScreen"] = '945073404'
        window["TTPauseScreen"] = '945071320'
        // 首页悬浮激励视频广告
        // window["TTIndexVideo"] = '945073405'
        window["TTIndexVideo"] = '945071324'
        // 其他位置激励视频广告
        // window["TTOtherVideo"] = '945073406'
        window["TTOtherVideo"] = '945071326'

        // 推啊广告位
        // 首页激励互动广告位
        window["TAInspireAct"] = '328186'
        // 签到抽奖插屏广告位
        window["TASignScreen"] = '328296'
        // 暂停插屏广告位
        window["TAPauseScreen"] = '328297'
        // 激励视频兜底广告位
        window["TAInspireOther"] = '328189'
        if (typeof window['bridge'] !== 'object') return false
        // 开屏广告结束后的回调
        window["openFinished"] = window['bridge']["openFinished"] = () => {
            playGameBg()
        }
        // 首页banner点击埋点
        window["IndexBannerClickLog"] = window['bridge']["IndexBannerClickLog"] = () => {
            NetManager.ins.clickLog(getlogItem(15))
        }
        // 首页banner展示埋点
        window["IndexBannerShowLog"] = window['bridge']["IndexBannerShowLog"] = () => {
            NetManager.ins.showLog(getlogItem(15))
        }
        // 游戏页面banner点击埋点
        window["GameBannerClickLog"] = window['bridge']["GameBannerClickLog"] = () => {
            NetManager.ins.clickLog(getlogItem(16))
        }
        // 游戏页面banner展示埋点
        window["GameBannerShowLog"] = window['bridge']["GameBannerShowLog"] = () => {
            NetManager.ins.showLog(getlogItem(16))
        }
        // 激励视频成功加载
        window["TTVideoLoadSucc"] = window['bridge']["TTVideoLoadSucc"] = () => {
            NetManager.ins.clickLog(getlogItem(21, 2))
        }
        // 激励视频成功曝光
        window["TTVideoShow"] = window['bridge']["TTVideoShow"] = () => {
            NetManager.ins.showLog(getlogItem(22, 2))
        }
        // 激励视频广告点击
        window["TTVideoClick"] = window['bridge']["TTVideoClick"] = () => {
            NetManager.ins.clickLog(getlogItem(23, 2))
        }
        // 激励视频关闭点击
        window["TTVideoClose"] = window['bridge']["TTVideoClose"] = () => {
            NetManager.ins.clickLog(getlogItem(24, 2))
        }
        // 激励视频endcard曝光
        window["TTVideoEndcardShow"] = window['bridge']["TTVideoEndcardShow"] = () => {
            NetManager.ins.showLog(getlogItem(25, 2))
        }
        // 激励视频endcard点击
        window["TTVideoEndcardClick"] = window['bridge']["TTVideoEndcardClick"] = () => {
            NetManager.ins.clickLog(getlogItem(26, 2))
        }
    }

    protected createChildren(): void {
        super.createChildren();
        egret.lifecycle.addLifecycleListener((context) => {
            // custom lifecycle plugin
        })

        egret.lifecycle.onPause = () => {
            // egret.ticker.pause();
        }

        egret.lifecycle.onResume = () => {
            // egret.ticker.resume();
        }

        //inject the custom material parser
        //注入自定义的素材解析器
        const assetAdapter = new AssetAdapter();
        egret.registerImplementation("eui.IAssetAdapter", assetAdapter);
        egret.registerImplementation("eui.IThemeAdapter", new ThemeAdapter());

        egret.ImageLoader.crossOrigin = "anonymous";

        layers.init(this);
        Loading.init(layers.topLayer);
        Loading.instace.show();

        PanelCtrl.instance.init(layers.popupLayer);
        SceneCtrl.instance.init(layers.sceneLayer);

        this.stage.scaleMode = egret.StageScaleMode.FIXED_WIDTH;

        this.registerModules();

        Loading.instace.show();

        RES.setMaxLoadingThread(10);
        this.runGame().catch(e => {
            console.log(e);
        })
    }

    // tslint:disable-next-line: cyclomatic-complexity
    private async runGame() {
        await this.loadResource();
        RES.getResAsync('mapBg_mp3');
        RES.getResAsync(`nums_png`);
        RES.getResAsync(`sharenums_fnt`);
        RES.getResAsync(`nums_fnt`);
        RES.getResAsync(`nums2_png`);
        RES.getResAsync(`nums2_fnt`);
        RES.getResAsync(`nums3_png`);
        RES.getResAsync(`nums3_fnt`);
        if (!window['development']) {
            RES.getResAsync(`common_json`);
        }
        else {
            //common新加的
            RES.getResAsync("videoCloseBtn_png");
            RES.getResAsync("volumeBtn_png");
            RES.getResAsync("downloadBtn_png");

            RES.getResAsync('mapredbagicom_png');
            RES.getResAsync('maplight2_png');
            RES.getResAsync('main_mapbottom_png');
            RES.getResAsync('lightani_png');

            for (var i = 1; i < 19; i++) {
                RES.getResAsync("boom" + i + "_png")
            }
            for (var i = 0; i < 5; i++) {
                RES.getResAsync("ele" + i + "_png")
                RES.getResAsync("ele" + i + "Line" + "_png")
                RES.getResAsync("ele" + i + "Exp" + "_png")
            }
            for (var i = 1; i <= 27; i++) {
                RES.getResAsync("bonusFra" + i + "_png")
            }
            for (var i = 1; i <= 13; i++) {
                RES.getResAsync("eleDis" + i + "_png")
            }
            for (var i = 2; i <= 6; i++) {
                RES.getResAsync("ice" + i + "_png")
            }
            for (var i = 2; i <= 6; i++) {
                RES.getResAsync("rock" + i + "_png")
            }
            for (var i = 0; i <= 9; i++) {
                RES.getResAsync("scoreNumber" + i + "_png")
            }
            for (var i = 0; i <= 9; i++) {
                RES.getResAsync("stepNumber" + i + "_png")
            }
            for (var i = 0; i <= 9; i++) {
                RES.getResAsync("targetNumber" + i + "_png")
            }
            for (var i = 0; i <= 9; i++) {
                RES.getResAsync("propNum" + i + "_png")
            }
            for (var i = 0; i <= 9; i++) {
                RES.getResAsync("chapterNum" + i + "_png")
            }
            // for (var i = 1; i <= 5; i++) {
            //     RES.getResAsync("guideTxt" + i + "_png")
            // }
            for (var i = 1; i <= 11; i++) {
                RES.getResAsync("stepAni" + i + "_png")
            }

            var aaa = [1, 3, 5, 7, 9, 11, 14, 16, 18, 19, 21, 23, 25, 27, 29, 32, 34];
            for (var i = 1; i <= 60; i++) {
                if (aaa.indexOf(i) >= 0) {
                    RES.getResAsync("exLighting" + i + "_png")
                }
            }
            for (var i = 0; i <= 2; i++) {
                RES.getResAsync("eggStatus" + i + "_png")
            }
            for (var i = 1; i <= 5; i++) {
                RES.getResAsync("eggPiece" + i + "_png")
            }
            for (var i = 0; i <= 4; i++) {
                RES.getResAsync("bubleEle" + i + "_png")
            }
            for (var i = 1; i <= 19; i++) {
                RES.getResAsync("bubbleStar" + i + "_png")
            }
            for (var i = 1; i <= 11; i++) {
                RES.getResAsync("hairballPiece" + i + "_png")
            }
            for (var i = 0; i <= 9; i++) {
                RES.getResAsync("curScoreNum" + i + "_png")
            }
            for (var i = 5; i <= 15; i++) {
                RES.getResAsync("ele" + i + "_png")
            }
            for (var i = 1; i <= 10; i++) {
                RES.getResAsync("fesEleSmallDis" + i + "_png")
            }
            for (var i = 1; i <= 13; i++) {
                RES.getResAsync("lineLight" + i + "_png")
            }
            //三个星星宝箱
            RES.getResAsync("starbox1_png");
            RES.getResAsync("starbox2_png");
            RES.getResAsync("starbox3_png");

            var arr = [
                "redDoorBg", "blueDoorBg", "yellowDoorBg", "doorOpen", "doorClosed",
                "rectLatWhite",
                "fesRedBigLight", "fesRedBombSta1", "fesRedCap", "fesRedDown", "fesRedSmallLight", "fesRedUp", "xingxingbi",
                "tinyRedLeft", "tinyRedMid", "tinyRedRight",
                "festivalTargetBg",
                "hairballDisBg",
                "brownBallFace",
                "greyBallFace",
                "eyeDownLeft",
                "eyeDownRight",
                "eyeSingle",
                "yellowCircleDown",
                "yellowCircleUp",
                "greenCircleDown",
                "greenCircleUp",
                "jellyArrow",
                "lockVine",
                "guidePropHand",
                "guidePropCow",
                "guidePropMsgPanel",
                "guidePropShoe",
                "guidePropHammer",
                "guidePropBoom",
                "道具",
                "recordbtn",
                "lionMsgBg",
                "guideBox",
                "msgTri",
                "guideOver",
                "guideLove",
                "guideLevel",
                "guideMoney",
                "bonusTime",
                "boomBtn",
                "hammerBtn",
                "stepBtn",
                "propNumBg",
                // "guideBg",
                // "guideKnowBtn",
                "bonusShoot",
                "leftArrow",
                "chooseRect",
                "lightedStar",
                "lineLight",
                // "lockDown",
                // "lockUp",
                "magicLion",
                "magicLionBg",
                "rectLat",
                "rightArrow",
                "rightMark",
                "unlightedStar",
                "mainSoundBtnOff",
                "mainMusicBtnOff",
            ]
            for (var i = 0; i < arr.length; i++) {
                RES.getResAsync(arr[i] + "_png")
            }

        }
        this.createGameScene();
    }
    private svgaList = [];
    private async loadResource() {
        try {
            await RES.loadConfig("default.res.json", getResPath() + "resource/");
            await this.loadTheme();
            this.svgaList = await Promise.all([
                loadSvga(getResPath() + 'resource/assets/svgas/loading_progress.svga'),
                loadSvga(getResPath() + 'resource/assets/svgas/loading_animals.svga'),
                loadSvga(getResPath() + 'resource/assets/svgas/loading_title.svga')
            ]);
            loadSvga(getResPath() + 'resource/assets/svgas/box.svga');
            loadSvga(getResPath() + 'resource/assets/svgas/invite.svga');
            loadSvga(getResPath() + 'resource/assets/svgas/turntable.svga');
            loadSvga(getResPath() + 'resource/assets/svgas/turnprize.svga');
            loadSvga(getResPath() + 'resource/assets/svgas/sprize.svga');
        }
        catch (e) {
            console.error(e);
        }
    }

    private loadTheme() {
        return new Promise((resolve, reject) => {
            // load skin theme configuration file, you can manually modify the file. And replace the default skin.
            //加载皮肤主题配置文件,可以手动修改这个文件。替换默认皮肤。
            const theme = new eui.Theme("resource/default.thm.json", this.stage);
            theme.addEventListener(eui.UIEvent.COMPLETE, () => {
                resolve();
            }, this);

        })
    }

    getAd() {
        return new Promise((r) => {
            NetManager.ins.hc_advert(() => {
                r();
            })
        });
    }



    ajaxElement() {
        return new Promise((r) => {
            NetManager.ins.ajaxElement(async () => {
                r();
            });
        });
    }
    hcRedBoobBaseInfo() {
        return new Promise((r) => {
            NetManager.ins.hc_redBombBaseInfo(async () => {
                r();
            });
        });
    }

    hcHome() {
        return new Promise((r) => {
            NetManager.ins.hc_home(() => {
                r()
            }, window['collectRuleId']);
        });
    }

    hc_userConfig() {
        return new Promise((r) => {
            NetManager.ins.getUserConfig(() => {
                r()
            }, 1);
        });
    }

    hc_userInfo() {
        return new Promise((r) => {
            NetManager.ins.hc_userInfo(() => {
                r()
            });
        })
    }

    protected async createGameScene() {
        window['getaward'] = () => { getRedBombAward((param) => { console.log(param) }) }
        await Promise.all([
            // this.getAd(),//广告，去掉
            this.ajaxElement(),
            this.hcHome(),
            this.hc_userConfig()
            // this.hcRedBoobBaseInfo(),
        ]);

        MapScene.adData = DataManager.ins.getData('hc_advert');

        Buried.init();
        ///////////
        SceneCtrl.instance.change(ModuleTypes.START_SCENE, this.svgaList);

        //分享信息，去掉
        // NetManager.ins.getShareInfo(() => {
        //     const result = DataManager.ins.getData('getShareInfo');
        //     window['registerWX'](result);
        // });
        updateMainTimer();

        //注释，页面停留时间
        initstatistics();
        // document.addEventListener("visibilitychange", () => {

        //     if (document.visibilityState == "visible") {

        //         if (getSoundOn()) {
        //             if (SceneCtrl.instance.currentScene instanceof MapScene)
        //                 playBg();
        //             else if (SceneCtrl.instance.currentScene instanceof MainScene)
        //                 playGameBg();
        //         }

        //         // if(timerInit) {
        //         NetManager.ins.hc_home(() => {
        //             updateMainTimer();
        //             //更新bloodpanel和mapscene
        //             const currentScene = SceneCtrl.instance.currentScene;
        //             if (currentScene && currentScene['updateTimerView'])
        //                 currentScene['updateTimerView']();
        //             const current = PanelCtrl.instance._current;
        //             if (current && current['updateTimerView'])
        //                 current['updateTimerView']();
        //         }, window['collectRuleId']);
        //         // }

        //         GDispatcher.dispatchEvent('docVisible');    // 触发document显示事件
        //     }

        //     if (document.visibilityState == "hidden") {
        //         stopBg();
        //         stopGamebg();

        //         GDispatcher.dispatchEvent('docHide');   // 触发document隐藏事件
        //     }
        // })

        window["webviewHide"] = () => {
            stopBg();
            stopGamebg();
        }
        window["webviewShow"] = () => {
            if (getSoundOn()) {
                if (SceneCtrl.instance.currentScene instanceof MapScene)
                    playBg();
                else if (SceneCtrl.instance.currentScene instanceof MainScene)
                    playGameBg();
            }

            // if(timerInit) {
            NetManager.ins.hc_home(() => {
                updateMainTimer();
                //更新bloodpanel和mapscene
                const currentScene = SceneCtrl.instance.currentScene;
                if (currentScene && currentScene['updateTimerView'])
                    currentScene['updateTimerView']();
                const current = PanelCtrl.instance._current;
                if (current && current['updateTimerView'])
                    current['updateTimerView']();
            }, window['collectRuleId']);
        }
    }
}
// let timerInit=false;
// export const initTimer = ()=>{
//     if(timerInit) return;
//     timerInit=true;
//     const data = getHomeData();
//     if(data.refectionCountdown==0) data.refectionCountdown = 2;
//     data.refectionCountdown += Math.floor(new Date().getTime()/1000);
//     updateMainTimer();
// }
const updateTimerAndView = () => {
    NetManager.ins.hc_home(() => {
        updateMainTimer();
        //更新bloodpanel和mapscene
        const currentScene = SceneCtrl.instance.currentScene;
        if (currentScene && currentScene['updateTimerView'])
            currentScene['updateTimerView']();
        const current = PanelCtrl.instance._current;
        if (current && current['updateTimerView'])
            current['updateTimerView']();
    }, window['collectRuleId']);
}

const timer = new egret.Timer(1000);
timer.addEventListener(egret.TimerEvent.TIMER_COMPLETE, () => {
    updateTimerAndView();
}, this)
export const mainTimer = timer;
export const updateMainTimer = () => {
    const data = getHomeData();
    if (data.remainEnargy >= BLOOD_NUMS_MAX) {
        mainTimer.stop();
    } else {
        mainTimer.reset();
        const left = data.refectionCountdown - Math.floor(new Date().getTime() / 1000);
        mainTimer.repeatCount = left;
        if (left > 0)
            mainTimer.start();
        else if (left == 0) {
            updateTimerAndView();
        }
        else
            console.error('data error')
    }
}

export const updateMainTimerAfterGetData = () => {
    NetManager.ins.hc_home(() => {
        updateMainTimer();
    }, window['collectRuleId']);
}