import { BitmapNumber } from "../class/BitmapNumber";
import { Tool } from "../Tool";

/**
 * 道具数量，两位
 */
export class PropNumber extends egret.DisplayObjectContainer {

    /**
     * 数字，最大99
     */
    private _num: number;
    get num(): number {
        return this._num
    }
    set num(value: number) {
        if (value == this._num) return;
        this._num = value;
        var arr = Tool.returnTO(value);
        if (arr.length > 2) arr = [9, 9];
        this.ones.num = arr[0];
        if (arr[1]) {
            this.tens.visible = true;
            this.tens.num = arr[1];
        } else {
            this.tens.visible = false;
        }
        //居中适配
        this.center()
    }
    /**
     * 个位
     */
    private ones: BitmapNumber;
    /**
     * 十位
     */
    private tens: BitmapNumber;
    constructor() {
        super();
        this.ones = new BitmapNumber("propNum");
        this.tens = new BitmapNumber("propNum");
        this.addChild(this.ones)
        this.addChild(this.tens)
        this.num = 0;
    }

    /**
     * 居中位置
     */
    center() {
        if (this.tens.visible) {
            this.ones.x = 0;
            this.tens.x = - this.tens.texture.textureWidth;
        } else {
            this.ones.x = -this.ones.texture.textureWidth / 2
        }
    }
}