import { ElementType } from "../enum/ElementType";
import { TargetNumber } from "./TargetNumber";

/**
 * 通关目标是元素时的单个元素的ui
 * 
 */
export class ElementTarget extends egret.DisplayObjectContainer {
    /**
     * 元素类型
     */
    type: ElementType;
    /**
     * 打勾完成
     */
    zeroMark: egret.Bitmap;
    /**
     * 数量文案
     */
    private countNum: TargetNumber;
    /**
     * 数量
     */
    private _count: number;
    get count(): number {
        return this._count;
    }
    set count(value: number) {
        if (value <= 0) {
            value = 0;
            this.countNum.visible = false;
            this.zeroMark.visible = true;
        }
        this._count = value;
        this.countNum.num = value;
    }
    constructor(type: ElementType) {
        super()
        var texture: egret.Texture = RES.getRes("ele" + type + "_png");
        var showImage = new egret.Bitmap(texture);
        showImage.scaleX = showImage.scaleY = 0.7
        this.addChild(showImage);
        var texture: egret.Texture = RES.getRes("rightMark_png");
        this.zeroMark = new egret.Bitmap(texture);
        this.zeroMark.x = 35;
        this.zeroMark.y = 35;
        this.zeroMark.visible = false;
        this.addChild(this.zeroMark);
        this.countNum = new TargetNumber();
        this.countNum.x = 55;
        this.countNum.y = 45;
        this.addChild(this.countNum);
    }
}