
/**
 * 供重复利用的位图类
 * 锚点都移到中心点的
 */
export class BitmapRecycle extends egret.Bitmap {
    constructor(texture: egret.Texture) {
        super(texture);
        this.anchorOffsetX = texture.textureWidth / 2;
        this.anchorOffsetY = texture.textureHeight / 2;
    }

    /**
     * 重复利用时重置用
     * 其他属性自己设置
     */
    reset(texture: egret.Texture) {
        this.texture = texture;
        this.anchorOffsetX = texture.textureWidth / 2;
        this.anchorOffsetY = texture.textureHeight / 2;
        this.alpha = this.scaleX = this.scaleY = 1;
        this.rotation = 0;
    }
}