import { ChapterData } from "../interface/ChapterData";
import { PassType } from "../enum/PassType";
import { ElementType } from "../enum/ElementType";

/**
 * 161到180关数据
 */
export const Chapters9: ChapterData[] = [
    //161
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0.1,
        stepCount: 35,
        passTarget: { type: 1, elements: [{ type: 9, count: 63 }] },
        starScores: [5000, 12000, 21000],
        map: {
            lattices: [
                2, 2, 2, 3, 2, 2, 2, 3, 3,
                3, 0, 3, 0, 3, 0, 3, 0, 3,
                3, 0, 3, 0, 3, 0, 3, 0, 3,
                3, 0, 3, 0, 3, 0, 3, 0, 3,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                3, 0, 3, 0, 3, 0, 3, 0, 3,
                3, 2, 3, 0, 3, 0, 3, 2, 3,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                3, 3, 3, 3, 3, 3, 3, 3, 3
            ],
            connectedLats: [],
            elements: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 2, 1, 2, 1, 2, 1, 2, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                7, 1, 2, 1, 2, 1, 2, 1, 7,
                2, 1, 7, 7, 1, 7, 1, 1, 2
            ],
            baseElements: [
                0, 0, 0, 0, 4, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 1, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0
            ],
            recycles: [],
            generateLats: [{ index: 0, type: null }, { index: 1, type: null }, { index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 7, type: null }, { index: 8, type: null }]
        }
    },
    //162
    {
        baseElementTypes: [3, 2, 1, 0, 4],
        bubbleProbability: 0.7,
        stepCount: 24,
        passTarget: {
            type: 1,
            elements: [{ type: 9, count: 56 }]
        },
        starScores: [6000, 14000, 25000],
        map: {
            lattices: [2, 0, 2, 0, 2, 2, 0, 2, 0, 0, 3, 3, 3, 3, 0, 0, 0, 0, 0, 3, 3, 3, 3, 2, 2, 2, 2, 0, 3, 3, 3, 3, 2, 2, 2, 2, 0, 3, 3, 3, 3, 2, 2, 2, 2, 0, 3, 3, 3, 3, 2, 2, 2, 2, 0, 3, 3, 3, 3, 2, 2, 2, 2, 0, 3, 3, 3, 3, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 2, 0, 2],
            connectedLats: [],
            elements: [
                1, 0, 2, 0, 2, 1, 0, 1, 0,
                0, 2, 0, 2, 0, 0, 0, 0, 0,
                0, 0, 2, 0, 2, 4, 4, 4, 4,
                0, 2, 0, 2, 0, 4, 4, 4, 1,
                0, 0, 2, 0, 2, 4, 4, 4, 1,
                0, 2, 0, 2, 0, 4, 4, 4, 1,
                0, 0, 2, 0, 2, 4, 4, 4, 1,
                0, 2, 0, 2, 0, 0, 0, 0, 0,
                1, 0, 0, 0, 0, 0, 1, 0, 1
            ],
            baseElements: [
                41, 0, 0, 0, 0, 42, 0, 42, 0,
                0, 0, 40, 0, 40, 0, 0, 0, 0,
                0, 40, 0, 40, 0, 10, 10, 20, 20, 0, 0, 40, 0, 40, 50, 30, 30, 42, 0, 41, 0, 40, 0, 20, 20, 30, 10, 0, 0, 40, 0, 0, 30, 50, 50, 40, 0, 40, 0, 40, 0, 30, 50, 50, 40, 0, 0, 40, 0, 40, 0, 0, 0, 0, 42, 0, 0, 0, 0, 0, 42, 0, 41],
            recycles: [],
            generateLats: [
                { index: 0, type: 0 },
                { index: 2, type: 0, cus: [14] },
                { index: 4, type: 0, cus: [14] },
                { index: 5, type: 0 },
                { index: 7, type: 0 },
                { index: 26, type: 0 },
                { index: 25, type: 0 },
                { index: 24, type: 0 },
                { index: 72, type: 0 },
                { index: 78, type: 0 },
                { index: 80, type: 0 }]
        }
    },
    //163
    {
        baseElementTypes: [0, 2, 3, 4, 1],
        bubbleProbability: 0.1, stepCount: 25, passTarget: { type: 1, elements: [{ type: 1, count: 111 }, { type: 5, count: 10 }, { type: 3, count: 65 }] }, starScores: [5000, 12000, 21000], map: { lattices: [0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0], connectedLats: [[3, 75], [5, 77], [4, 76]], elements: [1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 4, 1, 4, 1, 1, 1, 1, 2, 4, 1, 4, 1, 4, 2, 1, 2, 4, 1, 4, 1, 4, 1, 4, 2, 7, 7, 7, 7, 6, 7, 7, 7, 7, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 2, 2, 1, 1, 1, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 2, 0, 2, 1, 1, 1], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 11, type: null }, { index: 15, type: null }, { index: 19, type: null }, { index: 25, type: null }, { index: 27, type: null }, { index: 35, type: null }] }
    },
    //164
    {
        baseElementTypes: [0, 1, 2, 3, 4], bubbleProbability: 0.2, stepCount: 25, passTarget: { type: 1, elements: [{ type: 5, count: 40 }] }, starScores: [6000, 15000, 21000], map: { lattices: [0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1], connectedLats: [[27, 45], [35, 53]], elements: [1, 2, 1, 1, 1, 1, 1, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 7, 7, 7, 7, 7, 2, 1, 1, 2, 7, 2, 2, 2, 7, 2, 1, 1, 2, 7, 2, 5, 2, 7, 2, 1, 1, 2, 7, 2, 2, 2, 7, 2, 1, 1, 2, 7, 7, 7, 7, 7, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 5, 2, 1, 1, 1, 1, 1, 2, 5], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 1, type: null }, { index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 7, type: null }, { index: 9, type: null }, { index: 17, type: null }] }
    },
    //165
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0.4,
        stepCount: 26,
        passTarget: {
            type: 1,
            elements: [{ type: 9, count: 54 }]
        },
        starScores: [6000, 15000, 23000],
        map: {
            lattices: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 3, 3, 0, 3, 3, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 3, 3, 3, 3, 3, 3, 3, 0],
            connectedLats: [],
            elements: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 2, 0, 2, 2, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 0, 4, 2, 2, 2, 2, 2, 2, 2, 4, 4, 4, 2, 2, 2, 2, 2, 4, 4, 4, 4, 4, 2, 2, 2, 4, 4, 4, 4, 4, 4, 4, 2, 4, 4, 4, 4, 0, 4, 4, 4, 4, 4, 4, 4, 0],
            baseElements: [11, 22, 12, 22, 12, 22, 12, 22, 11, 12, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 0, 0, 0, 10, 10, 40, 0, 0, 0, 0, 0, 40, 10, 20, 40, 50, 0, 0, 0, 50, 40, 20, 20, 30, 50, 10, 0, 10, 50, 30, 20, 0, 30, 30, 10, 20, 10, 30, 30, 0],
            recycles: [],
            generateLats: [
                { index: 0, type: 0 },
                { index: 1, type: 0 },
                { index: 2, type: 0 },
                { index: 3, type: 0 },
                { index: 4, type: 0 },
                { index: 5, type: 0 },
                { index: 6, type: 0 },
                { index: 7, type: 0 },
                { index: 8, type: 0 },
                { index: 20, type: 0, cus: [14, 14, 14, 14] },
                { index: 21, type: 0, cus: [14, 14, 14, 14, 14] },
                { index: 23, type: 0, cus: [14, 14, 14, 14, 14] },
                { index: 24, type: 0, cus: [14, 14, 14, 14] },
                { index: 28, type: 0, cus: [14, 14] },
                { index: 31, type: 0, cus: [14, 14, 14, 14, 14] },
                { index: 34, type: 0, cus: [14, 14] },
                { index: 36, type: 0 },
                { index: 44, type: 0 }
            ]
        }
    },
    //166
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0.03,
        stepCount: 26,
        passTarget: { type: PassType.ELEMENT_TARGET, elements: [{ type: ElementType.ICE, count: 14 }], },
        starScores: [6000, 15000, 32000],
        map: {
            lattices: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 0, 3, 0, 0, 1, 1,
                1, 1, 1, 1, 3, 1, 1, 1, 1,
                1, 1, 1, 1, 3, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                3, 3, 3, 3, 0, 3, 3, 3, 3,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 3, 3, 3, 1, 1, 1,
            ],
            //connectedLats: [[27, 45], [35, 53]],
            elements: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 5, 1, 1, 1, 1,
                1, 1, 1, 1, 4, 1, 1, 1, 1,
                1, 1, 1, 5, 4, 5, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                2, 2, 2, 2, 1, 2, 2, 2, 2,
                0, 0, 0, 0, 1, 0, 0, 0, 0,
                1, 1, 1, 4, 4, 4, 1, 1, 1,
            ],
            generateLats: [
                { index: 0, type: null },
                { index: 2, type: null },
                { index: 3, type: null },
                { index: 4, type: null },
                { index: 5, type: null },
                { index: 6, type: null },
                { index: 7, type: null },
                { index: 8, type: null },
                { index: 1, type: null }
            ],
        },
    },
    //167
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0.1, stepCount: 22,
        passTarget: { type: 1, elements: [{ type: 9, count: 60 }] },
        starScores: [5000, 12000, 21000],
        map: {
            lattices: [
                2, 2, 2, 2, 1, 2, 2, 2, 2,
                2, 2, 3, 2, 2, 2, 3, 2, 2,
                2, 3, 2, 3, 2, 3, 2, 3, 2,
                2, 2, 3, 3, 2, 3, 3, 2, 2,
                2, 3, 2, 0, 2, 0, 2, 3, 2,
                0, 0, 0, 0, 3, 0, 0, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                2, 2, 2, 2, 0, 2, 2, 2, 2
            ],
            connectedLats: [],
            elements: [
                1, 1, 1, 1, 7, 1, 1, 1, 1,
                2, 2, 1, 2, 1, 2, 1, 2, 2,
                2, 1, 2, 1, 1, 1, 2, 1, 2,
                2, 2, 1, 1, 1, 1, 1, 2, 2,
                2, 1, 2, 1, 1, 1, 2, 1, 2,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                4, 4, 4, 4, 1, 4, 4, 4, 4
            ],
            recycles: [],
            generateLats: [
                { index: 0, type: null },
                { index: 1, type: null },
                { index: 2, type: null },
                { index: 3, type: null },
                { index: 4, type: null },
                { index: 5, type: null },
                { index: 6, type: null },
                { index: 7, type: null },
                { index: 8, type: null },

                { index: 54, type: null },
                { index: 55, type: null },
                { index: 56, type: null },

                { index: 60, type: null },
                { index: 61, type: null },
                { index: 62, type: null },
            ]
        }
    },
    //168
    {
        baseElementTypes: [0, 1, 2, 3, 4], bubbleProbability: 0.6, stepCount: 24, passTarget: { type: 1, elements: [{ type: 9, count: 15 }] }, starScores: [6000, 14000, 25000], map: {
            lattices: [1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 2, 2, 2, 1, 1, 1, 0, 0, 0, 2, 2, 2, 1, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 1, 2, 2, 2, 0, 0, 0, 1, 1, 1, 2, 2, 2, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1],
            connectedLats: [[18, 36], [19, 37], [11, 38], [63, 16], [64, 17], [56, 24], [42, 69], [43, 61], [44, 62]], elements: [1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 2, 2, 2, 1, 1, 1, 0, 0, 0, 2, 2, 2, 1, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 1, 2, 2, 2, 0, 0, 0, 1, 1, 1, 2, 2, 2, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
            recycles: [],
            generateLats: [
                { index: 0, type: 0 },
                { index: 1, type: 0 },
                { index: 2, type: 0 },
                { index: 3, type: 0 },
                { index: 4, type: 0 },
                { index: 5, type: 0 },

            ]
        }
    },
    //169
    {
        baseElementTypes: [0, 1, 2, 3, 4], bubbleProbability: 0.1, stepCount: 32, passTarget: { type: 1, elements: [{ type: 6, count: 4 }] }, starScores: [5000, 12000, 21000], map: { lattices: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1], connectedLats: [[27, 45], [28, 46], [29, 47], [30, 48], [31, 49], [32, 50], [33, 51], [34, 52], [35, 53]], elements: [1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 4, 4, 4, 4, 4, 4, 4, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 5, 5, 5, 5, 5, 5, 5, 5, 5, 1, 1, 1, 1, 1, 1, 1, 1, 1], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [72, 73, 74, 75, 76, 77, 78, 79, 80], generateLats: [{ index: 0, type: null }, { index: 1, type: null }, { index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 7, type: null }, { index: 8, type: null }] }
    },
    //170
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0.1,
        stepCount: 28,
        passTarget: { type: 1, elements: [{ type: 9, count: 59 }] }, starScores: [5000, 12000, 21000], map: { lattices: [3, 1, 1, 1, 2, 1, 1, 1, 3, 2, 2, 1, 2, 2, 2, 1, 2, 2, 2, 1, 2, 1, 3, 1, 2, 1, 2, 2, 2, 1, 2, 2, 2, 1, 2, 2, 2, 2, 3, 2, 2, 2, 3, 2, 2, 2, 2, 1, 2, 2, 2, 1, 2, 2, 2, 1, 2, 1, 3, 1, 2, 1, 2, 2, 2, 1, 2, 2, 2, 1, 2, 2, 3, 2, 2, 2, 2, 2, 2, 2, 3], connectedLats: [], elements: [1, 4, 4, 4, 2, 4, 4, 4, 1, 2, 1, 1, 1, 2, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 2, 1, 1, 1, 2, 2, 2, 1, 2, 2, 2, 1, 2, 2, 2, 0, 0, 0, 2, 0, 0, 0, 2, 2, 0, 0, 0, 1, 0, 0, 0, 2, 2, 0, 0, 0, 2, 0, 0, 0, 2, 1, 2, 2, 2, 2, 2, 2, 2, 1], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 0, type: null }, { index: 1, type: null }, { index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 7, type: null }, { index: 8, type: null }] }
    },
    //171
    {
        baseElementTypes: [0, 4, 2, 3],
        bubbleProbability: 0.8,
        stepCount: 33,
        passTarget: { type: 1, elements: [{ type: 1, count: 30 }] },
        starScores: [8000, 15000, 22000],
        map: {
            lattices: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0
            ],
            connectedLats: [],
            elements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 6, 1, 1, 1, 6, 1, 1,
                1, 1, 6, 1, 1, 1, 6, 1, 1,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 10, 50, 30, 0, 0, 0,
                0, 0, 40, 40, 30, 50, 50, 0, 0,
                0, 30, 30, 50, 50, 40, 40, 10, 0,
                50, 40, 0, 10, 20, 30, 0, 10, 20,
                50, 40, 0, 10, 20, 50, 0, 30, 20,
                0, 50, 40, 20, 40, 30, 30, 50, 0,
                0, 0, 20, 10, 40, 10, 10, 0, 0,
                0, 0, 0, 50, 30, 30, 0, 0, 0,
            ],
            recycles: [],
            generateLats: [
                { index: 12, type: null },
                { index: 13, type: null },
                { index: 14, type: null },

                { index: 20, type: null },
                { index: 24, type: null },
                { index: 28, type: null },

                { index: 34, type: null },
                { index: 36, type: null },
                { index: 44, type: null }
            ]
        }
    },
    //172
    {
        map: {
            lattices: [
                0, 3, 0, 3, 0, 3, 0, 3, 0,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                0, 3, 3, 3, 3, 3, 3, 3, 0,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                0, 3, 3, 3, 3, 3, 3, 3, 0,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                0, 3, 3, 3, 3, 3, 3, 3, 0,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                0, 3, 0, 3, 0, 3, 0, 3, 0,
            ],
            generateLats: [
                { index: 1, type: null },
                { index: 3, type: null },
                { index: 5, type: null },
                { index: 7, type: null },
                { index: 9, type: null },
                { index: 17, type: null },
                { index: 27, type: null },
                { index: 35, type: null },
                { index: 45, type: null },
                { index: 53, type: null },
                { index: 63, type: null },
                { index: 71, type: null }
            ],
            elements: [
                0, 1, 0, 1, 0, 1, 0, 1, 0,
                4, 1, 1, 1, 1, 1, 1, 1, 4,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                5, 1, 1, 1, 1, 1, 1, 1, 5,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                2, 1, 1, 1, 1, 1, 1, 1, 2,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                5, 1, 1, 1, 1, 1, 1, 1, 5,
                0, 4, 0, 5, 0, 5, 0, 4, 0,
            ],
        },
        baseElementTypes: [0, 1, 2, 3, 4],
        stepCount: 35,
        passTarget: {
            type: PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType.ICE,
                    count: 65
                }
            ],
        },
        starScores: [
            4000,
            8000,
            15000
        ]
    },
    //173
    {
        map: {
            lattices: [
                1, 1, 1, 3, 3, 3, 1, 1, 1,
                1, 1, 1, 3, 3, 3, 1, 1, 1,
                1, 1, 1, 3, 3, 3, 1, 1, 1,
                1, 1, 1, 3, 3, 3, 1, 1, 1,
                1, 1, 1, 3, 3, 3, 1, 1, 1,
                1, 1, 1, 3, 3, 3, 1, 1, 1,
                1, 1, 1, 3, 3, 3, 1, 1, 1,
                1, 1, 1, 3, 3, 3, 1, 1, 1,
                1, 1, 1, 3, 3, 3, 1, 1, 1,
            ],
            generateLats: [
                { index: 0, type: null },
                { index: 1, type: null },
                { index: 2, type: null },
                { index: 3, type: null },
                { index: 4, type: null },
                { index: 5, type: null },
                { index: 6, type: null },
                { index: 7, type: null },
                { index: 8, type: null }
            ],
            elements: [
                1, 1, 2, 5, 1, 1, 2, 1, 1,
                1, 1, 2, 1, 5, 1, 2, 1, 1,
                1, 1, 2, 1, 1, 5, 2, 1, 1,
                1, 1, 2, 1, 5, 1, 2, 1, 1,
                1, 1, 2, 5, 1, 1, 2, 1, 1,
                1, 1, 2, 1, 5, 1, 2, 1, 1,
                1, 1, 2, 1, 1, 5, 2, 1, 1,
                1, 1, 2, 1, 5, 1, 2, 1, 1,
                1, 1, 2, 5, 1, 1, 2, 1, 1,
            ],
        },
        baseElementTypes: [0, 1, 2, 3, 4],
        stepCount: 30,
        passTarget: {
            type: PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType.ICE,
                    count: 27
                }
            ],
        },
        starScores: [
            6000,
            15000,
            32000
        ]
    },
    //174
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0.1,
        stepCount: 25,
        passTarget: { type: 1, elements: [{ type: 9, count: 61 }] },
        starScores: [5000, 12000, 21000], map: { lattices: [2, 2, 2, 2, 0, 2, 2, 2, 2, 2, 2, 2, 2, 0, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 0, 2, 2, 2, 2, 0, 2, 2, 2, 1, 2, 2, 2, 0, 1, 2, 2, 2, 1, 2, 2, 2, 1, 0, 1, 2, 2, 2, 2, 2, 1, 0, 1, 2, 2, 2, 2, 2, 2, 2, 1, 0, 1, 2, 2, 2, 2, 2, 0, 0], connectedLats: [], elements: [1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 1, 1, 4, 1, 4, 1, 4, 1, 4, 7, 4, 1, 4, 1, 4, 1, 4, 1, 1, 1, 4, 1, 4, 1, 4, 1, 2, 7, 2, 1, 4, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 1, 2, 1, 2, 1, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 1, 2, 1, 2, 1, 1, 1], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 14, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 0, type: null }, { index: 1, type: null }, { index: 2, type: null }, { index: 3, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 7, type: null }, { index: 8, type: null }, { index: 22, type: null }] }
    },
    //175
    {
        baseElementTypes: [0, 1, 2, 3, 4], bubbleProbability: 0.1, stepCount: 37, passTarget: { type: 1, elements: [{ type: 9, count: 17 }] }, starScores: [5000, 12000, 21000], map: { lattices: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 3, 1, 3, 1, 3, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 3, 1, 3, 1, 3, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1], connectedLats: [], elements: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 4, 8, 4, 8, 4, 8, 4, 1, 1, 2, 2, 2, 2, 2, 2, 2, 1, 1, 4, 8, 4, 8, 4, 8, 4, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 0, type: null }, { index: 1, type: null }, { index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 7, type: null }, { index: 8, type: null }] }
    },
    //176
    {
        map: {
            lattices: [
                0, 0, 1, 0, 0, 0, 0, 1, 1,
                0, 0, 3, 0, 0, 0, 1, 3, 3,
                0, 3, 3, 3, 0, 1, 3, 3, 3,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                0, 0, 0, 0, 0, 0, 0, 0, 1,
            ],
            generateLats: [
                { index: 27, type: null },
                { index: 19, type: null },
                { index: 21, type: null },
                { index: 30, type: null },
                { index: 22, type: null },
                { index: 14, type: null },
                { index: 7, type: null },
                { index: 8, type: null }
            ],
            connectedLats: [[80, 2]],
            elements: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 4,
                1, 1, 1, 1, 1, 1, 1, 4, 4,
                1, 1, 1, 1, 1, 1, 4, 4, 4,
                1, 1, 1, 1, 1, 1, 1, 1, 0,
            ],
        },
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0.1,
        stepCount: 22,
        passTarget: {
            type: PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType.ICE,
                    count: 54
                }
            ],
        },
        starScores: [
            6000,
            15000,
            22000
        ]
    },
    //177
    {
        baseElementTypes: [0, 2, 1, 4, 3], bubbleProbability: 0.2, stepCount: 33, passTarget: { type: 1, elements: [{ type: 9, count: 32 }] }, starScores: [6000, 11000, 21000], map: { lattices: [1, 3, 3, 1, 3, 3, 1, 1, 1, 1, 1, 3, 3, 3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 3, 3, 3, 1, 1, 1, 1, 1, 3, 3, 1, 3, 3, 1, 1, 1, 1, 1, 3, 3, 1, 3, 3, 1, 1, 1, 1, 1, 3, 3, 3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 3, 3, 3, 1, 1, 1, 1, 1, 3, 3, 1, 3, 3, 1], connectedLats: [], elements: [1, 2, 2, 1, 2, 2, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 2, 1, 1, 1, 2, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 2, 2, 1, 2, 2, 1, 1, 1, 1, 1, 2, 2, 1, 2, 2, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 2, 1, 1, 1, 2, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 2, 2, 1, 2, 2, 1], baseElements: [0, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 14, 0, 0, 0], recycles: [], generateLats: [{ index: 0, type: null }, { index: 1, type: null }, { index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 7, type: null }, { index: 8, type: null }, { index: 10, type: null }, { index: 11, type: null }, { index: 12, type: null }, { index: 13, type: null }, { index: 14, type: null }, { index: 15, type: null }, { index: 16, type: null }, { index: 18, type: null }, { index: 19, type: null }, { index: 20, type: null }, { index: 21, type: null }, { index: 22, type: null }, { index: 23, type: null }, { index: 24, type: null }, { index: 25, type: null }] }
    },
    //178
    {
        baseElementTypes: [0, 1, 2, 3, 4], bubbleProbability: 0.1, stepCount: 27, passTarget: { type: 1, elements: [{ type: 9, count: 41 }] }, starScores: [5000, 12000, 21000], map: { lattices: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 3, 3, 2, 3, 2, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 2, 2, 2, 0, 2, 2, 2, 2, 0, 2, 2, 2, 0, 2, 2], connectedLats: [], elements: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 7, 1, 1, 1, 1, 1, 1, 1, 7, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 2, 1, 2, 1, 1, 2, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 1, 2, 2, 2, 1, 2, 2, 1, 2, 1, 2, 4, 2, 1, 2, 1], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 0, 0, 0, 0, 0, 23], recycles: [], generateLats: [{ index: 0, type: null }, { index: 1, type: null }, { index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 7, type: null }, { index: 8, type: null }] }
    },
    //179
    {
        baseElementTypes: [0, 2, 3, 4],
        bubbleProbability: 0.1,
        stepCount: 31,
        passTarget: {
            type: 1,
            elements: [
                { type: 5, count: 9 },
                { type: 1, count: 45 },
                { type: 2, count: 90 },
            ]
        },
        starScores: [5000, 12000, 21000],
        map: { lattices: [0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0], connectedLats: [], elements: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 7, 1, 6, 1, 1, 1, 1, 1, 1, 2, 1, 2, 1, 1, 1, 7, 1, 1, 1, 1, 6, 1, 1, 2, 1, 2, 1, 1, 6, 1, 1, 1, 1, 2, 1, 1, 1, 2, 1, 2, 1, 1, 1, 1, 1, 1, 6, 1, 7, 1, 1, 1, 1, 2, 7, 1, 1, 1, 1, 1, 6, 2, 6, 1, 1], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 10, type: null }, { index: 14, type: null }, { index: 15, type: null }, { index: 16, type: null }, { index: 18, type: null }, { index: 44, type: null }] }
    },
    //180
    {
        baseElementTypes: [0, 2, 3, 4],
        bubbleProbability: 0.2,
        stepCount: 35,
        passTarget: { type: 1, elements: [{ type: 1, count: 46 }] },
        starScores: [5000, 12000, 17000], map: { lattices: [0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0], connectedLats: [], elements: [0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 6, 1, 1, 1, 6, 1, 1, 1, 1, 6, 1, 1, 1, 6, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0], baseElements: [0, 0, 10, 10, 30, 10, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 2, type: [10, 30] }, { index: 3, type: [10, 30] }, { index: 4, type: [10, 30] }, { index: 5, type: [10, 30] }, { index: 6, type: [10, 30] }, { index: 20, type: null }, { index: 21, type: null }, { index: 22, type: null }, { index: 23, type: null }, { index: 24, type: null }] }
    },
]