import { ChapterData } from "../interface/ChapterData";
import { PassType } from "../enum/PassType";
import { ElementType } from "../enum/ElementType";

/**
 * 81到100关数据
 */
export const Chapters5: ChapterData[] = [
    //81
    {
        baseElementTypes: [0, 1, 3, 2, 4], bubbleProbability: 0, stepCount: 25, passTarget: { type: 1, elements: [{ type: 1, count: 33 }, { type: 5, count: 26 }] }, starScores: [6000, 11000, 20000], map: { lattices: [1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0], connectedLats: [], elements: [2, 2, 2, 1, 1, 1, 1, 1, 0, 2, 2, 2, 1, 1, 1, 1, 1, 0, 2, 2, 2, 2, 1, 6, 1, 1, 0, 1, 1, 2, 2, 1, 1, 1, 1, 0, 1, 1, 1, 2, 2, 1, 1, 1, 0, 1, 1, 1, 1, 2, 2, 1, 2, 0, 1, 1, 6, 1, 2, 2, 2, 2, 0, 1, 1, 1, 1, 1, 2, 2, 2, 0, 1, 1, 1, 1, 1, 2, 2, 2, 0], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 0, type: null }, { index: 1, type: null }, { index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 7, type: null }, { index: 18, type: null }, { index: 19, type: null }, { index: 20, type: null }, { index: 21, type: null }, { index: 27, type: null }, { index: 28, type: null }, { index: 29, type: null }, { index: 30, type: null }, { index: 36, type: null }, { index: 37, type: null }, { index: 38, type: null }, { index: 39, type: null }] }
    },
    //82
    {
        baseElementTypes: [1, 0, 2, 3, 4], bubbleProbability: 0, stepCount: 20, passTarget: { type: 1, elements: [{ type: 9, count: 28 }] }, starScores: [7000, 12000, 22000], map: { lattices: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 3, 3, 3, 3, 3, 1, 0, 0, 1, 3, 1, 1, 1, 3, 1, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 3, 3, 3, 3, 3, 0, 0], connectedLats: [], elements: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 7, 7, 7, 7, 1, 7, 7, 7, 7, 4, 4, 4, 7, 1, 7, 4, 4, 4, 0, 0, 2, 2, 2, 2, 2, 0, 0, 0, 7, 2, 7, 7, 7, 2, 7, 0, 0, 0, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 0, type: null }, { index: 1, type: null }, { index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 7, type: null }, { index: 8, type: null }] }
    },
    //83
    {
        baseElementTypes: [0, 1, 2, 4, 3],
        bubbleProbability: 0,
        stepCount: 30,
        passTarget: { type: 1, elements: [{ type: 9, count: 29 }] },
        starScores: [6000, 12000, 23000],
        map: {
            lattices: [
                0, 0, 1, 1, 3, 1, 1, 0, 0,
                2, 0, 1, 3, 3, 3, 1, 0, 2,
                2, 0, 1, 3, 3, 3, 1, 0, 2,
                2, 0, 1, 3, 3, 3, 1, 0, 2,
                2, 0, 1, 3, 3, 3, 1, 0, 2,
                2, 0, 1, 3, 3, 3, 1, 0, 2,
                0, 0, 1, 3, 3, 3, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0
            ],
            connectedLats: [[65, 9], [69, 17]],
            elements: [
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 4, 4, 4, 4, 4, 0, 0,
                0, 0, 7, 7, 7, 7, 7, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 0, 0, 2, 1, 2, 0, 0, 0
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 14, 0, 0, 0, 0
            ],
            recycles: [],
            generateLats: [
                { index: 2, type: null },
                { index: 3, type: null },
                { index: 4, type: null },
                { index: 5, type: null },
                { index: 6, type: null }
            ]
        }
    },
    //84
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0.2,
        stepCount: 35,
        passTarget: { type: 1, elements: [{ type: 9, count: 44 }] },
        starScores: [7000, 14000, 21000],
        map: {
            lattices: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                3, 3, 1, 1, 1, 1, 1, 3, 3,
                3, 3, 1, 1, 1, 1, 1, 3, 3,
                3, 3, 3, 1, 1, 1, 3, 3, 3,
                3, 3, 3, 1, 1, 1, 3, 3, 3,
                3, 3, 3, 1, 1, 1, 3, 3, 3,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                3, 3, 3, 3, 3, 3, 3, 3, 3
            ],
            connectedLats: [],
            elements: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                2, 2, 1, 1, 1, 1, 1, 2, 2,
                0, 2, 1, 1, 1, 1, 1, 2, 0,
                0, 2, 2, 1, 1, 1, 2, 2, 0,
                0, 0, 2, 1, 1, 1, 2, 0, 0,
                0, 0, 2, 1, 1, 1, 2, 0, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                1, 0, 0, 0, 1, 0, 0, 0, 1
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                41, 0, 0, 0, 41, 0, 0, 0, 41
            ],
            recycles: [],
            generateLats: [
                { index: 0, type: null },
                { index: 1, type: null },
                { index: 2, type: null },
                { index: 3, type: null },
                { index: 4, type: null },
                { index: 5, type: null },
                { index: 6, type: null },
                { index: 7, type: null },
                { index: 8, type: null }
            ]
        }
    },
    //85
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 30,
        passTarget: { type: 1, elements: [{ type: 9, count: 27 }] },
        starScores: [5000, 11000, 24000],
        map: {
            lattices: [
                1, 1, 1, 0, 2, 0, 1, 1, 1,
                1, 1, 1, 0, 2, 0, 1, 1, 1,
                1, 1, 1, 2, 2, 2, 1, 1, 1,
                0, 0, 3, 3, 3, 3, 3, 0, 0,
                3, 3, 3, 1, 3, 1, 3, 3, 3,
                0, 0, 3, 3, 3, 3, 3, 0, 0,
                1, 1, 1, 2, 2, 2, 1, 1, 1,
                1, 1, 1, 0, 2, 0, 1, 1, 1,
                1, 1, 1, 0, 2, 0, 1, 1, 1
            ],
            connectedLats: [[18, 36], [19, 37], [37, 55], [25, 43], [26, 44], [43, 61]],
            elements: [
                1, 1, 1, 0, 1, 0, 1, 1, 1,
                1, 1, 1, 0, 1, 0, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                1, 4, 1, 7, 1, 7, 1, 4, 1,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 0, 1, 0, 1, 1, 1,
                1, 1, 1, 0, 1, 0, 1, 1, 1
            ],
            baseElements: [
                0, 0, 0, 0, 22, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                21, 13, 0, 0, 0, 0, 0, 43, 31,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 12, 0, 0, 0, 0
            ],
            recycles: [],
            generateLats: [
                { index: 0, type: null },
                { index: 1, type: null },
                { index: 2, type: null },
                { index: 4, type: null },
                { index: 6, type: null },
                { index: 7, type: null },
                { index: 8, type: null },
                { index: 21, type: null },
                { index: 23, type: null },
                { index: 54, type: null },
                { index: 62, type: null },
            ]
        }
    },
    //86
    {
        baseElementTypes: [0, 2, 3, 4], bubbleProbability: 0, stepCount: 23, passTarget: { type: 1, elements: [{ type: 1, count: 32 }, { type: 5, count: 12 }] }, starScores: [5000, 12000, 20000], map: { lattices: [0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 0, 0, 1, 1, 1, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0], connectedLats: [], elements: [0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1, 0, 6, 2, 1, 2, 6, 0, 1, 1, 1, 2, 2, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 2, 2, 1, 1, 1, 0, 6, 2, 1, 2, 6, 0, 1, 1, 0, 0, 1, 4, 1, 0, 0, 1, 0, 1, 1, 1, 7, 1, 1, 1, 0], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 1, type: null }, { index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 7, type: null }, { index: 9, type: null }, { index: 17, type: null }, { index: 74, type: null }, { index: 78, type: null }] }
    },
    //87
    { baseElementTypes: [0, 1, 2, 3, 4], bubbleProbability: 0.1, stepCount: 29, passTarget: { type: 1, elements: [{ type: 6, count: 2 }] }, starScores: [5000, 12000, 21000], map: { lattices: [0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0], connectedLats: [[22, 40], [65, 7], [69, 1]], elements: [1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 7, 7, 1, 7, 7, 1, 1, 2, 1, 7, 4, 1, 4, 7, 1, 2, 1, 1, 7, 7, 1, 7, 7, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 1, 1, 1, 2, 1, 2, 4, 2, 4, 2, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 33, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 9, type: null }, { index: 17, type: null }] } },
    //88
    {
        "baseElementTypes": [0, 1, 2, 3, 4],
        "bubbleProbability": 0,
        "stepCount": 25+10,
        "passTarget": { "type": 1, "elements": [{ "type": 9, "count": 36 }] },
        "starScores": [5000, 12000, 19000],
        "map": {
            "lattices": [
                0, 2, 0, 3, 3, 3, 0, 2, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                3, 3, 1, 0, 1, 0, 1, 3, 3,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                1, 0, 1, 1, 0, 1, 1, 0, 1
            ],
            "connectedLats": [],
            "elements": [
                1, 1, 1, 2, 1, 2, 1, 1, 1,
                1, 1, 2, 1, 1, 1, 2, 1, 1,
                1, 2, 1, 1, 1, 1, 1, 2, 1,
                1, 2, 1, 1, 1, 1, 1, 2, 1,
                2, 1, 1, 1, 1, 1, 1, 1, 2,
                4, 7, 1, 1, 1, 1, 1, 7, 4,
                2, 4, 7, 7, 1, 7, 7, 4, 2,
                2, 2, 4, 4, 1, 4, 4, 2, 2,
                2, 1, 2, 2, 1, 2, 2, 1, 2
            ],
            "baseElements": [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0
            ],
            "recycles": [],
            "generateLats": [
                { "index": 1 },
                { "index": 3 },
                { "index": 4 },
                { "index": 5 },
                { "index": 7 },
                { "index": 12 },
                { "index": 14 },
                { "index": 19 },
                { "index": 20 },
                { "index": 24, },
                { "index": 25 }
            ]
        }
    },
    //89
    {
        baseElementTypes: [1, 0, 2, 3, 4],
        bubbleProbability: 0.1,
        stepCount: 30+10,
        passTarget: { type: 1, elements: [{ type: 9, count: 49 }] },
        starScores: [5000, 12000, 21000],
        map: {
            lattices: [
                0, 1, 0, 1, 1, 1, 0, 1, 0,
                0, 2, 1, 1, 1, 1, 1, 2, 0,
                0, 3, 3, 1, 1, 1, 3, 3, 0,
                0, 0, 3, 3, 1, 3, 3, 0, 0,
                0, 3, 0, 3, 3, 3, 0, 3, 0,
                3, 3, 3, 0, 3, 0, 3, 3, 3,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                3, 3, 3, 3, 3, 3, 3, 3, 3
            ],
            connectedLats: [[19, 37], [25, 43], [29, 47], [33, 51], [39, 57], [41, 59]],
            elements: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 7, 1, 1, 1, 1, 1, 7, 1,
                1, 2, 7, 1, 4, 1, 7, 2, 1,
                1, 1, 2, 1, 1, 1, 2, 1, 1,
                1, 1, 1, 2, 4, 2, 1, 1, 1,
                1, 1, 1, 1, 2, 1, 1, 1, 1,
                1, 1, 1, 1, 2, 1, 1, 1, 1,
                1, 1, 1, 1, 2, 1, 1, 1, 1,
                1, 1, 1, 1, 2, 1, 1, 1, 1
            ],
            recycles: [],
            generateLats: [
                { index: 1, type: null },
                { index: 3, type: null },
                { index: 4, type: null },
                { index: 5, type: null },
                { index: 7, type: null },
                { index: 49, type: null },
            ]
        }
    },
    //90
    {
        baseElementTypes: [1, 2, 3, 4],
        bubbleProbability: 0.2,
        stepCount: 25,
        passTarget: { type: 1, elements: [{ type: 2, count: 70 }, { type: 4, count: 70 }] },
        starScores: [6000, 18000, 54000], map: { lattices: [0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], connectedLats: [], elements: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 2, 1, 4, 2, 1, 1, 1, 1, 2, 4, 1, 2, 4, 2, 7, 7, 2, 4, 2, 1, 7, 2, 4, 2, 2, 4, 2, 7, 1, 1, 7, 2, 2, 2, 2, 7, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 1, type: null }, { index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 9, type: null }, { index: 16, type: null }] }
    },
    //91
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: { type: 1, elements: [{ type: 9, count: 41 }] },
        starScores: [6000, 12000, 30000],
        map: {
            lattices: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 3, 3, 3, 3, 3, 3, 3, 0,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                0, 3, 3, 3, 3, 3, 3, 3, 0
            ],
            connectedLats: [[27, 45], [35, 53]], elements: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 2, 0, 0, 0, 2, 1, 1, 1, 2, 2, 0, 0, 0, 2, 2, 1, 1, 2, 0, 0, 0, 0, 0, 2, 1, 1, 2, 0, 2, 2, 2, 0, 2, 1], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 9, type: null }, { index: 10, type: null }, { index: 11, type: null }, { index: 12, type: null }, { index: 13, type: null }, { index: 14, type: null }, { index: 15, type: null }, { index: 16, type: null }, { index: 17, type: null }]
        }
    },
    //92
    {
        baseElementTypes: [0, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 24,
        passTarget: { type: 1, elements: [{ type: 5, count: 17 }, { type: 1, count: 35 }] },
        starScores: [5000, 11000, 19000],
        map: {
            lattices: [
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 1, 1, 1, 1, 1, 1, 1, 0
            ], connectedLats: [], elements: [1, 2, 1, 1, 1, 1, 1, 2, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 4, 2, 4, 1, 1, 1, 1, 1, 4, 6, 2, 6, 4, 1, 1, 1, 1, 2, 2, 2, 2, 2, 1, 1, 1, 1, 4, 6, 2, 6, 4, 1, 1, 1, 1, 1, 4, 2, 4, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 1, 1, 1, 1, 1, 2, 1], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 1, type: null }, { index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 7, type: null }, { index: 9, type: null }, { index: 10, type: null }, { index: 16, type: null }, { index: 17, type: null }, { index: 18, type: null }, { index: 26, type: null }]
        }
    },
    //93
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 25,
        passTarget: { type: 1, elements: [{ type: 9, count: 71 }] },
        starScores: [6000, 12000, 21000],
        map: {
            lattices: [
                3, 3, 3, 3, 3, 2, 2, 2, 2,
                3, 3, 3, 3, 3, 2, 2, 2, 2,
                3, 3, 3, 3, 3, 2, 2, 2, 2,
                0, 0, 0, 0, 0, 2, 2, 2, 2,
                3, 3, 3, 3, 0, 2, 2, 2, 2,
                3, 3, 3, 3, 0, 2, 2, 2, 2,
                3, 3, 3, 3, 0, 2, 2, 2, 2,
                3, 3, 3, 3, 0, 2, 2, 2, 2,
                3, 3, 3, 3, 0, 2, 2, 2, 2
            ],
            connectedLats: [[18, 36], [19, 37], [20, 38], [21, 39]],
            elements: [
                2, 2, 2, 2, 2, 4, 4, 4, 4,
                2, 2, 2, 2, 2, 4, 4, 4, 4,
                2, 2, 2, 2, 1, 4, 4, 4, 4,
                1, 1, 1, 1, 1, 4, 4, 4, 4,
                0, 0, 0, 0, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 1, 2, 2, 2, 2,
                0, 0, 0, 0, 1, 2, 2, 2, 2,
                0, 0, 0, 0, 1, 2, 2, 2, 2
            ], baseElements: [0, 0, 0, 0, 0, 20, 10, 40, 30, 0, 0, 0, 0, 0, 20, 20, 30, 10, 0, 0, 0, 0, 11, 30, 20, 20, 40, 0, 0, 0, 0, 0, 20, 30, 40, 40, 0, 0, 0, 0, 0, 10, 10, 20, 30, 0, 0, 0, 0, 0, 30, 20, 30, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 0, type: null }, { index: 1, type: null }, { index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 7, type: null }, { index: 8, type: null }, { index: 9, type: null }, { index: 10, type: null }, { index: 11, type: null }, { index: 12, type: null }, { index: 13, type: null }, { index: 14, type: null }, { index: 15, type: null }, { index: 16, type: null }, { index: 17, type: null }, { index: 18, type: null }, { index: 19, type: null }, { index: 20, type: null }, { index: 21, type: null }, { index: 22, type: null }, { index: 23, type: null }, { index: 24, type: null }, { index: 25, type: null }, { index: 26, type: null }, { index: 32, type: null }, { index: 33, type: null }, { index: 34, type: null }, { index: 35, type: null }, { index: 41, type: null }, { index: 42, type: null }, { index: 43, type: null }, { index: 44, type: null }]
        }
    },
    //94
    { baseElementTypes: [0, 1, 2, 3, 4], bubbleProbability: 0.2, stepCount: 31, passTarget: { type: 1, elements: [{ type: 0, count: 40 }, { type: 1, count: 42 }] }, starScores: [6000, 12000, 21000], map: { lattices: [0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 0, 0, 1, 0, 0, 1, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1], connectedLats: [[30, 57], [32, 59], [38, 65], [42, 69]], elements: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 7, 7, 1, 1, 7, 1, 1, 7, 7, 7, 7, 4, 1, 7, 1, 4, 7, 7, 7, 7, 1, 1, 7, 1, 1, 7, 7, 7, 7, 1, 7, 2, 7, 1, 7, 7, 7, 7, 7, 7, 2, 7, 1, 7, 7, 7, 7, 7, 7, 2, 7, 1, 7, 7], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 27, type: null }, { index: 28, type: null }, { index: 34, type: null }, { index: 35, type: null }] } },
    //95
    {
        baseElementTypes: [0, 2, 1, 3], bubbleProbability: 0, stepCount: 29, passTarget: { type: 1, elements: [{ type: 6, count: 8 }] }, starScores: [4000, 8000, 18000], map: { lattices: [0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1], connectedLats: [[20, 38], [22, 40], [24, 42]], elements: [1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 7, 1, 1, 1, 1, 1, 1, 1, 1, 7, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 4, type: null }, { index: 46, type: null }, { index: 52, type: null }, { index: 54, type: null }, { index: 62, type: null }] }
    },
    //96
    {
        baseElementTypes: [2, 3, 4, 0],
        bubbleProbability: 0,
        stepCount: 40,
        passTarget: {
            type: 1,
            elements: [
                { type: 1, count: 20 },
                { type: 5, count: 10 },
                { type: 3, count: 45 }
            ]
        },
        starScores: [5000, 25000, 70000],
        map: {
            lattices: [
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1
            ],
            connectedLats: [],
            elements: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 6, 1, 1, 1, 1, 1, 6, 1,
                1, 2, 1, 1, 1, 1, 1, 2, 1,
                1, 6, 1, 1, 1, 1, 1, 6, 1,
                1, 1, 7, 7, 7, 7, 7, 1, 1,
                5, 2, 4, 4, 4, 4, 4, 2, 5,
                5, 0, 0, 0, 0, 0, 0, 0, 5,
                2, 2, 2, 5, 5, 5, 2, 2, 2
            ],
            generateLats: [
                { index: 3, type: null },
                { index: 4, type: null },
                { index: 5, type: null },
                { index: 11, type: null },
                { index: 15, type: null },
                { index: 54, type: null },
                { index: 62, type: null },
            ]
        }
    },
    //97
    {
        baseElementTypes: [0, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 29,
        passTarget: { type: 1, elements: [{ type: 1, count: 60 }, { type: 5, count: 12 }] },
        starScores: [6000, 35000, 75000],
        map: { lattices: [0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0], connectedLats: [], elements: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 1, 2, 1, 1, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 1, 6, 6, 6, 6, 6, 1, 1], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 1, type: null }, { index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 7, type: null }, { index: 9, type: null }, { index: 17, type: null }] }
    },
    //98
    {
        baseElementTypes: [1, 0, 2, 3, 4],
        bubbleProbability: 0.1,
        stepCount: 40,
        passTarget: { type: 1, elements: [{ type: 9, count: 27 }] },
        starScores: [5000, 13000, 21000],
        map: {
            lattices: [
                1, 0, 0, 0, 1, 0, 0, 0, 1,
                0, 1, 0, 1, 0, 1, 0, 1, 0,
                1, 0, 1, 0, 1, 0, 1, 0, 1,
                0, 2, 0, 2, 0, 2, 0, 2, 0,
                3, 1, 1, 1, 3, 1, 1, 1, 3,
                3, 1, 1, 1, 3, 1, 1, 1, 3,
                3, 1, 1, 1, 3, 1, 1, 1, 3,
                3, 3, 3, 1, 3, 1, 3, 3, 3,
                0, 3, 3, 3, 3, 3, 3, 3, 0
            ], connectedLats: [], elements: [7, 1, 1, 1, 7, 1, 1, 1, 7, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 4, 1, 1, 1, 4, 4, 1, 1, 1, 4, 1, 1, 1, 4, 4, 1, 1, 1, 4, 1, 1, 1, 4, 2, 1, 1, 1, 2, 1, 1, 1, 2, 1, 1, 1, 2, 2, 2, 1, 1, 1], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 0, type: null }, { index: 4, type: null }, { index: 8, type: null }]
        }
    },
    //99
    { baseElementTypes: [1, 0, 4, 3], bubbleProbability: 0, stepCount: 24, passTarget: { type: 1, elements: [{ type: 9, count: 66 }] }, starScores: [5000, 13000, 21000], map: { lattices: [3, 0, 3, 3, 3, 3, 3, 0, 3, 3, 0, 3, 3, 3, 3, 3, 0, 3, 3, 0, 3, 3, 3, 3, 3, 0, 3, 3, 0, 3, 3, 3, 3, 3, 0, 3, 3, 0, 3, 3, 3, 3, 3, 0, 3, 3, 0, 3, 3, 3, 3, 3, 0, 3, 3, 0, 3, 3, 0, 3, 3, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3], connectedLats: [], elements: [1, 1, 1, 1, 7, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 2, 1, 1, 1, 1, 1, 2, 4, 2, 1, 1, 1, 1, 1, 2, 1, 2, 1, 2, 1, 1, 2, 1, 1, 2, 4, 2, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 2, 2, 1, 2, 1, 2, 2, 2, 1, 2, 1], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 0, type: null }, { index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 8, type: null }] } },
    //100
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 1,
        stepCount: 27,
        passTarget: {
            type: 1, elements: [
                { type: 1, count: 30 },
                { type: 3, count: 30 },
            ]
        },
        starScores: [6000, 12000, 25000],
        map: {
            lattices: [
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                1, 0, 1, 1, 1, 0, 1, 1, 1,
                1, 0, 1, 0, 1, 0, 1, 0, 1,
                1, 0, 1, 1, 1, 0, 1, 1, 1,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1
            ],
            connectedLats: [[21, 39], [25, 43]],
            elements: [
                0, 4, 4, 4, 4, 4, 4, 4, 4,
                1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 1, 2, 2, 2, 1, 2, 2, 1, 2, 1, 2, 1, 2, 1, 2, 2, 2, 2, 1, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2], baseElements: [0, 0, 40, 40, 50, 40, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 21, 0, 0, 0, 0, 0, 0, 0, 0, 43, 0, 0, 0, 0, 0, 0, 0, 0, 21, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 18, type: null, cus: [14, 14, 14] }, { index: 20, type: null, cus: [14, 14, 14] }, { index: 21, type: null, cus: [14, 14] }, { index: 22, type: null, cus: [14, 14, 14] }, { index: 24, type: null, cus: [14, 14, 14] }, { index: 25, type: null, cus: [14, 14] }, { index: 26, type: null, cus: [14, 14, 14] }, { index: 57, type: null }, { index: 58, type: null }, { index: 59, type: null }, { index: 64, type: null }, { index: 65, type: null }, { index: 69, type: null }, { index: 70, type: null }]
        }
    },

]