import { Ani } from "../class/Ani";
import { ScoreNumber } from "../uis/ScoreNumber";
/**
 * 分数的动效，
 * 但是这里面需要记录分数
 */
export class ScoreAni extends Ani {
    scoreNumber: ScoreNumber;
    private _score: number;
    get score(): number {
        return this._score
    }
    set score(value: number) {
        if (this._score == value) return;
        this._score = value;
        this.scoreNumber.num = value;
    }
    constructor() {
        super();
        this.aniName = "ScoreAni";
        this.scoreNumber = new ScoreNumber();
        this.addChild(this.scoreNumber)
    }
    play() {
        // this.reset();
        this.scoreNumber.y = 0;
        this.scoreNumber.alpha = 1;
        egret.Tween.get(this.scoreNumber)
            .to({ y: -50, alpha: 0 }, 1000)
            .call(() => {
                this.recover();
            })
    }
}