import { Ani } from "../class/Ani";
import { ElementType } from "../enum/ElementType";

export class JellyDisAni extends Ani {
    showImage: egret.Bitmap;
    downCircle: egret.Bitmap;
    upCircle: egret.Bitmap;
    constructor() {
        super()
        this.aniName = "JellyDisAni";

        var arr = ["ele"+ElementType.JELLY+"_png", "greenCircleDown_png", "greenCircleUp_png"];
        var objs = ["showImage", "downCircle", "upCircle"];

        for (var i = 0; i < arr.length; i++) {
            var texture: egret.Texture = RES.getRes(arr[i])
            var obj = new egret.Bitmap(texture);
            this.addChild(obj);
            obj.anchorOffsetX = texture.textureWidth / 2;
            obj.anchorOffsetY = texture.textureHeight / 2;
            this[objs[i]] = obj;
        }
    }

    play() {

        egret.Tween.get(this.showImage)
            .set({ alpha: 1 })
            .to({ alpha: 0 }, 250*1.5)

        egret.Tween.get(this.downCircle)
            .set({ scaleX: 0.01, scaleY: 0.01 })
            .to({ scaleX: 0.6, scaleY: 0.6 }, 300*1.5, egret.Ease.cubicOut)
            .call(() => {
                this.recover();
            })

        egret.Tween.get(this.downCircle)
            .set({ alpha: 1 })
            .wait(140*1.5)
            .to({ alpha: 0 }, 160*1.5);

        egret.Tween.get(this.upCircle)
            .set({ scaleX: 0.01, scaleY: 0.01 })
            .wait(70*1.5)
            .to({ scaleX: 1, scaleY: 1 }, 160*1.5, egret.Ease.cubicOut);

        egret.Tween.get(this.upCircle)
            .set({ alpha: 1 })
            .wait(170*1.5)
            .to({ alpha: 0 }, 100*1.5);

    }


}