import getResPath from "../../libs/new_tc/getResPath";
import { ShowWord } from "../something/uis/ShowWord";


let cacheKey = "happyClear" + window["CFG"].consumerId;

export const getCacheKey=()=>{
    return cacheKey
}
/**
 * 读取缓存
 */
export function readCache(key: string = cacheKey, type: string = 'localStorage') {
    if (!window[type]) {
        return false;
    }
    return window[type].getItem(key);
}
/**
 * 写缓存
 */
export function writeCache(key: string = cacheKey, value: any = 'true', type: string = 'localStorage') {
    if (!window[type]) {
        // trace(Func.replace(SysLang.lang_012, [type]));
        return;
    }
    window[type].setItem(key, value);
}


const resPath = getResPath();
const parser = new window["SVGA"].Parser();
/**   
 * 箭头的svga，只加载一次
 */
let arrow: egret.DisplayObjectContainer;
/**
 * 地图页面的引导
 * 进地图页面先判断缓存，显示界面
 *   \n
 */
export class GuideCon extends egret.DisplayObjectContainer {
    private steps: number = 4;
    private curStep: number = 1;
    groups: any[];
    couldOver: boolean = false;
    timeoutId: number;
    tri: egret.Bitmap;
    showWord: ShowWord;
    callback;
    constructor(callback) {

        super();
        this.callback=callback;
        var bg: egret.Shape = new egret.Shape();
        bg.graphics.beginFill(0x000000, 0.7);
        bg.graphics.drawRect(0, 0, 750, 1624);
        bg.graphics.endFill();
        bg.touchEnabled = true;
        this.addChild(bg);

        var board = new egret.Bitmap(RES.getRes("lionMsgBg_png"))
        board.x = 50;
        board.y = 600;
        board.touchEnabled = true;
        board.addEventListener(egret.TouchEvent.TOUCH_TAP, () => {
            if (this.couldOver) {
                clearTimeout(this.timeoutId);
                this.couldOver = false;
                this.goNext();
            }
        }, this)
        this.addChild(board);
        var tri = new egret.Bitmap(RES.getRes("msgTri_png"))
        tri.x = 638;
        tri.y = 804;
        tri.visible = false;
        this.tri = tri;
        this.addChild(tri);
        this.showWord = new ShowWord();
        this.showWord.x = 315;
        this.showWord.y = 692;
        this.addChild(this.showWord);

        this.groups = [];
        //guideLove
        var guideLove = new egret.Bitmap(RES.getRes("guideLove_png"));
        guideLove.x = 173;
        guideLove.y = 18;
        this.addChild(guideLove);
        this.groups.push(guideLove);
        //guideMoney
        var guideMoney = new egret.Bitmap(RES.getRes("guideMoney_png"));
        guideMoney.x = 352;
        guideMoney.y = 18.31;
        this.addChild(guideMoney);
        this.groups.push(guideMoney);
        //关卡
        var guideLevel = new egret.Bitmap(RES.getRes("guideLevel_png"));
        guideLevel.x = 315;
        guideLevel.y = 462;
        this.addChild(guideLevel);
        this.groups.push(guideLevel);
        //宝箱
        var box = new egret.Bitmap(RES.getRes("guideBox_png"));
        box.x = 523;
        box.y = 18.5;
        this.addChild(box);
        this.groups.push(box);
        //两个图标，道具商城和我的奖励
        var gg = new egret.DisplayObjectContainer();
        gg.addChild(new egret.Bitmap(RES.getRes("道具_png")));
        var recordBtn = new egret.Bitmap(RES.getRes("recordbtn_png"));
        recordBtn.x = 620.14-615.08;
        recordBtn.y = 255.91-128.01;
        gg.addChild(recordBtn);
        this.addChild(gg);
        this.groups.push(gg);
        gg.x = 615.08;
        gg.y = 128.01;

        //跳过提示
        var guideOver = new egret.Bitmap(RES.getRes("guideOver_png"));
        guideOver.x = (750 - 444) / 2;
        guideOver.y = 1024;
        guideOver.touchEnabled = true;
        guideOver.addEventListener(egret.TouchEvent.TOUCH_TAP, () => {
            if (this.parent) this.parent.removeChild(this);
            clearTimeout(this.timeoutId);
            writeCache();
            if(this.callback)this.callback();
        }, this)
        this.addChild(guideOver);

        //箭头
        if (!arrow) {
            arrow = new window["SVGA"].EgretMovieClip();
            arrow["lockStep"] = true;
            this.addChild(arrow);
            parser.load(resPath + 'resource/assets/svgas/' + 'guideArrow.svga', (videoItem) => {
                arrow["init"](videoItem)
            }, function (error) {
                // alert(error.message);
            })
        } else {
            this.addChild(arrow);
        }

        //先都隐藏
        for (var i = 0; i < this.groups.length; i++) {
            this.groups[i].visible = false;
        }
    }

    positions: number[][] = [
        [350, 280, 180],
        [550, 280, 180],
        [260, 280, 0],
        [710, 280, 180],
        [440, 350, -90],
    ]
    words: string[] = [
        "这里是体力值，闯关失败会\n扣除1体力值，闯关成功不扣\n除哦~",
        "这里是元宝，闯关成功后可\n随机获得大量元宝，元宝可\n用于兑换体力值和游戏道具",
        "在这里选择查看关卡，闯关\n成功后还有机会赢得丰厚奖\n励哟！",
        "每个关卡收集的星星可用于\n开启宝箱，宝箱里还有更多\n无敌券、品牌券在等你！",
        "进入道具商城去兑换道具为\n游戏加分吧~获得的奖励可\n在“我的奖励”中查看哦"
    ]
    /**
     * 1开始
     * @param step 
     */
    public play(step: number) {
        this.curStep = step;
        this.toggleVisible(step);
        //箭头位置
        arrow.x = this.positions[step - 1][0];
        arrow.y = this.positions[step - 1][1];
        arrow.rotation = this.positions[step - 1][2];

        //文案播放，播放完后this.couldOver=true,计时

        this.showWord.play(this.words[step - 1], () => {
            this.couldOver = true;
            this.tri.visible = true;
            egret.Tween.get(this.tri, { loop: true }, null, true)
                .set({ y: 804 })
                .to({ y: 814 }, 300)
                .to({ y: 804 }, 300)
            this.timeoutId = setTimeout(() => {
                clearTimeout(this.timeoutId);
                this.couldOver = false;
                this.goNext();
            }, 3000)
        })
    }


    private toggleVisible(step: number) {
        for (var i = 0; i < this.groups.length; i++) {
            if (i + 1 == step) {
                this.groups[i].visible = true;
            } else {
                this.groups[i].visible = false
            }
        }
    }

    private goNext() {
        this.curStep++;
        if (this.curStep > this.steps) {
            if (this.parent) this.parent.removeChild(this);
            writeCache();
            if(this.callback)this.callback();
        } else {
            this.play(this.curStep);
            //隐藏三角形
            this.tri.visible = false;
            egret.Tween.removeTweens(this.tri)
        }
    }


}