import PropType from "../../PropType";
import { Tool } from "../Tool";

/**
 * 道具使用引导，初始化一次，然后用init初始化
 * 185.58-67，1100-60
 * 375.5-67.5
 * 568.46-67.5
 */
export class PropGuide extends egret.DisplayObjectContainer {
    bg: egret.Shape;
    boomBtn: egret.Bitmap;
    hammerBtn: egret.Bitmap;
    stepBtn: egret.Bitmap;
    msgTxt: egret.TextField;
    constructor(offsetY: number) {
        super()
        this.bg = new egret.Shape();
        this.addChild(this.bg);
        this.boomBtn = new egret.Bitmap(RES.getRes("boomBtn_png"));
        this.boomBtn.x = 375 - 110 - 50 - 55;  //110图片宽度，50按钮间隔，55一半的图片宽度
        this.boomBtn.y = offsetY - 55;
        this.addChild(this.boomBtn);
        this.hammerBtn = new egret.Bitmap(RES.getRes("hammerBtn_png"));
        this.hammerBtn.x = 375 - 55;
        this.hammerBtn.y = offsetY - 55;
        this.addChild(this.hammerBtn);
        this.stepBtn = new egret.Bitmap(RES.getRes("stepBtn_png"));
        this.stepBtn.x = 375 + 110 + 50 - 55;
        this.stepBtn.y = offsetY - 55;
        this.addChild(this.stepBtn);
        //再调
        var text: egret.TextField = new egret.TextField();
        text.text = "为本次增加额外5次步数";
        text.textColor = 0xffffff;
        text.size = 20;
        text.x = (750 - 500) / 2;
        text.y = offsetY - 92;
        text.textAlign = egret.HorizontalAlign.CENTER;
        text.width = 500;
        this.addChild(text);
        this.msgTxt = text;
        this.addEventListener(egret.TouchEvent.TOUCH_TAP, () => {
            if (this.parent) this.parent.removeChild(this)
        }, this)
    }
    init(prop: PropType) {
        if (prop == PropType.BOOM) {
            this.boomBtn.visible = true;
            this.hammerBtn.visible = false;
            this.stepBtn.visible = false;
            this.setRect();
            this.msgTxt.text = "选择任意一个元素，它的横竖各一排消除";
            // this.msgTxt.x = (750-500)/2;
        }
        else if (prop == PropType.HAMMER) {
            this.boomBtn.visible = false;
            this.hammerBtn.visible = true;
            this.stepBtn.visible = false;
            this.setRect();
            this.msgTxt.text = "选择任意一个元素即可消除";
            // this.msgTxt.x = (750-500)/2;
        }
        else {
            this.boomBtn.visible = false;
            this.hammerBtn.visible = false;
            this.stepBtn.visible = true;
            this.bg.graphics.clear();
            this.bg.graphics.beginFill(0x000000, 0.7)
            this.bg.graphics.moveTo(0, 0);
            this.bg.graphics.lineTo(750, 0);
            this.bg.graphics.lineTo(750, 1624);
            this.bg.graphics.lineTo(0, 1624);
            this.bg.graphics.lineTo(0, 0);
            this.bg.graphics.drawArc(123, 98, 72, 0, Math.PI * 2, true)
            this.bg.graphics.endFill();
            this.msgTxt.text = "点击左上方步数，可为闯关时增加额外5次步数";
            // this.msgTxt.x = 320;
        }
    }

    setRect() {
        this.bg.graphics.clear();
        this.bg.graphics.beginFill(0x000000, 0.7)
        this.bg.graphics.moveTo(0, 0);
        this.bg.graphics.lineTo(750, 0);
        this.bg.graphics.lineTo(750, 1624);
        this.bg.graphics.lineTo(0, 1624);
        this.bg.graphics.lineTo(0, 0);
        this.bg.graphics.moveTo(Tool.offsetX, Tool.offsetY);
        this.bg.graphics.lineTo(Tool.offsetX, Tool.offsetY + Tool.height * Tool.rowNum);
        this.bg.graphics.lineTo(750 - Tool.offsetX, Tool.offsetY + Tool.height * Tool.rowNum);
        this.bg.graphics.lineTo(750 - Tool.offsetX, Tool.offsetY);
        this.bg.graphics.lineTo(Tool.offsetX, Tool.offsetY);
        this.bg.graphics.endFill();
    }
}