import getResPath from "../../../libs/new_tc/getResPath";

const moiveClip = {};
const resPath = getResPath()
const parser = new window["SVGA"].Parser();
/**
 * 引导 废弃
 */
export class GuideMsg extends egret.DisplayObjectContainer {
    bg: egret.Bitmap;
    knowBtn: egret.Bitmap;
    closeBtn: egret.Bitmap;
    msgTxt: egret.Bitmap;
    moiveClip;
    /**
     * closeCommonBtn_png
     * @param num 1到5的引导
     */
    constructor() {
        super()
        var shape: egret.Shape = new egret.Shape();
        shape.graphics.beginFill(0x000000, 0.7);
        shape.graphics.drawRect(0, 0, 750, 1624);
        shape.graphics.endFill();
        shape.touchEnabled = true;
        this.addChild(shape);
        //背景图
        this.bg = new egret.Bitmap(RES.getRes("guideBg_png"));
        this.bg.x = (750 - 639) / 2;
        this.bg.y = 300;
        this.addChild(this.bg);
        //关闭按钮
        this.closeBtn = new egret.Bitmap(RES.getRes("closeCommonBtn_png"));
        this.closeBtn.x = 615;
        this.closeBtn.y = 300;
        this.closeBtn.touchEnabled = true;
        this.addChild(this.closeBtn);
        this.closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, function () {
            if (this.parent) this.parent.removeChild(this)
        }, this)
        //知道了
        this.knowBtn = new egret.Bitmap(RES.getRes("guideKnowBtn_png"));
        this.knowBtn.x = (750 - 266) / 2;
        this.knowBtn.y = 800;
        this.knowBtn.touchEnabled = true;
        this.addChild(this.knowBtn);
        this.knowBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, function () {
            if (this.parent) this.parent.removeChild(this)
        }, this)
    }
    /**
     * 
     * @param num 
     * @param callback 里面是移除转圈，加进场景
     */
    init(num: number, callback: Function) {
        //移除原先的svga
        if (this.moiveClip) this.removeChild(this.moiveClip);
        //svga
        if (moiveClip["guide" + num]) {
            this.moiveClip = moiveClip["guide" + num];
            this.addChild(moiveClip["guide" + num]);
            callback();
        } else {
            parser.load(resPath + 'resource/assets/svgas/' + 'guide' + num + '.svga', (videoItem) => {
                var mv = new window["SVGA"].EgretMovieClip(videoItem);
                mv.lockStep = true;
                mv.x = 3;
                mv.y = -263;
                this.moiveClip = mv;
                this.addChild(mv);
                moiveClip["guide" + num] = mv;
                callback();
            }, function (error) {
                // alert(error.message);
            })
        }
        this.initTxt(num)
    }

    //调位置
    private initTxt(num: number) {
        if (!this.msgTxt) {
            this.msgTxt = new egret.Bitmap();
            this.addChild(this.msgTxt);
        }
        let y: number;
        switch (num) {
            case 1:
                y = 705;
                break;
            case 2:
                y = 685;
                break;
            case 3:
                y = 685;
                break;
            case 4:
                y = 685;
                break;
            case 5:
                y = 705;
                break;
        }
        var texture: egret.Texture = RES.getRes("guideTxt" + num + "_png");
        this.msgTxt.texture = texture;
        this.msgTxt.x = (750 - texture.textureWidth) / 2;
        this.msgTxt.y = y;
    }
}