import { Ani } from "../class/Ani";
import { ImageAni } from "../class/ImageAni";

//原点已是中心
export class ExplosiveBgAni extends eui.Image {
    sourceAll: string[];
    currentFrame: number;
    totalFrames: number;
    isPlay: boolean;

    startTime: number
    /**
     * 所有时间，帧数按每秒30
     */
    allTime: number
    /**
     * 播放完的回调
     */
    constructor() {
        super();
        var arr = [];
        var aaa = [1, 3, 5, 7, 9, 11, 14, 16, 18, 19, 21, 23, 25, 27, 29, 32, 34];
        for (var i = 1; i <= 60; i++) {
            if (aaa.indexOf(i) >= 0) {
                arr.push("exLighting" + i + "_png")
            } else {
                arr.push(null);
            }
        }
        this.sourceAll = arr;
        this.changeSource(this.sourceAll[0])
        this.currentFrame = 0;
        this.totalFrames = arr.length;
        this.addEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame, this)

        this.startTime = Date.now()
        this.allTime = this.sourceAll.length / 30 * 1000;

    }
    onEnterFrame() {
        var dataNow = Date.now();
        var deltaTime = dataNow - this.startTime;
        var scale = deltaTime / this.allTime;
        if (scale >= 1) {
            this.startTime = Date.now()
            this.currentFrame = 0;
            this.changeSource(this.sourceAll[this.currentFrame]);
        } else {
            this.currentFrame = (scale * this.sourceAll.length) >> 0;
            this.changeSource(this.sourceAll[this.currentFrame]);
        }
    }

    reset() {
        // this.showImage.scaleX = this.showImage.scaleY = 0.7;
        // this.showImage.alpha = 1;
    }

    private changeSource(source: string) {
        if (source) {
            this.texture = RES.getRes(source)
            this.x = -this.texture.textureWidth / 2;
            this.y = -this.texture.textureHeight / 2;
        } else {
            this.texture = null;
        }
    }
} 