import { Element } from "./Element";
import { Ice } from "./Ice";
import { Tool } from "../Tool";
import { Door } from "./Door";

/**
 * 位置信息直接用一个二维数组记录，然后用row，col取
 * row，col和index是否记录对应的
 * 每个地图格子的记录数据
 */
export class Lattice {
    /**
     * 上面的冰块,是加在背景图上的
     */
    ice: Ice;
    /**
     * 石门
     */
    door: Door;
    /**
     * 判断石门关闭状态
     */
    get doorClosed() {
        return !!(this.door && this.door.closed)
    }
    /**
     * 上面的元素（null，消除元素，石头，冰激凌等），
     */
    private _element: Element;
    get element(): Element {
        return this._element
    }
    /**
     * value为null或元素
     */
    set element(value: Element) {
        if (value) {
            value.index = this.index;
            value.row = this.row;
            value.column = this.column;
        }
        this._element = value
    }
    /**
     * 索引
     */
    index: number
    /**
     * 第几行
     */
    row: number;
    /**
     * 第几列
     */
    column: number;
    /**
     * 是否生成口
     */
    isGenerate: boolean;
    /**
     * 上通道索引口
     */
    up: number;
    /**
     * 下一掉落口索引
     * 可为无
     */
    down: number;

    /**
     * 
     * @param index 索引
     */
    constructor(index: number) {
        this.index = index;
        var rc = Tool.indexToRc(index);
        this.row = rc[0];
        this.column = rc[1];
        //重置属性，后面自行赋值
        this.ice = null;
        this.element = null;
        this.up = null;
        this.down = null;
        this.isGenerate = false;
    }

    /**
     * 重置，貌似用不着，没有地方回收过格子，以后需要额外回收ice，door，element
     * @param index 索引
     */
    reset(index: number) {
        this.index = index;
        var rc = Tool.indexToRc(index);
        this.row = rc[0];
        this.column = rc[1];
        //重置属性，后面自行赋值
        this.ice = null;
        this.door = null;
        this.element = null;
        this.up = null;
        this.down = null;
        this.isGenerate = false;
    }

}