import { ImageAni } from "../class/ImageAni";
import { Pool } from "../Pool";
import { RecoverName } from "../enum/RecoverName";
import { playSound, SoundType } from "../../soundCtrl";
import { Tool } from "../Tool";
import { ElementType } from "../enum/ElementType";

const offsetX = 91 / 2;
const offsetY = 62 / 2;
/**
 * 需要回调的
 * 
 */
export class PieceToEggAni extends egret.DisplayObjectContainer {

    showImage: egret.Bitmap;
    eggPiece1: egret.Bitmap;
    eggPiece2: egret.Bitmap;
    eggPiece3: egret.Bitmap;
    eggPiece4: egret.Bitmap;
    eggPiece5: egret.Bitmap;
    constructor() {
        super()
        var arr = ["ele" + ElementType.CHICKEN_EGG + "_png", "eggPiece1_png", "eggPiece2_png", "eggPiece3_png", "eggPiece4_png", "eggPiece5_png"];
        var objs = ["showImage", "eggPiece1", "eggPiece2", "eggPiece3", "eggPiece4", "eggPiece5"];

        for (var i = 0; i < arr.length; i++) {
            var texture: egret.Texture = RES.getRes(arr[i])
            var obj = new egret.Bitmap(texture);
            this.addChild(obj);
            obj.anchorOffsetX = texture.textureWidth / 2;
            obj.anchorOffsetY = texture.textureHeight / 2;
            this[objs[i]] = obj;
        }
    }

    play(p: number[], callback: Function) {
        this.x = p[0];
        this.y = p[1];
        this.showImage.alpha = 0;
        egret.Tween.get(this.showImage)
            .wait(250)
            .to({ alpha: 1 }, 150)

        this.alpha = 0;
        //整体透明度
        egret.Tween.get(this)
            .to({ alpha: 1 }, 150)
        //下面所有的蛋壳碎片
        egret.Tween.get(this.eggPiece1)
            .set({ rotation: 60, x: 37 - offsetX - 30, y: 22 - offsetY - 34 })
            .to({ rotation: 0, x: 37 - offsetX, y: 22 - offsetY }, 400);
        egret.Tween.get(this.eggPiece2)
            .set({ rotation: 60, x: 48 - offsetX + 36, y: 20 - offsetY - 28 })
            .to({ rotation: 0, x: 48 - offsetX, y: 20 - offsetY }, 400);
        egret.Tween.get(this.eggPiece3)
            .set({ rotation: 60, x: 52 - offsetX + 30, y: 32 - offsetY + 10 })
            .to({ rotation: 0, x: 52 - offsetX, y: 32 - offsetY }, 400);
        egret.Tween.get(this.eggPiece4)
            .set({ rotation: 60, x: 45 - offsetX + 32, y: 44 - offsetY + 38 })
            .to({ rotation: 0, x: 45 - offsetX, y: 44 - offsetY }, 400);
        egret.Tween.get(this.eggPiece5)
            .set({ rotation: 60, x: 34 - offsetX - 20, y: 34 - offsetY + 14 })
            .to({ rotation: 0, x: 34 - offsetX, y: 34 - offsetY }, 400)
            .call(() => {
                callback();
                if (this.$parent) {
                    this.$parent.removeChild(this)
                };
                Pool.recover(RecoverName.PIECETOEGG_ANI, this)
            })





    }
}