import wait from "../../libs/new_tc/wait";
import hdGameDoDojoin from "../../libs/new_tw/ctrls/hdGameDoDojoin";
import Panel from "../../libs/new_wx/components/Panel";
import PanelCtrl from "../../libs/new_wx/ctrls/panelCtrl";
import SceneCtrl from "../../libs/new_wx/ctrls/sceneCtrl";
import { showToast } from "../../libs/new_wx/ctrls/toastCtrl";
import { updateMainTimerAfterGetData } from "../../libs/new_wx/MainBase";
import { ModuleTypes } from "../../libs/new_wx/types/sceneTypes";
import { NetManager } from "../../libs/tw/manager/NetManager";
import getHomeData, { getPropNums } from "../getHomeData";
import { iswx } from "../iswx";
import PropType from "../PropType";
import setGlow from "../setGlow";
import { ElementType } from "../something/enum/ElementType";
import { PassType } from "../something/enum/PassType";
import TargetItemRenderer from "./TargetItemRenderer";
import { addRankFriendList } from "../mapScene/RankFriendList";
import { addAdComp } from "./BoxPanel";
import { getChapterData } from "../something/chapters/getChapter";
import { getlogItem } from "../Main";

export default class StartPanel extends Panel {
    static currlevel;
    private _level;
    private list: eui.List;


    videoProp: number[] = [0, 0, 0];
    boom: number = 0;
    hammer: number = 0;
    step: number = 0;
    start(data) {
        //闯关前弹框曝光
        NetManager.ins.showLog(getlogItem(1))

        super.start();
        this['price2'].text = `-${window['price2']}元宝`;
        this['price3'].text = `-${window['price3']}元宝`;
        this['price4'].text = `-${window['price4']}元宝`;
        const homedata = getHomeData();

        if (data > homedata.levels.length) {
            addAdComp(84, 901, this, 29);
        }
        else
            addRankFriendList(84, 901, this, data);

        setGlow(this['levelTxt'], 0xfa4b09, 1);
        this['levelTxt'].text = `第${data}关`;
        this._level = data;
        let mapDataIndex = data;
        this['targetGroup'].visible = false;
        this['scoreGroup'].visible = false;
        const levelType = getChapterData(mapDataIndex).passTarget.type;
        if (levelType == PassType.ELEMENT_TARGET) {
            this['targetGroup'].visible = true;
            // this['targetTxt'].text = '在规定步数内\n消除足够数量目标';

            this.list.itemRenderer = TargetItemRenderer;
            const ac = new eui.ArrayCollection(getChapterData(mapDataIndex).passTarget.elements);
            this.list.dataProvider = ac;
            const elements = getChapterData(mapDataIndex).passTarget.elements;
            if (elements.length == 1 && elements[0].type == ElementType.LOLLIPOP)
                this['tips'].text = '在指定步数内将目标元素移至最底部';
        }
        else if (levelType == PassType.SCORE_TARGET) {
            this['scoreGroup'].visible = true;
            this['targetScoreTxt'].text = `${getChapterData(mapDataIndex).passTarget.score}`;
            // this['targetTxt'].text = `在规定步数内\n分数达到${getChapterData(mapDataIndex).passTarget.score}分`;
        }

        const prop2Nums = getPropNums(PropType.BOOM);
        const prop1Nums = getPropNums(PropType.HAMMER);
        const prop3Nums = getPropNums(PropType.CHANCE_NUM);
        // this['nums1Txt'].text = prop1Nums;
        // this['nums2Txt'].text = prop2Nums;
        // this['nums3Txt'].text = prop3Nums;
        this['nums1Txt'].text = 0;
        this['nums2Txt'].text = 0;
        this['nums3Txt'].text = 0;
        if (!getPropNums(PropType.BOOM)) this['buy2btn'].visible = false;
        if (!getPropNums(PropType.HAMMER)) this['buy1btn'].visible = false;
        if (!getPropNums(PropType.CHANCE_NUM)) this['buy3btn'].visible = false;
    }

    initEvents() {
        super.initEvents();//妈的，购买按钮居然不是按顺序的，购买道具弹框也不是按顺序的，，2炸弹，1锤子，3步数
        this['buy1btn'].addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_buy1btn, this);
        this['buy2btn'].addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_buy2btn, this);
        this['buy3btn'].addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_buy3btn, this);
        this['startBtn'].addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_startBtn, this);

        this['video1btn'].addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_video1btn, this);
        this['video2btn'].addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_video2btn, this);
        this['video3btn'].addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_video3btn, this);
    }

    onTap_startBtn() {
        const homeData = getHomeData();
        if (homeData.remainEnargy <= 0) {
            // if (homeData.askForEnergy) {
            PanelCtrl.instance.show('blood2Panel');
            // } else {
            //     if (iswx()) {
            //         getShareUrl(this.stage);
            //     } else
            //         showShare(1);
            //     NetManager.ins.hc_askForEnergy((success) => {
            //         NetManager.ins.hc_home(() => {
            //             SceneCtrl.instance.updateScene();
            //         }, window['collectRuleId']);
            //         wait(2000).then(() => {
            //             showToast('分享成功~');
            //         });
            //     })
            // }
            return;
        }

        // Loading.instace.show();
        this.touchChildren = false;
        this.touchEnabled = false;
        // try {
        //     if (window['getRST']) window['getRST']();
        // } catch (error) {
        //     console.warn(error)
        // }

        hdGameDoDojoin(async (success) => {
            // Loading.instace.hide();
            this.touchChildren = true;
            this.touchEnabled = true;
            wait(5000).then(() => {
                updateMainTimerAfterGetData();
            });
            if (success) {
                // Loading.instace.show();
                this.hidePanel();
                try {
                    const key = 'main2';
                    await Promise.all([
                        RES.getResAsync(`${key}_json`),
                        RES.getResAsync(`${key}_png`)]);
                } catch (error) {

                }

                // Loading.instace.hide();
                SceneCtrl.instance.change(ModuleTypes.MAIN_SCENE, {
                    chapter: this._level,
                    boom: this.boom,
                    hammer: this.hammer,
                    step: this.step,
                    videoProp: this.videoProp
                });
                StartPanel.currlevel = this._level
            }
        }, this._level);


    }

    //锤子
    onTap_buy1btn() {
        // PanelCtrl.instance.show('Buy1');
        const prop1Nums = getPropNums(PropType.HAMMER);
        this.hammer++;
        this['nums1Txt'].text = (this.hammer + this.videoProp[1]) + "";
        if (prop1Nums - this.hammer <= 0) {
            this['buy1btn'].visible = false;
        }
    }
    onTap_buy2btn() {
        // PanelCtrl.instance.show('Buy2');
        const prop2Nums = getPropNums(PropType.BOOM);
        this.boom++;
        this['nums2Txt'].text = (this.boom + this.videoProp[0]) + "";
        if (prop2Nums - this.boom <= 0) {
            this['buy2btn'].visible = false;
        }
    }
    onTap_buy3btn() {
        // PanelCtrl.instance.show('Buy3');
        const prop3Nums = getPropNums(PropType.CHANCE_NUM);
        this.step++;
        this['nums3Txt'].text = (this.step + this.videoProp[2]) + "";
        if (prop3Nums - this.step <= 0) {
            this['buy3btn'].visible = false;
        }
    }

    //锤子
    onTap_video1btn() {
        //看视频按钮点击
        NetManager.ins.clickLog(getlogItem(2))
        NetManager.ins.getTuiaAd(
            () => {
                this['video1btn'].visible = false;
                this.videoProp[1] = 1;
                this['nums1Txt'].text = (this.hammer + this.videoProp[1]) + "";
                showToast("增加一个锤子道具")
            },
            () => { showToast("广告未成功观看，道具领取失败") },
        )
    }
    //炸弹
    onTap_video2btn() {
        //看视频按钮点击
        NetManager.ins.clickLog(getlogItem(2))
        NetManager.ins.getTuiaAd(
            () => {
                this['video2btn'].visible = false;
                this.videoProp[0] = 1;
                this['nums2Txt'].text = (this.boom + this.videoProp[0]) + "";
                showToast("增加一个炸弹道具")
            },
            () => { showToast("广告未成功观看，道具领取失败") }
        )
    }
    //步数
    onTap_video3btn() {
        //看视频按钮点击
        NetManager.ins.clickLog(getlogItem(2))
        NetManager.ins.getTuiaAd(
            () => {
                this['video3btn'].visible = false;
                this.videoProp[2] = 1;
                this['nums3Txt'].text = (this.boom + this.videoProp[2]) + "";
                showToast("增加一个增加步数道具")
            },
            () => { showToast("广告未成功观看，道具领取失败") }
        )
    }

    get skinKey() { return 'StartPanel' }
}