import Panel from "../../libs/new_wx/components/Panel";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { addRankFriendList } from "../mapScene/RankFriendList";
import { changeMapScene } from "../startScene/StartScene";
import { showToast } from "../../libs/new_wx/ctrls/toastCtrl";
import { getlogItem } from "../Main";

export default class FailedPanel extends Panel {
    _level;
    start(data) {
        super.start();
        if (data)
            this._level = parseInt(data.level + '');
        NetManager.ins.hc_home(() => { }, window['collectRuleId']);

        this['againBtn'].addEventListener(egret.TouchEvent.TOUCH_TAP, () => {
            this.hidePanel();
            if (this._level)
                changeMapScene({ level: this._level });
            else
                changeMapScene();

        }, this);

        addRankFriendList(84, 772.52, this);

        //曝光
        NetManager.ins.showLog(getlogItem(3))

        //新增视频
        if (data.showVideo) {
            this["videoBtn"].visible = true;
            this["videoBtn"].addEventListener(egret.TouchEvent.TOUCH_TAP, () => {
                NetManager.ins.clickLog(getlogItem(4))
                NetManager.ins.getTuiaAd(
                    () => {
                        this.hidePanel();
                        data.complete();
                    },
                    () => { showToast("广告未成功观看，无法复活"); }
                )
            }, this);
        }
    }

    onTouchTap_closeBtn() {
        super.onTouchTap_closeBtn();
        changeMapScene();
    }

    protected get closeBtns(): eui.Button[] { return [this['closeBtn']] }
    get skinKey() { return 'Fail' }
}