import Panel from "../../libs/new_wx/components/Panel";
import PanelCtrl from "../../libs/new_wx/ctrls/panelCtrl";
import BagItemRenderer from "./bag/BagItemRenderer";
import { getPropNums } from "../getHomeData";
import PropType from "../PropType";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { getlogItem } from "../Main";

export default class BagPanel extends Panel {
    list:eui.List;
    start(data) {
        super.start();
        
        this['shopbtn'].addEventListener(egret.TouchEvent.TOUCH_TAP, () => {
            PanelCtrl.instance.show('Shop');
        }, this);

        this.list.itemRenderer=BagItemRenderer;
        const prop2Nums = getPropNums(PropType.BOOM);
        const prop1Nums = getPropNums(PropType.HAMMER);
        const prop3Nums = getPropNums(PropType.CHANCE_NUM);
        this.list.dataProvider = new eui.ArrayCollection([
            
            {
                type:'boom',
                nums:prop2Nums
            },
            {
                type:'hammer',
                nums:prop1Nums
            },
            {
                type:'change',
                nums:prop3Nums
            }
        ]);
    }



    initEvents() {
        super.initEvents();
        // this['inviteBtn'].addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTapInvite, this)
    }
    protected get closeBtns(): eui.Button[] { return [this['closeBtn'], this['closeBtn2']] }
    get skinKey() { return 'Bag' }
}