import ComponentBase from "../../libs/new_wx/components/ComponentBase";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetManager } from "../../libs/tw/manager/NetManager";
import FriendItem2Renderer from "../panels/FriendItem2Renderer";
import StartPanel from "../panels/StartPanel";

export default class RankFriendList extends ComponentBase {
    public friendlist: eui.List;
    start(data?) {
        this.friendlist.useVirtualLayout = false;
        this.friendlist.itemRenderer = FriendItem2Renderer;
        this.friendlist.visible = false;
        this['empty'].visible = false;

        NetManager.ins.hc_levelNumRank(() => {
            let friends = DataManager.ins.getData('hc_levelNumRank').data;
            if (friends == null)
                friends = { rank: [] };
            friends = friends.rank;
            if (friends && friends.length > 0) {
                this.friendlist.visible = true;
                if (friends.length > 5)
                    friends.length = 5;
                friends.forEach((ele, index) => {
                    ele.rank = index + 1;
                });
                const ac = new eui.ArrayCollection(friends);
                this.friendlist.dataProvider = ac;
            }
            else {
                this['empty'].visible = true;
            }

        }, data)
    }

    get skinKey(): string { return 'RankFriendList' }
}

export const addRankFriendList = (x, y, parent: egret.DisplayObjectContainer,level?) => {
    //先去掉好友排行 去掉
    // if(!level) 
    //     level = StartPanel.currlevel;
    // const comp = new RankFriendList();
    // comp.loadSkin();
    // comp.start(level);
    // parent.addChildAt(comp, 0);
    // comp.x = x;
    // comp.y = y;
}
