export default class CountDown extends egret.EventDispatcher {
    _txt: eui.Label;
    _timer: egret.Timer;
    _func;
    constructor(txt?,func?) {
        super();
        this._txt = txt;
        this._func = func;
        this._timer = new egret.Timer(1000);
        this._timer.addEventListener(egret.TimerEvent.TIMER, this.onTimer, this);
        this._timer.addEventListener(egret.TimerEvent.TIMER_COMPLETE, this.onTimerComplete, this);
    }

    onTimerComplete(e) {
        this.dispatchEvent(e);
    }

    onTimer() {
        this.updateTxt();
    }

    updateTxt() {
        if(!this._txt) return;
        const left = this._timer.repeatCount - this._timer.currentCount;
        const h = Math.floor( left / 3600);
        const m = Math.floor ( (left % 3600) / 60 );
        const s = left % 3600 % 60;
        this._txt.text = `${this.getNumber(h)}:${this.getNumber(m)}:${this.getNumber(s)}`;
        if(this._func) {
            this._txt.text = this._func(this._txt.text);
        }
    }

    getNumber(n) {
        return n >= 10 ? `${n}` : `0${n}`
    }

    stop() {
        this._timer.stop();
    }

    reset(repeatCount: number) {
        this._timer.stop();
        this._timer.repeatCount = repeatCount;
        this._timer.reset();
        if(repeatCount  > 0)
        this._timer.start();
        this.updateTxt();
    }
}