import './index.less';

const padNum = (num) => {
  if (typeof num === 'number') {
    return num.toLocaleString();
  } else {
    return num;
  }
};
export default {
  name: 'landPage',
  zIndex: 10,
  created() {
    this.el.classList.add('video-land-page');
    this.el.innerHTML = `
      <div class="video-land-page-content">
        <img class="app-close"
          src="data:image/png;base64,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">
        </img>
        <div class="app-info-wrap">
          <div class="app-logo"></div>
          <div class="app-name"></div>
          <div class="app-tips">新人下载立领60元现金礼包</div>
          <div class="app-button"></div>
          <div class="app-download-num"></div>
        </div>
      </div>
    `;
    this.appNameEl = this.el.querySelector('.app-name');
    this.appClose = this.el.querySelector(".app-close");
    this.appButtonEl = this.el.querySelector('.app-button');
    this.appIcon = this.el.querySelector('.app-logo');
    this.appDownloadNum = this.el.querySelector('.app-download-num');
    this.el.addEventListener('click', (e) => {
      if (e.target === this.appButton) {
        this.$player.event.emit('$footerPageButtonClick');
      } else if (e.target === this.appClose) {
        this.hide();
      } else {
        this.$player.event.emit('$footerPageClick');
      }
    });
    this.hide();
  },
  methods: {
    hide() {
      this.el.style.display = 'none';
    },
    show() {
      this.el.style.display = 'block';
    }
  },
  event: {
    $landPageChangeApp({ name, appIcon, buttonText, donloadNum }, show = true) {
      if (!show) {
        this.hide();
        return;
      } else {
        this.show();
      }
      if (name) {
        console.log(name);
        this.appNameEl.innerText = name;
      };
      if (donloadNum) {
        this.appDownloadNum.innerText = `今天有${donloadNum}人已下载`;
      }
      if (buttonText) {
        this.appButtonEl.innerText = buttonText;
      }
      if (appIcon) {
        this.appIcon.style.backgroundImage = `url(${appIcon})`;
      }
    },
    ended() {
      this.show();
    },
    $videoReset() {
      this.hide();
    }
  }
};
