import ComponentBase from "./ComponentBase";
import { HtmlTextParser } from "../HtmlTextParser";
import { gotoNextLevel } from "../../../src/panels/gotoNextLevel";
import SceneCtrl from "../ctrls/sceneCtrl";
import MainScene from "../../../src/mainScene/MainScene";

export default class Toast2 extends ComponentBase {


    get skinResKey() { return 'common' }
    get skinKey(): string { return 'Toast2' }
    toastLabel: eui.Label;
    start() {
        this.toastLabel.textFlow = (new HtmlTextParser).parser('<u>继续闯关赢好礼</u>');
        if (!this.hasEventListener(egret.TouchEvent.TOUCH_TAP)) {
            this.addEventListener(egret.TouchEvent.TOUCH_TAP, () => {
                if (SceneCtrl.instance.currentScene instanceof MainScene) {

                } else {
                    gotoNextLevel();
                }
                egret.Tween.removeTweens(this);
                this.alpha = 0;

                this.touchEnabled = false;
                this.touchChildren = false;

            }, this);
        }

        return this;
    }
}