import ComponentBase from "./ComponentBase";
export default class Scene extends ComponentBase {
    protected onSkinComplete() {
        super.onSkinComplete();
        this.createLayers();
    }

    start(data?) {
        super.start(data);
        this.height = this.stage.stageHeight;
        this.playAnimation();
    }

    onLoad(){
        return new Promise((resolve, reject)=>{
            resolve();
        })
    }

    updateScene(){
        
    }

    playAnimation() {

    }

    private _map: { [key: string]: egret.Sprite }
    createLayers() {
        this._map = {};
        for (const key of this.layerKeys) {
            const layer = new egret.Sprite();
            this.addChild(layer);
            this._map[key] = layer;
        }
    }

    getLayer(key) {
        return this._map[key]
    }

    protected get layerKeys() {
        return []
    }


}