export default class Loading extends egret.Sprite {
    private static _parent: egret.Sprite;
    private static _instance: Loading;
    private static bg = 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAKAAAAC0CAYAAAATiCegAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAyNpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuNi1jMTQwIDc5LjE2MDQ1MSwgMjAxNy8wNS8wNi0wMTowODoyMSAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczp4bXBNTT0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIgeG1sbnM6c3RSZWY9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZVJlZiMiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIENDIChNYWNpbnRvc2gpIiB4bXBNTTpJbnN0YW5jZUlEPSJ4bXAuaWlkOjNCQzYyMjY2QTc2NDExRTg5QTUzRjU2RkQ3RDBDQzhDIiB4bXBNTTpEb2N1bWVudElEPSJ4bXAuZGlkOjNCQzYyMjY3QTc2NDExRTg5QTUzRjU2RkQ3RDBDQzhDIj4gPHhtcE1NOkRlcml2ZWRGcm9tIHN0UmVmOmluc3RhbmNlSUQ9InhtcC5paWQ6M0JDNjIyNjRBNzY0MTFFODlBNTNGNTZGRDdEMENDOEMiIHN0UmVmOmRvY3VtZW50SUQ9InhtcC5kaWQ6M0JDNjIyNjVBNzY0MTFFODlBNTNGNTZGRDdEMENDOEMiLz4gPC9yZGY6RGVzY3JpcHRpb24+IDwvcmRmOlJERj4gPC94OnhtcG1ldGE+IDw/eHBhY2tldCBlbmQ9InIiPz4bbLCYAAACQklEQVR42uzZT0rDQBTA4fwBodssPEO3XiAH6Mqjuip0m2v0DrlBwYlkMJRUU6vzEL4PHlmUuhh+vGawrrY7zM9+fnYVfBrn5zA/j1u+VG8MrxccPwhy+C7EWnhEhth+Ed9rmp3z40FTQ/s0lzTnLQHm+OA3rUbYio/ICFvxERlhs/igdzYU0l9vwGn7vTgXCl5MPrZgY/sRuQVb24/ILdg4ByI1fn6J/Bm2AQnfgP7XS5TOBiR8A4IAESAIEAGCABEgCBABggARIAgQAYIAESAIEAGCABEgCBABggARIAgQAYIAESAIEAGCABEgCBABIkAQIAIEASJAECACBAEiQBAgAgQBIkAQIAIEASJAECACBAEiQBAgAgQBIkAQIAIEASJAECACRIAgQAQIAkSAIEAECAJEgCBABAgCRIAgQAQIAkSAIEAECAJEgCBABAgCRIAgQAQIAkSAIEAECAJEgAgQBIgAQYAIEASIAEGACBAEiABBgAgQBIgAQYAIEASIAEGACBAEiABBgAgQBIgAQYAIEASIAEGACBABggARIAgQAYIAESAIEAGCABEgCBABggARIAgQAYIAESAIkP8V4OgYCDLagIRq0zyl2TsKApxsQMLfAY/eA4l4/5vayxtwcB4UNuQNWNmCRGy/ZYC2IMW3X74FZ+c0Fzdi/thb3n7XAYqQovGtBShCisV3K8BlhM9pds6OBy8cp7X4JvWGP3BI06fpnCV3hjfcCu+eAJchVnOMlSBZCW55wz1u+dK7AAMAr747P8Ezfo0AAAAASUVORK5CYII=';
    private static progress = 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADgAAAA4CAYAAACohjseAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAyNpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuNi1jMTQwIDc5LjE2MDQ1MSwgMjAxNy8wNS8wNi0wMTowODoyMSAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczp4bXBNTT0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIgeG1sbnM6c3RSZWY9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZVJlZiMiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIENDIChNYWNpbnRvc2gpIiB4bXBNTTpJbnN0YW5jZUlEPSJ4bXAuaWlkOjJGRDM0MjA1QTc4NDExRTg5QTUzRjU2RkQ3RDBDQzhDIiB4bXBNTTpEb2N1bWVudElEPSJ4bXAuZGlkOjJGRDM0MjA2QTc4NDExRTg5QTUzRjU2RkQ3RDBDQzhDIj4gPHhtcE1NOkRlcml2ZWRGcm9tIHN0UmVmOmluc3RhbmNlSUQ9InhtcC5paWQ6M0JDNjIyNjhBNzY0MTFFODlBNTNGNTZGRDdEMENDOEMiIHN0UmVmOmRvY3VtZW50SUQ9InhtcC5kaWQ6MkZEMzQyMDRBNzg0MTFFODlBNTNGNTZGRDdEMENDOEMiLz4gPC9yZGY6RGVzY3JpcHRpb24+IDwvcmRmOlJERj4gPC94OnhtcG1ldGE+IDw/eHBhY2tldCBlbmQ9InIiPz4SQhovAAABqUlEQVR42uyavW6EMAzHSQbEgrqxlQWpU5+m6ov0SfoifZxOlVArurFVLIAEbS0ViUbJ5ds57vxbDhhs/xMfJI6zDIllWd6//4BrLL8MyxEI++f4Fwy/PLtwSCAJJIFnLrBt25thGO7h91yCtomJ6QzVdf203Y/j+FKW5WvKzwQIK4ricbvvuu65aZovpxmsqup2fw+GwUGqmRPFyWK0Etj3/af4LJVImThVjFYrGZVh23T1SVGfGLQvGTAAhlLNpO8AG30mQohc1/VDdh07exjmaKbwxVI5xvJhvZJRpWue53ehZk9my3UAnZZqMpHzPL+FEijaivEXME6laZoeYrxNY9omCIIgiI19xdkUzMq0b5xM3KcZL2KRKtOq/WTUpdqR4KZ7M9XeDoujxEkQBEFcD0coWTCfAPalvZhlQx/bPEQAQMyyoc8xAQ8hDohZNvQRefGle47l0LbTKdSpFsMaTdfzwejHZ5hpGWMmTwqEJoSU4kxE6jotrJoQUojTiQzahJDslOeESF0TgpZQjUBixQsrJuoXPTokkASSwCsR6NLpFIIfAQYAmaA+/cC+3MAAAAAASUVORK5CYII=';

    getBitmap(base64: string, callback: (bitmap) => void): void {


        const img = new Image();
        img["avaliable"] = true;
        img.src = base64;
        img.onload = () => {
            const texture = new egret.Texture();
            const bitmapdata = new egret.BitmapData(img);
            texture._setBitmapData(bitmapdata);
            callback(new egret.Bitmap(texture));
        }
    }

    _bg: egret.Bitmap;
    _progress: egret.Bitmap;
    loadImage() {
        var bg: egret.Shape = new egret.Shape();
        bg.graphics.beginFill(0x000000, 0);
        bg.graphics.drawRect(0, 0, 750, 1624);
        bg.graphics.endFill();
        bg.touchEnabled = true;
        this.addChild(bg);

        this.getBitmap(Loading.bg, (bitmap: egret.Bitmap) => {
            const t = Date.now() - window['__startTime__'];
            console.log(`首屏loading显示时间：${t}ms`);
            this._bg = bitmap;
            this._bg.x = 295;
            this._bg.y = 288;
            this.addChild(this._bg);
        })

        this.getBitmap(Loading.progress, (bitmap: egret.Bitmap) => {
            this._progress = bitmap;
            this._progress.x = 375;
            this._progress.y = 380;
            this._progress.anchorOffsetX = this._progress.anchorOffsetY = 28;
            this.addChild(this._progress);
        })
    }

    static get instace(): Loading {
        return Loading._instance || (Loading._instance = new Loading());
    }

    show() {
        Loading._parent.addChild(this);
        this.addEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame, this);
    }

    hide() {
        if (this.parent)
            Loading._parent.removeChild(this);
        this.removeEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame, this);
    }

    static init(parent: egret.Sprite) {
        Loading._parent = parent;
    }

    onEnterFrame() {
        if (this._progress)
            this._progress.rotation += 5;
    }
}

