import { getBgOn, toggleBgStatus } from "./soundCtrl";

let bgChannel: egret.SoundChannel;
let loading = false;

export const toggleGameBg = () => {
    toggleBgStatus();
    const bgOn=getBgOn();
    if (bgChannel) {
        if (!bgOn) {
            bgChannel.stop();
            bgChannel = null;
        }
    } else {
        if (bgOn) {
            playGameBg();
        }
    }
}

export const stopGamebg = () => {
    if (!bgChannel) return;
    bgChannel.stop();
    bgChannel = null;
}

export const playGameBg = async () => {
    if (bgChannel) return;
    if (loading) return;
    loading = true;
    const bg = await RES.getResAsync('playBg_mp3');
    bgChannel = bg.play();
    loading = false;
}