import { PropNumber } from "./PropNumber";

/**
 * 道具显示数字
 */
export class PropNumShow extends egret.DisplayObjectContainer {
    /**
     * 灰度滤镜
     */
    private colorFlilter;
    /**
     * 数量文案
     */
    private countNum: PropNumber;
    /**
     * 数量
     */
    private _count: number;
    get count(): number {
        return this._count;
    }
    set count(value: number) {
        if (value <= 0) {
            value = 0;
            //变灰
            this.filters = [this.colorFlilter];
        } else {
            this.filters = [];
        }
        this._count = value;
        this.countNum.num = value;
    }
    constructor() {
        super();
        //滤镜
        var colorMatrix = [
            0.3, 0.6, 0, 0, 0,
            0.3, 0.6, 0, 0, 0,
            0.3, 0.6, 0, 0, 0,
            0, 0, 0, 1, 0
        ];
        this.colorFlilter = new egret.ColorMatrixFilter(colorMatrix);
        //背景
        var bg = new egret.Bitmap(RES.getRes("propNumBg_png"))
        this.addChild(bg)
        //数字
        this.countNum = new PropNumber();
        this.countNum.x = 22.5;
        this.countNum.y = 7;
        this.addChild(this.countNum);
        this.count = 0;
    }
}