import { ElementType } from "../enum/ElementType";
import { TargetNumber } from "./TargetNumber";
import { ElementTarget } from "./ElementTarget";

/**
 * 通关目标是元素时的单个元素的ui
 * 
 */
export class ElementTargets extends egret.DisplayObjectContainer {
    targets: ElementTarget[];
    constructor(passElement: number[]) {
        super()
        this.targets = [];
        for (var i = 0; i < passElement.length; i++) {
            if (passElement[i]) {
                var eleTar: ElementTarget = new ElementTarget(i);
                eleTar.count = passElement[i];
                this.addChild(eleTar);
                this.targets[i] = eleTar;
            }
        }
        this.center()
    }

    center() {
        //按顺序排，从右到左，
        var len = this.$children.length;
        var w = 80 * 0.8;
        var space = 25
        var right = len / 2 * w - w + (len - 1) / 2 * space;
        for (var i = this.$children.length - 1; i >= 0; i--) {
            this.$children[i].x = right - w * i - space * i;
        }
    }
}