import { ElementType } from "../enum/ElementType";

//三种状态的图片，剩三种了
const images = {
    2: "ele" + ElementType.FESTIVALELE_BIG + "_png",
    1: "eggStatus1_png",
    0: "eggStatus0_png"
}
/**
 * 节日元素
 * 
 */
export class FestivalEle extends egret.DisplayObjectContainer {
    /**
     * 是否要分裂了
     */
    isActive: boolean;
    /**
     * 状态变化 2 1 0 再往后，可分裂
     */
    private _statusNum: number;
    get statusNum() {
        return this._statusNum
    }
    set statusNum(value: number) {
        if (value >= 0) {
            //播放原来的动画
            let child = this.$children[this._statusNum];
            child["play"](() => {
                //切换
                this.toggleStatus(value);
            })
            this._statusNum = value;
        } else {
            //不用动画
            this._statusNum = 0;
            this.isActive = true;
        }
    }

    constructor(n: number = 2) {
        super();
        var status3 = new Status3();
        this.addChild(status3);
        var status2 = new Status2();
        this.addChild(status2);
        var status1 = new Status1();
        this.addChild(status1);

        this.toggleStatus(n);
        this.isActive = false;
        this._statusNum = n;
    }




    reset(n: number = 2) {
        this.toggleStatus(n);
        this.isActive = false;
        this._statusNum = n;
    }

    toggleStatus(index: number) {
        for (var i = 0; i < this.$children.length; i++) {
            var child = this.$children[i];
            if (i == index) {
                child.visible = true;
                //重置状态
                child["reset"]();
            } else {
                child.visible = false;
            }
        }
    }
}

//第一种状态
class Status1 extends egret.DisplayObjectContainer {
    upImage: egret.Bitmap;
    constructor() {
        super();
        var textureDown: egret.Texture = RES.getRes("fesRedBombSta1_png")
        var down = new egret.Bitmap(textureDown);
        down.x = -textureDown.textureWidth / 2;
        down.y = -textureDown.textureHeight / 2;
        this.addChild(down);
        var textureUp: egret.Texture = RES.getRes("xingxingbi_png");
        var up = new egret.Bitmap(textureUp);
        up.anchorOffsetX = textureUp.textureWidth / 2;
        up.anchorOffsetY = textureUp.textureHeight / 2;
        up.y = textureUp.textureHeight / 2 - 100;
        this.addChild(up);
        this.upImage = up;
        this.scaleX = this.scaleY = 0.29;
    }
    reset() {
        this.upImage.scaleX = this.upImage.scaleY = 1;
    }
    play(callback: Function) {
        egret.Tween.get(this.upImage)
            .to({ scaleX: 1.8, scaleY: 1.8 }, 240)
            .call(() => {
                callback();
            })
    }
}

const status2Cfg = [
    {
        "name": "fesRedCap",
        "x": -7,
        "y": -6,
        "width": 251,
        "height": 104
    },
    {
        "name": "fesRedSmallLight",
        "x": -7,
        "y": -14,
        "width": 249,
        "height": 159
    },
    {
        "name": "fesRedUp",
        "x": -2,
        "y": 52,
        "width": 237,
        "height": 185
    },
    {
        "name": "fesRedDown",
        "x": -2,
        "y": 0,
        "width": 237,
        "height": 237
    }
]

//第二种状态
class Status2 extends egret.DisplayObjectContainer {
    light: egret.Bitmap;
    fesRedCap: egret.Bitmap
    constructor() {
        super();
        this.scaleX = this.scaleY = 0.29
        for (var i = status2Cfg.length - 1; i >= 0; i--) {
            var bitmap = new egret.Bitmap(RES.getRes(status2Cfg[i].name + "_png"));
            bitmap.x = status2Cfg[i].x - 237 / 2;
            bitmap.y = status2Cfg[i].y - 237 / 2;
            this.addChild(bitmap);
            if (status2Cfg[i].name == "fesRedSmallLight") {
                this.light = bitmap
            } else if (status2Cfg[i].name == "fesRedCap") {
                this.fesRedCap = bitmap;
            }
        }
    }
    reset() {
        this.fesRedCap.scaleY = 1;
        this.light.alpha = 1;
        egret.Tween.get(this.light, { loop: true })
            .to({ alpha: 0 }, 450)
            .to({ alpha: 1 }, 450)

    }
    play(callback: Function) {
        this.light.alpha = 0;
        egret.Tween.removeTweens(this.light);
        this.fesRedCap.scaleY = 1;
        egret.Tween.get(this.fesRedCap)
            .to({ scaleY: 0.1 }, 180)
            .call(() => {
                callback();
            })
    }
}

const status3Cfg = [
    {
        "name": "fesRedUp",
        "x": 0,
        "y": 52,
        "width": 237,
        "height": 185
    },
    {
        "name": "tinyRedMid",
        "x": 86,
        "y": 60,
        "width": 74,
        "height": 90
    },
    {
        "name": "tinyRedLeft",
        "x": 22,
        "y": 5,
        "width": 116,
        "height": 132
    },
    {
        "name": "tinyRedRight",
        "x": 123,
        "y": 14,
        "width": 89,
        "height": 106
    },
    {
        "name": "fesRedDown",
        "x": 0,
        "y": 0,
        "width": 237,
        "height": 237
    }
]
class Status3 extends egret.DisplayObjectContainer {
    midRed: egret.Bitmap;
    leftRed: egret.Bitmap;
    rightRed: egret.Bitmap;
    constructor() {
        super();
        this.scaleX = this.scaleY = 0.29
        for (var i = status3Cfg.length - 1; i >= 0; i--) {
            var config = status3Cfg[i];
            var bitmap = new egret.Bitmap(RES.getRes(config.name + "_png"));
            bitmap.x = config.x - 237 / 2;
            bitmap.y = config.y - 237 / 2;
            this.addChild(bitmap);
            if (config.name == "tinyRedMid") {
                this.midRed = bitmap;
            } else if (config.name == "tinyRedLeft") {
                this.leftRed = bitmap;
            } else if (config.name == "tinyRedRight") {
                this.rightRed = bitmap;
            }
        }

    }
    reset() {
        egret.Tween.removeTweens(this.leftRed);
        egret.Tween.removeTweens(this.rightRed);
        egret.Tween.removeTweens(this.midRed);

        var offset = 237 / 2
        //动画出来，然后循环
        this.leftRed.x = 22 + 40 - offset;
        this.leftRed.y = 5 + 100 - offset;
        egret.Tween.get(this.leftRed)
            .to({ x: 22 - 3 - offset, y: 5 - 8 - offset }, 150)
            .to({ x: 22 - offset, y: 5 - offset }, 50)

        this.rightRed.x = 123 - 7 - offset;
        this.rightRed.y = 14 + 100 - offset;
        egret.Tween.get(this.rightRed)
            .to({ x: 123 + 3 - offset, y: 14 - 8 - offset }, 150)
            .to({ x: 123 - offset, y: 14 - offset }, 50)

        this.midRed.x = 86 - 7 - offset;
        this.midRed.y = 60 + 80 - offset;
        egret.Tween.get(this.midRed)
            .to({ x: 86 + 3 - offset, y: 60 - 8 - offset }, 150)
            .to({ x: 86 - offset, y: 60 - offset }, 50)
            .call(() => {
                //循环动画
                this.leftRed.x = 22 - offset;
                this.leftRed.y = 5 - offset;
                egret.Tween.get(this.leftRed, { loop: true })
                    .to({ x: 22 + 2 - offset, y: 5 + 5 - offset }, 150)
                    .to({ x: 22 - 6 - offset, y: 5 - 14 - offset }, 150)
                    .to({ x: 22 - offset, y: 5 - offset }, 100)
                    .wait(500);

                this.rightRed.x = 123 - offset;
                this.rightRed.y = 14 - offset;
                egret.Tween.get(this.rightRed, { loop: true })
                    .to({ x: 123 - 2 - offset, y: 14 + 5 - offset }, 150)
                    .to({ x: 123 + 6 - offset, y: 14 - 14 - offset }, 150)
                    .to({ x: 123 - offset, y: 14 - offset }, 100)
                    .wait(500);

                this.midRed.x = 86 - offset;
                this.midRed.y = 60 - offset;
                egret.Tween.get(this.midRed, { loop: true })
                    .to({ x: 86 - 2 - offset, y: 60 + 5 - offset }, 150)
                    .to({ x: 86 + 6 - offset, y: 60 - 14 - offset }, 150)
                    .to({ x: 86 - offset, y: 60 - offset }, 100)
                    .wait(500);
            })





    }
    play(callback: Function) {

    }
}