import { ElementType, FiveBaseElementTypes } from "../enum/ElementType";
import { EffectType } from "../enum/EffectType";
import { Pool } from "../Pool";
import { RecoverName } from "../enum/RecoverName";
import { MagicLionBgAni } from "../periodAni/MagicLionBgAni";
import { HorizontalBgAni } from "../periodAni/HorizontalBgAni";
import { VerticalBgAni } from "../periodAni/VerticalBgAni";
import { ExplosiveBgAni } from "../periodAni/ExplosiveBgAni";
import { ChickenEgg } from "./ChickenEgg";
import { State } from "./State";
import { StateType, stateDatas } from "../enum/StateType";
import { LockState } from "../states/LockState";
import { HairballBrownState } from "../states/HairballBrownState";

import { BubbleState } from "../states/BubbleState";
import { HairballGreyState } from "../states/HairballGreyState";
import { HairballBlackState } from "../states/HairballBlackState";
import { Tool } from "../Tool";
import { FestivalEle } from "./FestivalEle";


/**
 * 考虑到底继承白鹭的啥Component还是Container
 * 坐标原点需要坐落在格子的中心点
 * 最好到时按，底图，动效，气泡，笼子，毛球，进行分层，如果多个状态要共存时，必须分层，到时气泡的动画，要写再自己的层里
 */
export class Element extends eui.Component {
    /**
     * 初始类型
     */
    private _type: ElementType;
    get type() {
        return this._type
    }
    /**
     * 显示的图片，直接改source，"ele"+type
     */
    private showImage: eui.Image;

    temEffectType: EffectType = null;
    /**
     * 特效类型
     */
    private _effectType: EffectType = null;
    get effectType() {
        return this._effectType;
    }
    set effectType(value: EffectType) {
        if (this._effectType == value) return
        if (value != null) {
            //先去掉原先有的
            this.removeEffectHas();
            //赋值现在的
            switch (value) {
                case EffectType.MAGICLION:
                    this.changeSource("magicLion_png");
                    //添加MagicLionBgAni
                    this.magicLionBgAni = Pool.takeOut(RecoverName.MAGICLIONBG_ANI)
                    if (!this.magicLionBgAni) {
                        this.magicLionBgAni = new MagicLionBgAni();
                    } else {
                        this.magicLionBgAni.reset();
                    }
                    this.addChildAt(this.magicLionBgAni, 0);
                    break;
                case EffectType.HORIZONTAL:
                    this.changeSource("ele" + this.type + "Line" + "_png");
                    //添加HorizontalBgAni
                    this.horizontalBgAni = Pool.takeOut(RecoverName.HORIZONTALBG_ANI)
                    if (!this.horizontalBgAni) {
                        this.horizontalBgAni = new HorizontalBgAni();
                    } else {
                        this.horizontalBgAni.reset();
                    }
                    this.addChildAt(this.horizontalBgAni, 1)
                    break;
                case EffectType.VERTICAL:
                    this.changeSource("ele" + this.type + "Line" + "_png");
                    //添加VerticalBgAni
                    this.verticalBgAni = Pool.takeOut(RecoverName.VERTICALBG_ANI)
                    if (!this.verticalBgAni) {
                        this.verticalBgAni = new VerticalBgAni();
                    } else {
                        this.verticalBgAni.reset();
                    }
                    this.addChildAt(this.verticalBgAni, 1)
                    break;
                case EffectType.EXPLOSIVE:
                    this.changeSource("ele" + this.type + "Exp" + "_png");
                    this.explosiveBgAni = Pool.takeOut(RecoverName.EXPLOSIVEBG_ANI)
                    if (!this.explosiveBgAni) {
                        this.explosiveBgAni = new ExplosiveBgAni();
                    } else {
                        this.explosiveBgAni.reset();
                    }
                    this.addChildAt(this.explosiveBgAni, 1)
                    break;
            }
            this._effectType = value;
        } else {
            // console.log(this._effectType)
            //回收掉原先有的
            this.removeEffectHas();
            this.changeSource("ele" + this.type + "_png");
            this._effectType = null;
            // console.log(this)
        }
    }
    private magicLionBgAni: MagicLionBgAni;
    private horizontalBgAni: HorizontalBgAni;
    private verticalBgAni: VerticalBgAni;
    private explosiveBgAni: ExplosiveBgAni;
    /**
     * 索引
     */
    index: number
    /**
     * 第几行
     */
    row: number;
    /**
     * 第几列
     */
    column: number
    //鸡蛋
    chickenEgg: ChickenEgg;
    //节日红包大
    festivalEle: FestivalEle;

    /**
     * 所有的状态，注意，变色气泡特殊，不能和特效共存，所以初始化时，气泡的不能加特效。生成特效，去掉气泡
     * 索引必须按StateType的枚举
     */
    private states: State[] = []

    /**
     * 
     * @param type 只应该是基础元素和特殊元素
     */
    constructor(type: ElementType) {
        super();
        this._type = type;
        this.showImage = new eui.Image();
        this.changeSource("ele" + this.type + "_png");
        this.addChild(this.showImage);
        //鸡蛋
        if (type == ElementType.CHICKEN_EGG) {
            this.chickenEgg = Pool.takeOut(RecoverName.CHICKEN_EGG)
            if (!this.chickenEgg) {
                this.chickenEgg = new ChickenEgg();
            } else {
                this.chickenEgg.reset();
            }
            this.addChild(this.chickenEgg)
        }
        //节日红包
        else if (type == ElementType.FESTIVALELE_BIG) {
            this.festivalEle = Pool.takeOut(RecoverName.FESTIVAL_ELE)
            if (!this.festivalEle) {
                this.festivalEle = new FestivalEle();
            } else {
                this.festivalEle.reset();
            }
            this.addChild(this.festivalEle)
        }

    }

    /**
     * 替换资源时,同时修改
     * @param source 
     */
    changeSource(source: string) {
        // this.showImage.source = source;
        var texture: egret.Texture = RES.getRes(source);
        this.showImage.texture = texture

        this.showImage.x = -texture.textureWidth / 2;
        this.showImage.y = -texture.textureHeight / 2;

        //特殊逻辑，因为魔力鸟动效要旋转，所以隐藏原图showImage，还有鸡蛋，还有特殊节日元素大
        if (source == "magicLion_png" ||
            source == "ele" + ElementType.CHICKEN_EGG + "_png" ||
            source == "ele" + ElementType.FESTIVALELE_BIG + "_png") {
            this.showImage.alpha = 0;
        } else {
            this.showImage.alpha = 1;
        }
    }

    /**
     * 会重置掉所有特效类型，枷锁，鸡蛋等
     * @param type  只应该是基础元素和特殊元素
     */
    reset(type: ElementType) {
        this.alpha = this.scaleX = this.scaleY = 1;
        //类型重置，showImage修改
        this._type = type;
        this.changeSource("ele" + type + "_png");
        //特效重置
        this.effectType = null;
        this.temEffectType = null;
        //所有状态重置
        this.removeAllState();
        //如果类型是鸡蛋
        if (type == ElementType.CHICKEN_EGG) {
            this.chickenEgg = this.chickenEgg || Pool.takeOut(RecoverName.CHICKEN_EGG)
            if (!this.chickenEgg) {
                //新建
                this.chickenEgg = new ChickenEgg();
            } else {
                this.chickenEgg.reset();
            }
            this.addChild(this.chickenEgg)
        }
        else if (this.chickenEgg) {
            this.removeChild(this.chickenEgg);
            Pool.recover(RecoverName.CHICKEN_EGG, this.chickenEgg);
            this.chickenEgg = null;
        }
        //如果类型是节日红包大
        if (type == ElementType.FESTIVALELE_BIG) {
            this.festivalEle = this.festivalEle || Pool.takeOut(RecoverName.FESTIVAL_ELE)
            if (!this.festivalEle) {
                //新建
                this.festivalEle = new FestivalEle();
            } else {
                this.festivalEle.reset();
            }
            this.addChild(this.festivalEle)
        } else if (this.festivalEle) {
            this.removeChild(this.festivalEle);
            Pool.recover(RecoverName.FESTIVAL_ELE, this.festivalEle);
            this.festivalEle = null;
        }
    }

    /**
     * 只修改类型，不改变其他状态，主要针对修改基础元素类型
     * @param type  
     */
    resetType(type: ElementType) {
        //如果类型一致，return
        if (this._type == type) return
        //如果目标类型不是基础元素 或者原先不是基础元素
        if (FiveBaseElementTypes.indexOf(type) == -1 ||
            FiveBaseElementTypes.indexOf(this._type) == -1
        ) {
            this.reset(type)
        } else {
            this._type = type;
            //无特效，直接修改
            if (this._effectType == null) {
                this.changeSource("ele" + type + "_png");
            }
            //有特效 且不是魔力鸟的
            else if (this._effectType != EffectType.MAGICLION) {
                switch (this._effectType) {
                    case EffectType.HORIZONTAL:
                    case EffectType.VERTICAL:
                        this.changeSource("ele" + this.type + "Line" + "_png");
                        break;
                    case EffectType.EXPLOSIVE:
                        this.changeSource("ele" + this.type + "Exp" + "_png");
                        break
                }
            }
            //如果有气泡状态,气泡也要变成相应的
            if (this.hasState(StateType.BUBBLE)) {
                this.getState(StateType.BUBBLE).reset(type);
                //一样要隐藏showImage
                this.showImage.alpha = 0;
            }
        }
    }



    private removeEffectHas() {
        //回收掉原先有的
        switch (this._effectType) {
            case EffectType.MAGICLION:
                this.removeChild(this.magicLionBgAni);
                Pool.recover(RecoverName.MAGICLIONBG_ANI, this.magicLionBgAni);
                this.magicLionBgAni = null;
                break;
            case EffectType.HORIZONTAL:
                this.removeChild(this.horizontalBgAni);
                Pool.recover(RecoverName.HORIZONTALBG_ANI, this.horizontalBgAni);
                this.horizontalBgAni = null;
                break;
            case EffectType.VERTICAL:
                this.removeChild(this.verticalBgAni);
                Pool.recover(RecoverName.VERTICALBG_ANI, this.verticalBgAni);
                this.verticalBgAni = null;
                break;
            case EffectType.EXPLOSIVE:
                this.removeChild(this.explosiveBgAni);
                Pool.recover(RecoverName.EXPLOSIVEBG_ANI, this.explosiveBgAni);
                this.explosiveBgAni = null;
                break;
        }
    }

    public fallAni() {
        // egret.Tween.get(this, null, null, true)
        //     .set({ scaleY: 1 })
        //     .to({ scaleY: 0.7 }, 200)
        //     .to({ scaleY: 1 }, 100)
    }

    /**
     * 是否有该状态
     * @param state 
     */
    hasState(state: StateType): boolean {
        return !!this.states[state];
    }

    /**
     * 设置状态
     * @param state 状态类型
     * @param set true为设置
     */
    setState(state: StateType, set: boolean, data?: any) {
        //set为false的话，
        if (!set) {
            //如果原先有状态，去掉
            if (this.hasState(state)) {
                //自己回收,动画，然后从父级移除，最后进入pool
                this.states[state].recover();
                //置空
                this.states[state] = null;
                //如果状态是气泡，并且特效不是魔力鸟时，显示showImage，魔力鸟显示原图
                if (state == StateType.BUBBLE && this.effectType != EffectType.MAGICLION) this.showImage.alpha = 1;
            }
            //原先每状态不管
            else {
            }
        }
        //set为true的话
        else {
            //如果有状态，执行重置
            if (this.hasState(state)) {
                this.states[state].reset(data);
            }
            //没有的话加上
            else {
                var stateData = stateDatas[state];
                var recoverName: RecoverName = stateData.recoverName;
                var className = stateData.className;
                let stateEx = Pool.takeOut(recoverName);
                if (!stateEx) {
                    stateEx = new className(data);
                } else {
                    stateEx.reset(data)
                }
                this.states[state] = stateEx;
                //视图添加
                this.addChild(this.states[state]);
                //气泡定制逻辑
                if (state === StateType.BUBBLE) this.showImage.alpha = 0;
            }
        }
    }


    /**
     * 判断是否有任何特效，true表示有，false表示没有
     */
    hasAnyState(): boolean {
        for (var i = 0; i < this.states.length; i++) {
            if (this.states[i]) return true
        }
        return false
    }
    /**
     * 去掉所有状态
     */
    removeAllState() {
        for (var i = 0; i < this.states.length; i++) {
            let state = this.states[i];
            if (!state) continue
            //直接移除
            this.removeChild(state);
            //直接回收
            Pool.recover(stateDatas[i].recoverName, state);
            //置空
            this.states[i] = null;
        }
    }
    /**
     * 取得一个状态
     * @param state 
     */
    getState(state: StateType): any {
        return this.states[state]
    }

    /**
     * 克隆一个
     * 类型
     * 特效
     * 状态
     * 位置
     */
    clone(): Element {
        let ele = Tool.getElement(this.type);
        //特效加上
        ele.effectType = this.effectType;
        //状态加上
        for (var i = 0; i < this.states.length; i++) {
            let state = this.states[i];
            if (!state) continue;
            ele.setState(i, true, this.type)
        }
        //位置信息
        ele.x = this.x;
        ele.y = this.y;
        return ele
    }

    /**
     * 暂时给石门关闭的元素用的
     * 拷贝另一个元素的
     * 类型
     * 特效
     * 状态
     */
    copy(ele: Element) {
        //类型重置
        this.reset(ele.type);
        //特效加上
        this.effectType = ele.effectType;
        //状态加上
        for (var i = 0; i < ele.states.length; i++) {
            let state = ele.states[i];
            if (!state) continue;
            ele.setState(i, true, ele.type)
        }
    }

}