import { ChapterData } from "../interface/ChapterData";
import { PassType } from "../enum/PassType";
import { ElementType } from "../enum/ElementType";

/**
 * 101到120关数据
 */
export const Chapters6: ChapterData[] = [
    //101
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 27,
        passTarget: { type: 1, elements: [{ type: 10, count: 13 }] },
        starScores: [6000, 23000, 55000],
        map: {
            lattices: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1
            ],
            connectedLats: [],
            elements: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 2, 1, 1, 1, 2, 1, 1,
                1, 8, 2, 2, 1, 2, 2, 8, 1,
                2, 2, 2, 2, 8, 2, 2, 2, 2,
                1, 1, 1, 2, 2, 2, 1, 1, 1,
                8, 2, 2, 2, 2, 2, 2, 2, 8,
                8, 2, 2, 2, 2, 2, 2, 2, 8,
                8, 8, 8, 1, 1, 1, 8, 8, 8
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 10, 20, 30, 0, 0, 0,
                0, 0, 0, 20, 30, 20, 0, 0, 0,
                0, 0, 0, 0, 40, 0, 0, 0, 0,
                0, 0, 0, 0, 40, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                20, 0, 0, 0, 0, 0, 0, 0, 20,
                20, 0, 0, 0, 0, 0, 0, 0, 20,
                30, 20, 20, 0, 0, 0, 20, 20, 30
            ],
            recycles: [],
            generateLats: [
                { index: 12, type: null },
                { index: 13, type: null },
                { index: 14, type: null },
                { index: 20, type: null },
                { index: 24, type: null },
                { index: 28, type: null },
                { index: 34, type: null },
                { index: 36, type: null },
                { index: 44, type: null }
            ]
        }
    },
    //102
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 30,
        passTarget: { type: 1, elements: [{ type: 10, count: 6 }, { type: 5, count: 40 }] },
        starScores: [6000, 33000, 65000],
        map: {
            lattices: [
                0, 0, 1, 0, 0, 0, 1, 0, 0,
                0, 0, 0, 1, 0, 1, 0, 0, 0,
                0, 1, 1, 0, 0, 0, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 0, 1, 0, 1, 1, 1,
                0, 1, 1, 1, 1, 1, 1, 1, 0
            ],
            connectedLats: [],
            elements: [
                1, 1, 8, 1, 1, 1, 8, 1, 1,
                1, 1, 1, 2, 1, 2, 1, 1, 1,
                1, 2, 8, 1, 1, 1, 8, 2, 1,
                2, 8, 2, 2, 1, 2, 2, 8, 2,
                8, 2, 2, 2, 2, 2, 2, 2, 8,
                2, 2, 2, 1, 1, 1, 2, 2, 2,
                2, 2, 2, 1, 1, 1, 2, 2, 2,
                2, 2, 2, 1, 2, 1, 2, 2, 2,
                1, 2, 2, 1, 0, 1, 2, 2, 1,
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 22, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 30, 40, 30, 0, 0, 0,
                0, 0, 0, 40, 30, 40, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 22, 0, 22, 0, 0, 0
            ],
            recycles: [],
            generateLats: [{ index: 2, type: null }, { index: 6, type: null }, { index: 19, type: null }, { index: 25, type: null }, { index: 27, type: null }, { index: 30, type: null }, { index: 31, type: null }, { index: 32, type: null }, { index: 35, type: null }]
        }
    },
    //103
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: { type: 1, elements: [{ type: 5, count: 12 }, { type: 9, count: 17 }] },
        starScores: [5000, 12000, 21000],
        map: {
            lattices: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 3, 1, 1, 1, 3, 1, 1,
                1, 1, 3, 1, 1, 1, 3, 1, 1,
                1, 1, 3, 1, 1, 1, 3, 1, 1,
                1, 1, 3, 1, 1, 1, 3, 1, 1,
                1, 1, 3, 1, 1, 1, 3, 1, 1,
                0, 3, 3, 3, 3, 3, 3, 3, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0
            ],
            connectedLats: [],
            elements: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 2, 1, 1, 1, 2, 1, 1,
                1, 1, 2, 1, 1, 1, 2, 1, 1,
                1, 1, 5, 1, 1, 1, 5, 1, 1,
                1, 1, 2, 1, 1, 1, 2, 1, 1,
                1, 1, 2, 1, 1, 1, 2, 1, 1,
                1, 2, 5, 2, 5, 2, 5, 2, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0
            ],
            recycles: [],
            generateLats: [{ index: 0, type: null }, { index: 1, type: null }, { index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 7, type: null }, { index: 8, type: null }]
        }
    },
    //104
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 24,
        passTarget: { type: 1, elements: [{ type: 10, count: 15 }] },
        starScores: [5000, 12000, 21000],
        map: {
            lattices: [
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1
            ],
            connectedLats: [],
            elements: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 8, 8, 8, 1, 1, 1,
                1, 1, 1, 2, 2, 2, 1, 1, 1,
                8, 8, 2, 0, 0, 0, 2, 8, 8,
                8, 2, 2, 0, 0, 0, 2, 2, 8,
                2, 8, 2, 2, 2, 2, 2, 8, 2,
                8, 2, 2, 2, 2, 2, 2, 2, 8,
                2, 8, 2, 2, 2, 2, 2, 8, 2
            ],
            baseElements: [
                0, 0, 0, 30, 10, 30, 0, 0, 0,
                0, 0, 0, 10, 20, 10, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0
            ],
            recycles: [],
            generateLats: [
                { index: 3, type: null },
                { index: 4, type: null },
                { index: 5, type: null },
                { index: 36, type: null },
                { index: 37, type: null },
                { index: 38, type: null },
                { index: 42, type: null },
                { index: 43, type: null },
                { index: 44, type: null }
            ]
        }
    },
    //105
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 30,
        passTarget: { type: 1, elements: [{ type: 10, count: 18 }, { type: 5, count: 25 }] },
        starScores: [5000, 11000, 21000],
        map: {
            lattices: [
                1, 1, 1, 0, 1, 1, 1, 1, 1,
                1, 1, 1, 0, 1, 1, 1, 1, 1,
                1, 1, 1, 0, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1
            ],
            connectedLats: [],
            elements: [
                1, 1, 8, 1, 8, 8, 8, 8, 8,
                1, 1, 8, 1, 8, 8, 8, 8, 8,
                1, 1, 8, 1, 8, 8, 8, 8, 8,
                1, 1, 1, 1, 4, 4, 4, 4, 4,
                2, 2, 2, 4, 1, 0, 0, 0, 0,
                2, 2, 2, 4, 1, 0, 0, 0, 0,
                2, 2, 2, 4, 1, 0, 0, 0, 0,
                2, 2, 2, 4, 2, 2, 2, 2, 2,
                2, 2, 2, 4, 2, 2, 2, 2, 2
            ],
            baseElements: [
                10, 20, 42, 0, 0, 0, 0, 0, 0,
                20, 10, 33, 0, 0, 0, 0, 0, 0,
                10, 20, 41, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 20, 10, 20, 10, 20,
                0, 0, 0, 20, 0, 0, 0, 0, 0,
                0, 0, 0, 10, 0, 0, 0, 0, 0,
                0, 0, 0, 20, 0, 0, 0, 0, 0,
                0, 0, 0, 10, 0, 0, 0, 0, 0,
                0, 0, 0, 20, 0, 0, 0, 0, 0
            ],
            recycles: [],
            generateLats: [
                { index: 0, type: null },
                { index: 1, type: null },
                { index: 2, type: null },
                { index: 4, type: null },
                { index: 5, type: null },
                { index: 6, type: null },
                { index: 7, type: null },
                { index: 8, type: null },
                { index: 36, type: null },
                { index: 37, type: null },
                { index: 38, type: null },
                { index: 39, type: null }
            ]
        }
    },
    //106
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 30,
        passTarget: { type: 1, elements: [{ type: 9, count: 38 }, { type: 10, count: 18 }] },
        starScores: [6000, 11000, 19000],
        map: {
            lattices: [
                2, 2, 2, 1, 1, 1, 2, 2, 2,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                1, 1, 2, 2, 2, 2, 2, 1, 1,
                1, 1, 2, 1, 1, 1, 2, 1, 1,
                1, 1, 2, 1, 1, 1, 2, 1, 1,
                0, 0, 2, 1, 1, 1, 2, 0, 0,
                1, 1, 2, 2, 2, 2, 2, 1, 1,
                1, 1, 2, 1, 1, 1, 2, 1, 1,
                1, 1, 2, 2, 2, 2, 2, 1, 1
            ],
            connectedLats: [],
            elements: [
                1, 1, 1, 4, 4, 4, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                8, 8, 1, 1, 1, 1, 1, 8, 8,
                8, 8, 1, 8, 8, 8, 1, 8, 8,
                8, 8, 1, 8, 8, 8, 1, 8, 8,
                1, 1, 1, 4, 4, 4, 1, 1, 1,
                4, 4, 1, 1, 1, 1, 1, 4, 4,
                4, 4, 1, 1, 1, 1, 1, 4, 4,
                4, 4, 1, 1, 1, 1, 1, 4, 4
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                3, 1, 0, 2, 3, 2, 0, 1, 3,
                3, 1, 0, 2, 3, 2, 0, 1, 3,
            ],
            recycles: [],
            generateLats: [{ index: 0, type: null }, { index: 1, type: null }, { index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 7, type: null }, { index: 8, type: null }, { index: 47, type: null }, { index: 48, type: null }, { index: 49, type: null }, { index: 50, type: null }, { index: 51, type: null }, { index: 54, type: null }, { index: 55, type: null }, { index: 61, type: null }, { index: 62, type: null }]
        }
    },
    //107
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 30,
        passTarget: { type: 1, elements: [{ type: 5, count: 24 }, { type: 9, count: 15 }] },
        starScores: [6000, 22000, 45000], map: { lattices: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1], connectedLats: [], elements: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 1, 1, 1, 1, 2, 0, 0, 0, 2, 1, 1, 1, 1, 2, 0, 0, 0, 2, 1, 1, 1, 1, 7, 7, 7, 7, 7, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 5, 5, 5, 5, 5, 2, 2, 2, 2, 5, 5, 5, 5, 5, 2, 2, 2, 2, 5, 5, 5, 5, 5, 2, 2], baseElements: [10, 10, 20, 12, 14, 12, 40, 10, 10, 30, 21, 40, 0, 0, 0, 20, 41, 30, 30, 10, 20, 0, 0, 0, 40, 10, 30, 40, 40, 10, 0, 0, 0, 10, 20, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 0, type: null }, { index: 1, type: null }, { index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 7, type: null }, { index: 8, type: null }, { index: 45, type: null }, { index: 53, type: null }, { index: 54, type: null }, { index: 62, type: null }, { index: 63, type: null }, { index: 71, type: null }, { index: 72, type: null }, { index: 80, type: null }] }
    },
    //108
    {
        baseElementTypes: [1, 0, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 30,
        passTarget: { type: 1, elements: [{ type: 10, count: 9 }] },
        starScores: [6000, 12000, 21000],
        map: {
            lattices: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1
            ],
            connectedLats: [],
            elements: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 2, 2, 8, 8, 8, 2, 2, 1,
                1, 2, 2, 8, 8, 8, 2, 2, 1,
                1, 2, 2, 8, 8, 8, 2, 2, 1,
                1, 1, 1, 4, 4, 4, 1, 1, 1,
                1, 1, 4, 4, 4, 4, 4, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1
            ], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 10, type: null }, { index: 11, type: null }, { index: 12, type: null }, { index: 13, type: null }, { index: 14, type: null }, { index: 15, type: null }, { index: 16, type: null }, { index: 55, type: null }, { index: 56, type: null }, { index: 57, type: null }, { index: 58, type: null }, { index: 59, type: null }, { index: 60, type: null }, { index: 61, type: null }]
        }
    },
    //109
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 30,
        passTarget: { type: 1, elements: [{ type: 9, count: 65 }] },
        starScores: [6000, 11000, 18000],
        map: {
            lattices: [
                3, 3, 3, 3, 3, 0, 0, 0, 0,
                3, 3, 3, 3, 3, 0, 0, 0, 0,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                3, 3, 3, 3, 3, 0, 0, 0, 0,
                3, 3, 3, 3, 3, 0, 0, 0, 0
            ],
            // connectedLats: [[72, 0], [73, 1], [74, 2], [75, 3], [76, 4]],
            elements: [
                2, 7, 2, 7, 2, 1, 1, 1, 1,
                1, 2, 1, 2, 1, 1, 1, 1, 1,
                2, 7, 2, 7, 2, 2, 2, 2, 1,
                5, 5, 5, 5, 2, 2, 2, 1, 1,
                5, 5, 5, 5, 2, 1, 1, 1, 1,
                5, 5, 5, 5, 2, 2, 2, 1, 1,
                2, 7, 2, 7, 2, 2, 2, 2, 1,
                1, 2, 1, 2, 1, 1, 1, 1, 1,
                2, 2, 2, 2, 2, 1, 1, 1, 1
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                20, 0, 20, 0, 20, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 10,
                0, 0, 0, 0, 0, 0, 0, 20, 10,
                0, 0, 0, 0, 0, 20, 20, 10, 20,
                0, 0, 0, 0, 0, 0, 0, 20, 10,
                0, 0, 0, 0, 0, 0, 0, 0, 10,
                20, 0, 20, 0, 20, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0
            ],
            recycles: [],
            generateLats: [
                { index: 23, type: null },
                { index: 24, type: null },
                { index: 25, type: null },
                { index: 26, type: null },
                { index: 27, type: null },
                { index: 28, type: null },
                { index: 29, type: null },
                { index: 30, type: null },
                { index: 31, type: null },

                { index: 0, type: null },
                { index: 1, type: null },
                { index: 2, type: null },
                { index: 3, type: null },
                { index: 4, type: null },
            ]
        }
    },
    //110
    {
        baseElementTypes: [0, 1, 2, 3, 4], bubbleProbability: 0.1, stepCount: 20, passTarget: { type: 1, elements: [{ type: 9, count: 36 }] }, starScores: [6000, 12000, 21000], map: { lattices: [0, 3, 3, 3, 3, 3, 0, 0, 0, 3, 3, 3, 3, 3, 3, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0], connectedLats: [], elements: [2, 8, 8, 8, 8, 8, 2, 2, 2, 8, 8, 2, 2, 2, 2, 2, 2, 2, 8, 2, 2, 1, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 14, 14, 0], recycles: [], generateLats: [{ index: 1, type: null }, { index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 78, type: null }, { index: 79, type: null }] }
    },
    //111
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 30,
        passTarget: { type: 1, elements: [{ type: 9, count: 45 }] },
        starScores: [6000, 24000, 48888], map: { lattices: [0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 0, 0, 1, 3, 3, 3, 3, 3, 3, 3, 1, 1, 3, 3, 3, 3, 3, 3, 3, 1, 1, 3, 3, 3, 3, 3, 3, 3, 1, 1, 3, 3, 3, 3, 3, 3, 3, 1, 1, 3, 3, 3, 3, 3, 3, 3, 1, 1, 3, 3, 3, 3, 3, 3, 3, 1, 0, 0, 0, 3, 3, 3, 0, 0, 0], connectedLats: [], elements: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 7, 7, 7, 1, 1, 1, 1, 1, 1, 7, 7, 7, 1, 1, 1, 1, 1, 1, 7, 7, 7, 1, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 2, 8, 8, 8, 2, 1, 1, 1, 1, 2, 8, 8, 8, 2, 1, 1, 1, 1, 2, 8, 8, 8, 2, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 11, type: null }, { index: 15, type: null }, { index: 18, type: null }, { index: 19, type: null }, { index: 25, type: null }, { index: 26, type: null }] }
    },
    //112
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        stepCount: 21,
        passTarget: { type: PassType.ELEMENT_TARGET, elements: [{ type: ElementType.ICE, count: 9 }] },
        starScores: [4000, 8000, 15000],
        map: {
            lattices: [
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 3, 1, 1, 1, 0,
                0, 1, 1, 1, 3, 1, 1, 1, 0,
                0, 1, 1, 1, 3, 1, 1, 1, 0,
                0, 1, 3, 3, 3, 3, 3, 1, 0,
                0, 1, 1, 1, 3, 1, 1, 1, 0,
            ],
            elements: [
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 2, 2, 2, 1, 1, 0,
                0, 1, 1, 2, 4, 2, 1, 1, 0,
                0, 1, 1, 2, 4, 2, 1, 1, 0,
                0, 2, 2, 2, 4, 2, 2, 2, 0,
                0, 2, 4, 4, 4, 4, 4, 2, 0,
                0, 2, 2, 2, 4, 2, 2, 2, 0,
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0
            ],
            recycles: [],
            generateLats: [
                { index: 0, type: null },
                { index: 1, type: null },
                { index: 2, type: null },
                { index: 3, type: null },
                { index: 4, type: null },
                { index: 5, type: null },
                { index: 6, type: null },
                { index: 7, type: null },
                { index: 8, type: null }
            ]
        },

    },
    //113
    {
        baseElementTypes: [2, 3, 4, 0, 1],
        bubbleProbability: 0.1,
        stepCount: 40,
        passTarget: { type: 1, elements: [{ type: 9, count: 55 }] },
        starScores: [5000, 12000, 20000],
        map: {
            lattices: [
                2, 2, 2, 0, 0, 0, 2, 2, 2,
                2, 2, 2, 0, 0, 0, 2, 2, 2,
                2, 2, 0, 0, 0, 0, 0, 2, 2,
                0, 0, 0, 2, 2, 2, 0, 0, 0,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                2, 2, 2, 2, 0, 2, 2, 2, 2,
                2, 2, 2, 0, 2, 0, 2, 2, 2,
                0, 2, 0, 2, 2, 2, 0, 2, 0,
                0, 2, 2, 2, 2, 2, 2, 2, 0
            ],
            connectedLats: [[73, 0], [74, 1], [75, 2], [77, 6], [78, 7], [79, 8]],
            elements: [
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                8, 8, 1, 1, 1, 1, 1, 8, 8,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 2, 1, 1, 1, 1,
                1, 1, 1, 2, 1, 2, 1, 1, 1,
                2, 2, 2, 1, 1, 1, 2, 2, 2,
                1, 0, 1, 0, 0, 0, 1, 0, 1,
                1, 0, 0, 0, 8, 0, 0, 0, 1
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0
            ],
            recycles: [],
            generateLats: [
                { index: 30, type: null },
                { index: 31, type: null },
                { index: 32, type: null },
                { index: 36, type: null },
                { index: 37, type: null },
                { index: 38, type: null },
                { index: 42, type: null },
                { index: 43, type: null },
                { index: 44, type: null }
            ]
        }
    },
    //114
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0, stepCount: 37, passTarget: { type: 1, elements: [{ type: 9, count: 17 }] }, starScores: [5000, 12000, 21000], map: { lattices: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 3, 1, 3, 1, 3, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 3, 1, 3, 1, 3, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1], connectedLats: [], elements: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 4, 8, 4, 8, 4, 8, 4, 1, 1, 2, 2, 2, 2, 2, 2, 2, 1, 1, 4, 8, 4, 8, 4, 8, 4, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 0, type: null }, { index: 1, type: null }, { index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 7, type: null }, { index: 8, type: null }] }
    },
    //115
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0.1,
        stepCount: 40,
        passTarget: { type: 1, elements: [{ type: 6, count: 8 }] },
        starScores: [5000, 12000, 21000],
        map: {
            lattices: [
                1, 1, 0, 0, 1, 0, 0, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 1, 1, 1, 1, 1, 1, 1, 0
            ],
            connectedLats: [],
            elements: [
                3, 3, 1, 1, 3, 1, 1, 3, 3,
                4, 4, 2, 2, 4, 2, 2, 4, 4,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                7, 1, 1, 1, 1, 1, 1, 1, 7,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 8, 8, 8, 1, 1, 1
            ],
            recycles: [63, 71, 73, 74, 75, 76, 77, 78, 79],
            generateLats: [
                { index: 0, type: null },
                { index: 1, type: null },
                { index: 4, type: null },
                { index: 7, type: null },
                { index: 8, type: null },
                { index: 11, type: null },
                { index: 12, type: null },
                { index: 14, type: null },
                { index: 15, type: null },
                { index: 27, type: null },
                { index: 28, type: null },
                { index: 29, type: null },
                { index: 30, type: null },
                { index: 31, type: null },
                { index: 32, type: null },
                { index: 33, type: null },
                { index: 34, type: null },
                { index: 35, type: null },
                { index: 36, type: null },
                { index: 37, type: null },
                { index: 38, type: null },
                { index: 39, type: null },
                { index: 40, type: null },
                { index: 41, type: null },
                { index: 42, type: null },
                { index: 43, type: null },
                { index: 44, type: null },

                { index: 45, type: null },
                { index: 46, type: null },
                { index: 47, type: null },
                { index: 48, type: null },
                { index: 49, type: null },
                { index: 50, type: null },
                { index: 51, type: null },
                { index: 52, type: null },
                { index: 53, type: null }
            ]
        }
    },
    //116
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 30,
        passTarget: { type: 1, elements: [{ type: 9, count: 41 }] },
        starScores: [5000, 12200, 21000],
        map: {
            lattices: [
                1, 1, 1, 1, 1, 1, 0, 0, 0,
                1, 1, 1, 1, 1, 1, 3, 0, 0,
                1, 1, 3, 3, 3, 3, 3, 3, 0,
                1, 1, 3, 0, 3, 3, 3, 3, 3,
                1, 1, 3, 3, 3, 3, 3, 3, 3,
                1, 1, 3, 3, 3, 0, 3, 3, 3,
                0, 3, 3, 3, 3, 3, 3, 3, 0,
                0, 0, 3, 3, 3, 3, 3, 0, 0,
                0, 0, 0, 3, 3, 3, 0, 0, 0
            ],
            connectedLats: [[21, 39], [41, 59]],
            elements: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 2, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 2, 1,
                1, 1, 1, 1, 1, 4, 4, 1, 2,
                1, 1, 1, 1, 4, 8, 2, 8, 2,
                1, 1, 1, 4, 8, 1, 7, 7, 2,
                1, 2, 1, 4, 2, 7, 7, 2, 1,
                1, 1, 2, 1, 8, 7, 2, 1, 1,
                1, 1, 1, 2, 2, 2, 1, 1, 1
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0
            ],
            recycles: [],
            generateLats: [{ index: 0, type: null }, { index: 1, type: null }, { index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 15, type: null }, { index: 25, type: null }, { index: 35, type: null }]
        }
    },
    //117
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0.1,
        stepCount: 31,
        passTarget: { type: 1, elements: [{ type: 6, count: 6 }] },
        starScores: [5000, 12000, 21000],
        map: {
            lattices: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1
            ],
            connectedLats: [],
            elements: [
                2, 3, 2, 2, 2, 2, 2, 3, 2,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                2, 2, 2, 1, 1, 1, 2, 2, 2,
                2, 2, 2, 1, 1, 1, 2, 2, 2,
                1, 2, 1, 1, 1, 1, 1, 2, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 4, 1, 4, 1, 4, 1, 4, 1,
                1, 4, 1, 4, 1, 4, 1, 4, 1,
                2, 2, 2, 2, 1, 2, 2, 2, 2
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0
            ],
            recycles: [72, 73, 74, 75, 77, 78, 79, 80],
            generateLats: [
                { index: 0, type: null },
                { index: 1, type: null },
                { index: 2, type: null },
                { index: 3, type: null },
                { index: 4, type: null },
                { index: 5, type: null },
                { index: 6, type: null },
                { index: 7, type: null },
                { index: 8, type: null },

                { index: 12, type: null },
                { index: 13, type: null },
                { index: 14, type: null },
                { index: 21, type: null },
                { index: 22, type: null },
                { index: 23, type: null },
            ]
        }
    },
    //118
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 32,
        passTarget: { type: 1, elements: [{ type: 1, count: 16 }] },
        starScores: [5000, 12000, 21000],
        map: {
            lattices: [
                1, 1, 0, 1, 1, 1, 0, 1, 1,
                1, 1, 0, 1, 1, 1, 0, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 0, 0, 0, 0, 0
            ],
            connectedLats: [],
            elements: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                4, 4, 4, 4, 4, 4, 4, 4, 4,
                2, 2, 6, 2, 2, 2, 6, 2, 2,
                2, 8, 2, 2, 2, 2, 2, 8, 2,
                8, 1, 6, 1, 2, 1, 6, 1, 8,
                1, 1, 1, 1, 1, 1, 1, 1, 1
            ],
            recycles: [],
            generateLats: [
                { index: 0, type: null },
                { index: 1, type: null },
                { index: 3, type: null },
                { index: 4, type: null },
                { index: 5, type: null },
                { index: 7, type: null },
                { index: 8, type: null }
            ]
        }
    },
    //119
    { baseElementTypes: [0, 1, 2, 3, 4], bubbleProbability: 0, stepCount: 33, passTarget: { type: 1, elements: [{ type: 2, count: 50 }, { type: 3, count: 50 }] }, starScores: [5000, 12000, 21000], map: { lattices: [0, 0, 1, 0, 1, 0, 1, 0, 0, 1, 0, 0, 1, 1, 1, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0], connectedLats: [], elements: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 4, 1, 5, 4, 4, 1, 1, 1, 4, 4, 5, 1, 1, 4, 1, 1, 1, 4, 1, 1, 1, 1, 4, 1, 1, 1, 4, 1, 1, 5, 5, 5, 5, 5, 5, 5, 5, 5, 1, 1, 5, 8, 8, 8, 5, 1, 1], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 2, type: null }, { index: 4, type: null }, { index: 6, type: null }, { index: 9, type: null }, { index: 17, type: null }] } },
    //120
    {
        baseElementTypes: [0, 2, 3, 4, 1],
        bubbleProbability: 0.1,
        stepCount: 33,
        passTarget: { type: 1, elements: [{ type: 2, count: 50 }, { type: 3, count: 50 }] },
        starScores: [6000, 15000, 24000],
        map: { lattices: [0, 0, 3, 3, 3, 3, 3, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 3, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 3, 3, 3, 3, 3, 0, 0], connectedLats: [], elements: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 2, 2, 1, 2, 2, 7, 7, 1, 7, 7, 2, 2, 2, 2, 7, 1, 2, 1, 7, 2, 2, 2, 2, 7, 7, 2, 7, 7, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 5, 2, 2, 2, 5, 2, 2, 1, 2, 2, 5, 5, 5, 2, 2, 1, 1, 1, 2, 2, 1, 2, 2, 1, 1], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 10, type: null }, { index: 16, type: null }, { index: 18, type: null }, { index: 26, type: null }] }
    },
]