import { ChapterData } from "../interface/ChapterData";
import { PassType } from "../enum/PassType";
import { ElementType } from "../enum/ElementType";

/**
 * 1到20关数据
 */
export const Chapters1: ChapterData[] = [
    //第0关为空吧,
    null,
    //1引导基本消除
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 25,
        passTarget: {
            type: PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType.CHICKEN,
                    count: 45,
                },
            ],
        },
        starScores: [1000, 5000, 10000],
        map: {
            lattices: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 1, 0, 0, 0, 1, 0, 0,
                0, 1, 1, 1, 0, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 0, 0, 1, 0, 0, 0, 0,
            ],
            generateLats: [
                { index: 11, type: [0], cus: [] },
                { index: 15, type: [0], cus: [] },
            ],
            // connectedLats: [[0, 18], [1, 19], [2, 20]],
            elements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 1, 0, 0, 0, 1, 0, 0,
                0, 1, 1, 1, 0, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 0, 0, 1, 0, 0, 0, 0,
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 20, 0, 0, 0, 20, 0, 0,
                0, 20, 10, 20, 0, 20, 10, 20, 0,
                20, 10, 20, 10, 20, 10, 20, 10, 20,
                20, 10, 20, 20, 10, 20, 20, 10, 20,
                0, 20, 10, 20, 10, 20, 10, 20, 0,
                0, 0, 20, 10, 20, 10, 20, 0, 0,
                0, 0, 0, 20, 10, 20, 0, 0, 0,
                0, 0, 0, 0, 20, 0, 0, 0, 0,
            ],
            // recycles: [70, 71, 72, 73]
        },
    },
    //2引导冰块消除
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 6,
        passTarget: {
            type: PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType.ICE,
                    count: 26,
                },
            ],
        },
        starScores: [100, 500, 950],
        map: {
            lattices: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 1, 1, 0, 0, 0, 1, 1, 0,
                2, 2, 2, 2, 0, 2, 2, 2, 2,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 2, 2, 0, 0, 0, 1, 1, 0,
                1, 2, 2, 1, 0, 1, 2, 2, 1,
                0, 2, 2, 0, 0, 0, 2, 2, 0,
                2, 2, 2, 2, 0, 2, 2, 2, 2,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            generateLats: [
                // { index: 11, type: 0, cus: [] },
                // { index: 15, type: 0, cus: [] },
            ],
            // connectedLats: [[0, 18], [1, 19], [2, 20]],
            elements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 1, 1, 0, 0, 0, 1, 1, 0,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 1, 1, 0, 0, 0, 1, 1, 0,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                0, 1, 1, 0, 0, 0, 1, 1, 0,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 10, 10, 0, 0, 0, 10, 20, 0,
                20, 20, 10, 20, 0, 10, 20, 10, 20,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 40, 30, 0, 0, 0, 10, 30, 0,
                10, 30, 40, 20, 0, 20, 30, 40, 10,
                0, 40, 30, 0, 0, 0, 40, 30, 0,
                20, 20, 10, 10, 0, 20, 40, 20, 10,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            // recycles: [70, 71, 72, 73]
        },
    },
    //3引导石头消除
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 20,
        passTarget: {
            type: PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType.ROCK,
                    count: 19
                }
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
            ],
            elements: [
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 0, 2, 2, 1, 2, 2, 0, 0,
                0, 0, 2, 1, 2, 1, 2, 0, 0,
                0, 0, 1, 2, 1, 2, 1, 0, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            baseElements: [
                0, 0, 10, 10, 20, 10, 10, 0, 0,
                0, 0, 30, 40, 10, 40, 40, 0, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 0, 2, 2, 10, 2, 2, 0, 0,
                0, 0, 2, 10, 2, 10, 2, 0, 0,
                0, 0, 10, 2, 10, 2, 10, 0, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            generateLats: [
                { index: 2, type: [0], cus: [] },
                { index: 3, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
            ],
        },
    },
    //4
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: {
            type: PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType.ICE,
                    count: 24
                }
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 2, 2, 1, 1, 1, 2, 2, 0,
                0, 2, 2, 1, 1, 1, 2, 2, 0,
                0, 2, 2, 1, 1, 1, 2, 2, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 2, 2, 1, 1, 1, 2, 2, 0,
                0, 2, 2, 1, 1, 1, 2, 2, 0,
                0, 2, 2, 1, 1, 1, 2, 2, 0,
            ],
            elements: [
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            generateLats: [
                { index: 1, type: [0], cus: [] },
                { index: 2, type: [0], cus: [] },
                { index: 3, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
                { index: 7, type: [0], cus: [] },
            ],
        },
    },
    //5 直线引导
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 25,
        passTarget: {
            type: PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType.RABBIT,
                    count: 35
                },
                {
                    type: ElementType.CHICKEN,
                    count: 35
                }
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 0, 1, 1, 1, 0, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 0, 1, 1, 1, 0, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
            ],
            elements: [
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 0, 1, 1, 1, 0, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 0, 1, 1, 1, 0, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
            ],
            baseElements: [
                0, 10, 20, 10, 20, 10, 20, 10, 0,
                0, 20, 10, 20, 30, 20, 10, 20, 0,
                0, 10, 0, 10, 20, 30, 0, 10, 0,
                0, 20, 10, 20, 30, 1, 1, 1, 0,
                40, 50, 40, 50, 30, 40, 50, 40, 50,
                0, 20, 10, 20, 10, 30, 10, 20, 0,
                0, 10, 0, 10, 30, 10, 0, 10, 0,
                0, 20, 10, 20, 10, 20, 10, 20, 0,
                0, 10, 20, 10, 20, 10, 20, 10, 0,
            ],
            generateLats: [
                { index: 1, type: [0], cus: [] },
                { index: 2, type: [0], cus: [] },
                { index: 3, type: [0], cus: [] },
                { index: 4, type: [0], cus: [10, 20, 30, 40] },
                { index: 5, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
                { index: 7, type: [0], cus: [] },
            ],
        },
    },
    //6
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 25,
        passTarget: {
            type: PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType.ICE,
                    count: 17
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 1, 1, 1, 0, 1, 1, 1, 0,
                0, 1, 3, 3, 1, 3, 3, 1, 0,
                0, 1, 3, 3, 1, 3, 3, 1, 0,
                0, 0, 1, 1, 3, 1, 1, 0, 0,
                0, 1, 3, 3, 1, 3, 3, 1, 0,
                0, 1, 3, 3, 1, 3, 3, 1, 0,
                0, 1, 1, 1, 0, 1, 1, 1, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            elements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 1, 1, 1, 0, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 0, 1, 1, 1, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 10, 20, 20, 0, 30, 30, 50, 0,
                0, 40, 30, 30, 40, 10, 10, 30, 0,
                0, 10, 30, 30, 40, 10, 10, 50, 0,
                0, 0, 40, 40, 50, 40, 40, 0, 0,
                0, 30, 20, 20, 40, 50, 50, 20, 0,
                0, 30, 20, 20, 40, 50, 50, 10, 0,
                0, 40, 40, 50, 0, 20, 40, 20, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            generateLats: [
                { index: 10, type: [0], cus: [] },
                { index: 11, type: [0], cus: [] },
                { index: 12, type: [0], cus: [] },
                { index: 14, type: [0], cus: [] },
                { index: 15, type: [0], cus: [] },
                { index: 16, type: [0], cus: [] },
            ],
        },
    },
    //7
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 25,
        passTarget: {
            type: PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType.ICE,
                    count: 24
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 3, 3, 3, 3, 1,
                1, 1, 0, 1, 3, 3, 3, 3, 1,
                1, 1, 0, 1, 3, 3, 3, 3, 1,
                1, 1, 0, 1, 3, 3, 3, 3, 1,
                1, 1, 0, 1, 3, 3, 3, 3, 1,
                1, 1, 0, 1, 3, 3, 3, 3, 1,
                0, 0, 0, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            elements: [
                0, 0, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            baseElements: [
                0, 0, 0, 20, 20, 30, 30, 20, 20,
                10, 20, 0, 20, 20, 30, 30, 20, 20,
                10, 20, 0, 10, 10, 40, 40, 10, 10,
                20, 10, 0, 10, 10, 40, 40, 10, 10,
                10, 20, 0, 20, 20, 30, 30, 20, 20,
                20, 10, 0, 20, 20, 30, 30, 20, 20,
                20, 10, 0, 40, 40, 10, 10, 40, 40,
                0, 0, 0, 40, 40, 10, 10, 40, 40,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            generateLats: [
                { index: 9, type: [10, 20], cus: [] },
                { index: 10, type: [10, 20], cus: [] },
                { index: 3, type: [0], cus: [] },
                { index: 4, type: [0], cus: [10, 20, 30, 40] },
                { index: 5, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
                { index: 7, type: [0], cus: [] },
                { index: 8, type: [0], cus: [] },
            ],
        },
    },
    //8 引导爆炸
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 25,
        passTarget: {
            type: PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType.ICE,
                    count: 18
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 1, 0, 0, 0, 0, 1, 0,
                0, 2, 2, 2, 0, 0, 1, 1, 1,
                1, 2, 2, 2, 1, 0, 0, 1, 0,
                0, 2, 2, 2, 1, 1, 0, 1, 0,
                0, 0, 1, 1, 0, 1, 1, 1, 1,
                0, 0, 0, 1, 1, 2, 2, 2, 1,
                0, 1, 0, 0, 1, 2, 2, 2, 1,
                1, 1, 1, 1, 1, 2, 2, 2, 1,
                0, 1, 0, 0, 1, 1, 1, 1, 1,
            ],
            elements: [
                0, 0, 1, 0, 0, 0, 0, 1, 0,
                0, 1, 1, 1, 0, 0, 1, 1, 1,
                1, 1, 1, 1, 1, 0, 0, 1, 0,
                0, 1, 1, 1, 1, 1, 0, 1, 0,
                0, 0, 1, 1, 0, 1, 1, 1, 1,
                0, 1, 0, 1, 1, 1, 1, 1, 1,
                0, 1, 0, 0, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 1, 0, 0, 1, 1, 1, 1, 1,
            ],
            baseElements: [
                0, 0, 10, 0, 0, 0, 0, 10, 0,
                0, 20, 10, 20, 0, 0, 10, 30, 10,
                10, 10, 20, 10, 40, 0, 0, 10, 0,
                0, 10, 20, 10, 40, 40, 0, 10, 0,
                0, 0, 10, 40, 0, 40, 10, 20, 20,
                0, 0, 0, 40, 40, 30, 10, 10, 20,
                0, 10, 0, 0, 40, 10, 20, 10, 10,
                10, 30, 10, 10, 20, 10, 20, 30, 30,
                0, 10, 0, 0, 20, 20, 10, 30, 30,
            ],
            generateLats: [
                { index: 2, type: [0], cus: [40, 40] },
                { index: 7, type: [0], cus: [] },
                { index: 10, type: [0], cus: [30] },
                { index: 12, type: [0], cus: [] },
                { index: 15, type: [0], cus: [] },
                { index: 17, type: [0], cus: [] },
                { index: 18, type: [0], cus: [] },
                { index: 22, type: [0], cus: [] },
                { index: 42, type: [0], cus: [] },
                { index: 44, type: [0], cus: [] },
                { index: 55, type: [0], cus: [] },
                { index: 63, type: [0], cus: [] },
                { index: 65, type: [0], cus: [] },
                { index: 66, type: [0], cus: [] },
            ],
        },
    },
    //9 引导双特效
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 27,
        passTarget: {
            type: PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType.ICE,
                    count: 36
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                2, 2, 0, 1, 1, 0, 0, 1, 1,
                2, 2, 0, 2, 2, 1, 1, 2, 2,
                2, 2, 0, 2, 2, 1, 1, 2, 2,
                2, 2, 0, 1, 1, 1, 1, 1, 1,
                2, 2, 0, 1, 1, 1, 1, 1, 1,
                2, 2, 0, 1, 2, 2, 2, 2, 1,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                2, 0, 2, 2, 0, 2, 2, 0, 2,
                2, 0, 2, 2, 0, 2, 2, 0, 2,
            ],
            elements: [
                1, 1, 0, 1, 1, 0, 0, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                1, 0, 1, 1, 0, 1, 1, 0, 1,
                1, 0, 1, 1, 0, 1, 1, 0, 1,
            ],
            baseElements: [
                10, 10, 0, 50, 50, 0, 0, 50, 50,
                10, 10, 0, 40, 40, 30, 30, 20, 20,
                20, 20, 0, 40, 40, 30, 30, 20, 20,
                20, 20, 0, 20, 20, 10, 10, 40, 40,
                30, 30, 0, 20, 20, 10, 10, 40, 40,
                30, 30, 0, 40, 40, 20, 20, 30, 30,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                21, 0, 10, 10, 0, 20, 20, 0, 30,
                33, 0, 10, 10, 0, 20, 20, 0, 30,
            ],
            generateLats: [
                { index: 0, type: [0], cus: [] },
                { index: 1, type: [0], cus: [] },
                { index: 3, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 7, type: [0], cus: [] },
                { index: 8, type: [0], cus: [] },
                { index: 63, type: [0], cus: [] },
                { index: 65, type: [0], cus: [] },
                { index: 66, type: [0], cus: [] },
                { index: 68, type: [0], cus: [] },
                { index: 69, type: [0], cus: [] },
                { index: 71, type: [0], cus: [] },
            ],
        },
    },
    //10 引导魔力鸟
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 27,
        passTarget: {
            type: PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType.CHICKEN,
                    count: 35
                },
                {
                    type: ElementType.CATTLE,
                    count: 35
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 0, 1, 1, 1, 1, 1, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 1, 1, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 1, 0, 1, 1, 1, 1, 1, 1,
                0, 1, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                0, 1, 0, 1, 1, 1, 1, 1, 1,
                0, 1, 0, 1, 1, 1, 1, 1, 1,
            ],
            elements: [
                0, 0, 0, 1, 1, 1, 1, 1, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 1, 1, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 1, 0, 1, 1, 1, 1, 1, 1,
                0, 1, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                0, 1, 0, 1, 1, 1, 1, 1, 1,
                0, 1, 0, 1, 1, 1, 1, 1, 1,
            ],
            baseElements: [
                0, 0, 0, 30, 20, 30, 20, 30, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 20, 30, 20, 30, 20, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 20, 0, 30, 30, 20, 20, 10, 10,
                0, 20, 0, 30, 30, 20, 20, 10, 10,
                20, 30, 0, 40, 40, 30, 30, 20, 20,
                0, 20, 0, 40, 40, 30, 30, 20, 20,
                0, 20, 0, 10, 10, 20, 20, 10, 10,
            ],
            generateLats: [
                { index: 3, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
                { index: 7, type: [0], cus: [] },
                { index: 39, type: [0], cus: [] },
                { index: 40, type: [0], cus: [] },
                { index: 41, type: [0], cus: [] },
                { index: 42, type: [0], cus: [] },
                { index: 43, type: [0], cus: [] },
                { index: 44, type: [0], cus: [] },
            ],
            connectedLats: [[3, 21], [4, 22], [5, 23], [6, 24], [7, 25]]
        },
    },
    //11 
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: {
            type: PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType.ICE,
                    count: 37
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                2, 0, 0, 0, 2, 2, 2, 2, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 2, 2, 2, 2, 2, 2,
                0, 0, 0, 2, 2, 2, 2, 2, 2,
                0, 0, 0, 3, 3, 3, 3, 3, 3,
                2, 2, 0, 3, 3, 3, 3, 3, 3,
                0, 0, 0, 3, 3, 3, 3, 3, 3,
                0, 0, 0, 1, 1, 1, 1, 1, 1,
            ],
            elements: [
                1, 0, 0, 0, 1, 1, 1, 1, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 1, 1, 1, 1, 1, 1,
            ],
            baseElements: [
                11, 0, 0, 0, 20, 20, 30, 30, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 10, 10, 20, 20, 10, 10,
                0, 0, 0, 40, 40, 50, 50, 40, 40,
                0, 0, 0, 20, 20, 30, 30, 20, 20,
                0, 0, 0, 40, 40, 10, 10, 40, 40,
                11, 13, 0, 50, 50, 30, 30, 50, 50,
                0, 0, 0, 40, 40, 20, 20, 40, 40,
                0, 0, 0, 30, 30, 10, 10, 30, 30,
            ],
            generateLats: [
                { index: 0, type: [0], cus: [] },
                { index: 5, type: [0], cus: [14, 11, 14] },
                { index: 6, type: [0], cus: [11, 14, 11] },
                { index: 72, type: [0], cus: [] },
                { index: 73, type: [0], cus: [] },
                { index: 21, type: [0], cus: [] },
                { index: 22, type: [0], cus: [] },
                { index: 23, type: [0], cus: [] },
                { index: 24, type: [0], cus: [] },
                { index: 25, type: [0], cus: [] },
                { index: 26, type: [0], cus: [] },
            ],
        },
    },
    //12 
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: {
            type: PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType.CHICKEN,
                    count: 35
                },
                {
                    type: ElementType.CATTLE,
                    count: 35
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 0, 0, 1, 0, 0, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 1, 0, 0, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
            ],
            elements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 0, 0, 1, 0, 0, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 1, 0, 0, 0, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 20, 14, 20, 0, 0, 0,
                0, 0, 0, 0, 21, 0, 0, 0, 0,
                10, 10, 20, 20, 50, 30, 30, 40, 40,
                10, 10, 20, 20, 50, 30, 30, 40, 40,
                40, 40, 30, 30, 40, 10, 10, 50, 50,
                40, 40, 30, 30, 30, 10, 10, 50, 50,
                0, 0, 0, 0, 30, 0, 0, 0, 0,
                0, 0, 10, 20, 10, 20, 10, 0, 0,
            ],
            generateLats: [
                { index: 12, type: [0], cus: [] },
                { index: 13, type: [0], cus: [] },
                { index: 14, type: [0], cus: [] },
                { index: 27, type: [0], cus: [] },
                { index: 28, type: [0], cus: [] },
                { index: 29, type: [0], cus: [] },
                { index: 30, type: [0], cus: [] },
                { index: 32, type: [0], cus: [] },
                { index: 33, type: [0], cus: [] },
                { index: 34, type: [0], cus: [] },
                { index: 35, type: [0], cus: [] },
                { index: 74, type: [0], cus: [] },
                { index: 75, type: [0], cus: [] },
                { index: 77, type: [0], cus: [] },
                { index: 78, type: [0], cus: [] },
            ],
        },
    },
    //13
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: {
            type: PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType.ICE,
                    count: 27
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                2, 1, 2, 2, 2, 1, 2, 2, 2,
                2, 1, 1, 1, 2, 1, 1, 1, 2,
                2, 1, 2, 2, 2, 1, 2, 2, 2,
                2, 1, 2, 1, 1, 1, 1, 1, 2,
                2, 1, 2, 2, 2, 1, 2, 2, 2,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            elements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 2, 2, 2, 1, 1, 1, 1,
                1, 1, 1, 1, 2, 1, 1, 1, 1,
                1, 1, 2, 2, 2, 1, 1, 1, 1,
                1, 1, 2, 1, 1, 1, 1, 1, 1,
                1, 1, 2, 2, 2, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            generateLats: [
                { index: 9, type: [0], cus: [] },
                { index: 10, type: [0], cus: [] },
                { index: 11, type: [0], cus: [] },
                { index: 12, type: [0], cus: [] },
                { index: 13, type: [0], cus: [] },
                { index: 14, type: [0], cus: [] },
                { index: 15, type: [0], cus: [] },
                { index: 16, type: [0], cus: [] },
                { index: 17, type: [0], cus: [] },
            ],
        },
    },
    //14
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: {
            type: PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType.ROCK,
                    count: 39
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
            ],
            elements: [
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                2, 2, 2, 0, 0, 0, 2, 2, 2,
                2, 2, 2, 0, 0, 0, 2, 2, 2,
                2, 2, 2, 0, 0, 0, 2, 2, 2,
                2, 2, 2, 0, 0, 0, 2, 2, 2,
                2, 2, 2, 0, 0, 0, 2, 2, 2,
            ],
            baseElements: [
                0, 0, 0, 10, 20, 10, 0, 0, 0,
                0, 0, 0, 20, 10, 20, 0, 0, 0,
                0, 0, 0, 10, 20, 10, 0, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
            ],
            generateLats: [
                { index: 3, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 27, type: [0], cus: [] },
                { index: 28, type: [0], cus: [] },
                { index: 29, type: [0], cus: [] },
                { index: 35, type: [0], cus: [] },
                { index: 34, type: [0], cus: [] },
                { index: 33, type: [0], cus: [] },
            ],
        },
    },
    //15
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: {
            type: PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType.ICE,
                    count: 18
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 3, 3, 3, 1, 3, 3, 3, 0,
                0, 3, 3, 3, 1, 3, 3, 3, 0,
                0, 3, 3, 3, 1, 3, 3, 3, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            elements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 1, 1, 1, 2, 1, 1, 1, 0,
                0, 1, 1, 1, 2, 1, 1, 1, 0,
                0, 1, 1, 1, 2, 1, 1, 1, 0,
                0, 2, 2, 2, 2, 2, 2, 2, 0,
                0, 0, 0, 0, 2, 0, 0, 0, 0,
                0, 0, 0, 0, 2, 0, 0, 0, 0,
                0, 0, 0, 0, 2, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 10, 20, 10, 2, 20, 10, 20, 0,
                0, 20, 10, 20, 2, 10, 20, 10, 0,
                0, 10, 20, 10, 2, 20, 10, 20, 0,
                0, 2, 2, 2, 2, 2, 2, 2, 0,
                0, 0, 0, 0, 2, 0, 0, 0, 0,
                0, 0, 0, 0, 2, 0, 0, 0, 0,
                0, 0, 0, 0, 2, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            generateLats: [
                { index: 10, type: [0], cus: [] },
                { index: 11, type: [0], cus: [] },
                { index: 12, type: [0], cus: [] },
                { index: 13, type: [0], cus: [] },
                { index: 14, type: [0], cus: [] },
                { index: 15, type: [0], cus: [] },
                { index: 16, type: [0], cus: [] },
            ],
        },
    },
    //16
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 27,
        passTarget: {
            type: PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType.ICE,
                    count: 27
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 0, 2, 2, 2, 0, 0, 0,
                0, 0, 1, 2, 2, 2, 1, 0, 0,
                0, 1, 1, 2, 2, 2, 1, 1, 0,
                1, 1, 1, 2, 2, 2, 1, 1, 1,
                1, 1, 1, 2, 2, 2, 1, 1, 1,
                1, 1, 1, 2, 2, 2, 1, 1, 1,
                0, 1, 1, 2, 2, 2, 1, 1, 0,
                0, 0, 1, 2, 2, 2, 1, 0, 0,
                0, 0, 0, 2, 2, 2, 0, 0, 0,
            ],
            elements: [
                0, 0, 0, 2, 2, 2, 0, 0, 0,
                0, 0, 0, 2, 2, 2, 0, 0, 0,
                0, 0, 0, 2, 2, 2, 0, 0, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 0, 0, 2, 2, 2, 0, 0, 0,
                0, 0, 0, 0, 1, 0, 0, 0, 0,
                0, 0, 0, 1, 1, 1, 0, 0, 0,
            ],
            baseElements: [
                0, 0, 0, 2, 2, 2, 0, 0, 0,
                0, 0, 0, 2, 2, 2, 0, 0, 0,
                0, 0, 0, 2, 2, 2, 0, 0, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                0, 0, 0, 2, 2, 2, 0, 0, 0,
                0, 0, 0, 0, 12, 0, 0, 0, 0,
                0, 0, 0, 12, 20, 12, 0, 0, 0,
            ],
            generateLats: [
                { index: 3, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
            ],
        },
    },
    //17 引导棒棒糖，定制掉落待加
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 27,
        passTarget: {
            type: PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType.LOLLIPOP,
                    count: 4
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0,
            ],
            elements: [
                0, 1, 3, 1, 3, 1, 3, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 2, 2, 2, 3, 2, 2, 2, 0,
                0, 2, 2, 2, 1, 2, 2, 2, 0,
                0, 2, 2, 1, 1, 1, 2, 2, 0,
                0, 2, 2, 2, 1, 2, 2, 2, 0,
                0, 2, 2, 2, 1, 2, 2, 2, 0,
                0, 2, 2, 1, 1, 1, 2, 2, 0,
                0, 0, 2, 2, 1, 2, 2, 0, 0,
            ],
            baseElements: [
                0, 10, 3, 10, 3, 10, 3, 10, 0,
                0, 20, 30, 20, 30, 20, 30, 20, 0,
                0, 2, 2, 2, 3, 2, 2, 2, 0,
                0, 2, 2, 2, 20, 2, 2, 2, 0,
                0, 2, 2, 20, 30, 40, 2, 2, 0,
                0, 2, 2, 2, 20, 2, 2, 2, 0,
                0, 2, 2, 2, 30, 2, 2, 2, 0,
                0, 2, 2, 40, 20, 30, 2, 2, 0,
                0, 0, 2, 2, 30, 2, 2, 0, 0,
            ],
            generateLats: [
                { index: 3, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 1, type: [0], cus: [] },
                { index: 2, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
                { index: 7, type: [0], cus: [] },
            ],
            recycles: [74, 75, 76, 77, 78, 70, 64]
        },
    },
    //18
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: {
            type: PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType.LOLLIPOP,
                    count: 4
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 0, 0, 1, 0, 0, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
            ],
            elements: [
                0, 0, 1, 3, 1, 3, 1, 0, 0,
                0, 1, 1, 1, 1, 1, 1, 1, 0,
                1, 1, 2, 2, 1, 2, 2, 1, 1,
                1, 1, 2, 2, 1, 2, 2, 1, 1,
                1, 1, 0, 0, 1, 0, 0, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                2, 2, 1, 1, 1, 1, 1, 2, 2,
                0, 2, 1, 1, 1, 1, 1, 2, 0,
                0, 2, 1, 1, 1, 1, 1, 2, 0,
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            generateLats: [
                { index: 3, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 2, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
            ],
            recycles: [54, 62, 73, 74, 75, 76, 77, 78, 79],
            connectedLats: [[29, 47], [30, 48], [32, 50], [33, 51]]
        },
    },
    //19
    {
        baseElementTypes: [0, 1, 2, 4],
        bubbleProbability: 0,
        stepCount: 28,
        passTarget: {
            type: PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType.ICE,
                    count: 33
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 2, 2, 2, 2, 2, 2, 2, 1,
                1, 2, 1, 1, 1, 1, 1, 2, 1,
                1, 2, 1, 3, 3, 3, 1, 2, 1,
                1, 2, 1, 3, 3, 3, 1, 2, 1,
                1, 2, 1, 3, 3, 3, 1, 2, 1,
                1, 2, 1, 1, 1, 1, 1, 2, 1,
                1, 2, 2, 2, 2, 2, 2, 2, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
            ],
            elements: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 2, 2, 2, 2, 2, 1, 1,
                1, 1, 2, 0, 0, 0, 2, 1, 1,
                1, 1, 2, 0, 0, 0, 2, 1, 1,
                1, 1, 2, 0, 0, 0, 2, 1, 1,
                1, 1, 2, 2, 2, 2, 2, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
            ],
            generateLats: [
                { index: 0, type: [0], cus: [] },
                { index: 1, type: [0], cus: [] },
                { index: 2, type: [0], cus: [] },
                { index: 3, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
                { index: 7, type: [0], cus: [] },
                { index: 8, type: [0], cus: [] },
            ],
        },
    },
    //20
    {
        baseElementTypes: [0, 1, 2, 4],
        bubbleProbability: 0,
        stepCount: 32,
        passTarget: {
            type: PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType.LOLLIPOP,
                    count: 4
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 1, 0, 1, 0, 1, 0, 0, 0,
                1, 0, 1, 0, 1, 0, 1, 0, 0,
                0, 1, 0, 1, 0, 1, 0, 0, 0,
                1, 0, 1, 0, 1, 0, 1, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 0, 0,
                1, 1, 1, 1, 1, 1, 1, 0, 1,
                1, 1, 1, 1, 1, 1, 1, 0, 1,
            ],
            elements: [
                0, 3, 0, 3, 0, 3, 0, 0, 0,
                2, 0, 2, 0, 2, 0, 2, 0, 0,
                0, 2, 0, 2, 0, 2, 0, 0, 0,
                2, 0, 2, 0, 2, 0, 2, 0, 0,
                2, 2, 2, 2, 2, 2, 2, 0, 0,
                2, 2, 2, 2, 2, 2, 2, 0, 0,
                2, 2, 2, 2, 2, 2, 2, 0, 0,
                2, 1, 2, 1, 2, 1, 2, 0, 1,
                1, 2, 1, 2, 1, 2, 1, 0, 1,
            ],
            baseElements: [
                0, 3, 0, 3, 0, 3, 0, 0, 0,
                2, 0, 2, 0, 2, 0, 2, 0, 0,
                0, 2, 0, 2, 0, 2, 0, 0, 0,
                2, 0, 2, 0, 2, 0, 2, 0, 0,
                2, 2, 2, 2, 2, 2, 2, 0, 0,
                2, 2, 2, 2, 2, 2, 2, 0, 0,
                2, 2, 2, 2, 2, 2, 2, 0, 0,
                2, 22, 2, 22, 2, 22, 2, 0, 13,
                22, 2, 22, 2, 22, 2, 22, 0, 11,
            ],
            generateLats: [
                { index: 1, type: [0], cus: [] },
                { index: 3, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 71, type: [0], cus: [] },
                { index: 37, type: [0], cus: [] },
                { index: 39, type: [0], cus: [] },
                { index: 41, type: [0], cus: [] },
            ],
            recycles: [72, 73, 74, 77, 75, 76, 78]
        },
    },
]