import { Ani } from "../class/Ani";
import { ImageAni } from "../class/ImageAni";
import { ElementType } from "../enum/ElementType";

//原点已是中心
export class RockAni extends Ani {
    /**
     * 图片
     */
    showImage: ImageAni;
    constructor() {
        super();
        this.aniName = "RockAni";
        this.showImage = new ImageAni(["ele" + ElementType.ROCK + "_png", "rock2_png", "rock3_png", "rock4_png", "rock5_png", "rock6_png"]);
        this.addChild(this.showImage)
    }

    play() {
        //重置图片
        this.showImage.currentFrame = 0;
        this.showImage.source = this.showImage.sourceAll[0];
        this.showImage.play(() => {
            this.recover();
        })
    }
} 