import wait from "../../libs/new_tc/wait";
import Panel from "../../libs/new_wx/components/Panel";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { getlogItem } from "../Main";
import { addRankFriendList } from "../mapScene/RankFriendList";
import setGray from "../setGray";
import { changeMapScene } from "../startScene/StartScene";

export default class Prize2Panel extends Panel {
    _level;
    start(data) {
        super.start();

        setGray(this['pica']);
        setGray(this['picb']);
        setGray(this['picc']);

        this._level = parseInt(data.level + '');

        const submitdata = DataManager.ins.getData('hc_submit').data;
        this['tips'].text = `x${submitdata.prizeResponse.changeMoney}`;

        this['goBtn'].addEventListener(egret.TouchEvent.TOUCH_TAP, () => {
            this.hidePanel();
            if (this._level + 1 <= window['total_level'])
                changeMapScene({ level: this._level + 1 });
            else
                changeMapScene();
        }, this);

        this.showlog();
        NetManager.ins.hc_home(() => { }, window['collectRuleId']);

        const hc_submitData = DataManager.ins.getData('hc_submit').data;
        this.setStar(hc_submitData.stars);

        addRankFriendList(84,809,this);
    }

    showlog() {
        NetManager.ins.showLog(getlogItem(15));
    }
    async setStar(nums: number) {
        this['pic1'].visible = this['pic2'].visible = this['pic3'].visible = false;
        this['light'].visible = false;
        await wait(500);
        if (nums == 1) {
            this['pic1'].visible = true;
            await this.playAni1();
        }
        if (nums == 2) {
            this['pic1'].visible = true;
            await this.playAni1();
            this['pic2'].visible = true;
            await this.playAni2();
        }
        if (nums == 3) {
            this['pic1'].visible = true;
            await this.playAni1();
            this['pic2'].visible = true;
            await this.playAni2();
            this['pic3'].visible = true;
            await this.playAni3();
        }
        if (nums >= 1) {
            this['light'].visible = true;
            egret.Tween.get(this['light']).set({ scaleX: 0, scaleY: 0, alpha: 0, }).to({ scaleX: 1, scaleY: 1, alpha: 1 }, 300).call(() => {
                egret.Tween.get(this['light'], { loop: true }).to({ rotation: 360 }, 3000);
            });
        }
    }

    async playAni1() {
        return new Promise(r => {
            egret.Tween.get(this['pic1']).set({ scaleX: 0, scaleY: 0 }).to({ scaleX: 1, scaleY: 1 }, 400, egret.Ease.getBackOut(1)).call(r)
        })
    }
    async playAni2() {
        return new Promise(r => {
            egret.Tween.get(this['pic2']).set({ scaleX: 0, scaleY: 0 }).to({ scaleX: 1, scaleY: 1 }, 400, egret.Ease.getBackOut(1)).call(r)
        })
    }
    async playAni3() {
        return new Promise(r => {
            egret.Tween.get(this['pic3']).set({ scaleX: 0, scaleY: 0 }).to({ scaleX: -1, scaleY: 1 }, 400, egret.Ease.getBackOut(1)).call(r)
        })
    }
    destroy() {
        super.destroy();
        egret.Tween.removeTweens(this['light']);
    }
    onTouchTap_closeBtn(): any {
        super.onTouchTap_closeBtn();
        changeMapScene();
    }

    get picBigWidth() { return 510 };
    get bigPicRatio() { return 640 / 300 }

    useBtn: eui.Button;
    get skinKey() { return 'Prize2' }

    protected get closeBtns(): eui.Button[] { return [this['closeBtn']] }
}