import Panel from "../../libs/new_wx/components/Panel";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { iswx } from "../iswx";
import { getNick } from "../mapScene/MapScene";
import FriendItemRenderer from "./FriendItemRenderer";
import { getlogItem } from "../Main";
import { showToast } from "../../libs/new_wx/ctrls/toastCtrl";
import getHomeData from "../getHomeData";
import { getUrl } from "../myVideo/getDefaultConfig";

export default class FriendPanel extends Panel {
    public list: eui.List;
    progress: eui.Label;
    score: eui.Label;
    start(data) {
        super.start();
        this.showlog();
        this['avatar'].mask = this['avatarMask'];
        this['avatar0'].mask = this['avatarMask0'];
        this.list.useVirtualLayout = false;
        this.list.itemRenderer = FriendItemRenderer;


        this.list.visible = false;
        this['empty'].visible = false;
        this['avatar'].visible = false;
        this['avatar0'].visible = false;
        this['nameTxt'].text = '';
        this['nameTxt0'].text = '';
        NetManager.ins.getRankInfo((s) => {
            if (!s) {
                showToast("排行榜信息获取失败")
                return
            }
            let { data: hc_totalNumRank } = DataManager.ins.getData('getRankInfo');
            if (hc_totalNumRank == null) {
                hc_totalNumRank = {}
            }
            const { rankList, currentUserRank } = hc_totalNumRank;
            //自己的昵称和头像
            this['avatar'].visible = true;
            this['avatar0'].visible = true;
            if (currentUserRank) {
                this['avatar'].source = this['avatar0'].source = currentUserRank.avatar || "http://yun.duiba.com.cn/db_games/default_avatar.png";
                if (currentUserRank.nickName) {
                    this['nameTxt'].text = this['nameTxt0'].text = getNick(currentUserRank.nickName, 10);
                } else {
                    //取cookie里的
                    var nickName = getUrl("nickname");
                    if (nickName) this['nameTxt'].text = this['nameTxt0'].text = getNick(nickName, 10);
                }
            } else {
                //取cookie里的
                var avatar = getUrl("avatar");
                this['avatar'].source = this['avatar0'].source = avatar ? decodeURIComponent(avatar) : "http://yun.duiba.com.cn/db_games/default_avatar.png";
                var nickName = getUrl("nickname");
                if (nickName) this['nameTxt'].text = this['nameTxt0'].text = getNick(nickName, 10);
            }
            if (currentUserRank && currentUserRank.rank) {
                this.progress.textFlow = (new egret.HtmlTextParser).parser(
                    `第<font color=0xfff000><b>${currentUserRank.levelNum}</b></font>关`);
                this.score.textFlow = (new egret.HtmlTextParser).parser(
                    `<font color=0xfff000><b>${currentUserRank.maxScore}</b></font>分`);
                this['rankTxt'].text = currentUserRank.rank
                this['star'].text = `X${currentUserRank.stars}`
            }
            //没有，用home数据覆盖，去最后一个
            else if (getHomeData().levels.length) {
                var levels = getHomeData().levels;
                var lastData = levels[levels.length - 1];

                this.progress.textFlow = (new egret.HtmlTextParser).parser(
                    `第<font color=0xfff000><b>${lastData.levelNum}</b></font>关`);
                this.score.textFlow = (new egret.HtmlTextParser).parser(
                    `<font color=0xfff000><b>${lastData.maxScore}</b></font>分`);
                this['rankTxt'].text = "未上榜";
                this['rankTxt'].size = 25;
                this['star'].text = `X${lastData.stars}`
            }
            //如果关数为0就0
            else {
                this.progress.textFlow = (new egret.HtmlTextParser).parser(
                    `第<font color=0xfff000><b>${0}</b></font>关`);
                this.score.textFlow = (new egret.HtmlTextParser).parser(
                    `<font color=0xfff000><b>${0}</b></font>分`);
                this['rankTxt'].text = "未上榜";
                this['rankTxt'].size = 25;
                this['star'].text = `X${0}`
            }

            if (rankList && rankList.length > 0) {
                this.list.visible = true;
                this['empty'].visible = false;
                const ac = new eui.ArrayCollection(rankList);
                this.list.dataProvider = ac;
            } else {
                this.list.visible = false;
                this['empty'].visible = true;
            }
        })
    }

    showlog() {
        // NetManager.ins.showLog(getlogItem(3));
        // NetManager.ins.showLog(getlogItem(4));
        NetManager.ins.showLog(getlogItem(28));
    }


    initEvents() {
        super.initEvents();
    }

    protected get closeBtns(): eui.Button[] { return [this['closeBtn']] }
    get skinKey() { return 'Friend' }
}