import getResPath from "../../libs/new_tc/getResPath";
import wait from "../../libs/new_tc/wait";
import Loading from "../../libs/new_wx/components/Loading";
import Scene from "../../libs/new_wx/components/Scene";
import PanelCtrl from "../../libs/new_wx/ctrls/panelCtrl";
import { showToast } from "../../libs/new_wx/ctrls/toastCtrl";
import { ModuleTypes } from "../../libs/new_wx/types/sceneTypes";
import { GDispatcher } from "../../libs/tc/util/GDispatcher";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetManager } from "../../libs/tw/manager/NetManager";
import getHomeData, { BLOOD_NUMS_MAX } from "../getHomeData";
import { loadSvga } from "../loadSvga";
import { getlogItem } from "../Main";
import setGlow from "../setGlow";
import setGray from "../setGray";
import { getBgOn, getSoundOn, playBg, toggleBg, toggleSound } from "../soundCtrl";
import { stopGamebg } from "../soundCtrl2";
import Utils from "../Utils";
import AvatarComp from "./AvatarComp";
import CountDown from "./CountDown";
import { GuideCon, readCache } from "./GuideCon";

import MapBottomPart from "./MapBottomPart";
import MapRpeatPart from "./MapRpeatPart";
import MapTopPart from "./MapTopPart";
import RedBagAni, { createRedBagIcon } from "./RedBagAni";
import { createEffect2MovieClip } from "../effect/createEffect2";
import { NetName } from "../../libs/tw/enum/NetName";
import { handleVideo } from "../myVideo/videoCtrl";
import { getUrl } from "../myVideo/getDefaultConfig";

let doHelpFlag = false;
// let doScratchHelpFlag = false;
// let adTag = false;
export default class MapScene extends Scene {
    static adData;
    scrollGroup: eui.Group;
    scroll: eui.Scroller;
    topPart: MapTopPart;
    bottomPart: MapBottomPart;
    repeatsPart: MapRpeatPart[];
    static iconHash: any = {};
    static starHash: any = {};
    _data;

    // 邀请有礼角标倒计时
    private inviteTimer: egret.Timer;
    private cutTime: number;

    async start(data?) {
        super.start();


        //新增icon，还有埋点
        this["wuhanGroup"].visible = false;
        this["tuiaGroup"].visible = false;
        NetManager.ins.getIconInfo((s, res) => {
            //成功才显示，且有剩余次数remainAwardTimes
            if (s && res.data && res.data.remainAwardTimes) {
                //领奖类型：0：武汉 1：推啊
                //武汉
                if (res.data.type == 0) {
                    this["wuhanGroup"].visible = true;
                    NetManager.ins.showLog(getlogItem(14))
                    this["wuhanGroup"].addEventListener(egret.TouchEvent.TOUCH_TAP, () => {
                        NetManager.ins.clickLog(getlogItem(14))
                        handleVideo(
                            (s) => {
                                if (s) {
                                    Loading.instace.show();
                                    NetManager.ins.getIconAward((succ, ress) => {
                                        Loading.instace.hide();
                                        if (succ) {
                                            PanelCtrl.instance.show("DailyIconPrizePanel");
                                            //如果次数没了就隐藏icon
                                            if (!ress.data.remainAwardTimes) {
                                                this["wuhanGroup"].visible = false;
                                            }
                                        } else {
                                            showToast("领取失败");
                                        }
                                    })
                                } else {
                                    showToast("广告未成功观看，无法领取奖励");
                                }
                            },
                            () => { NetManager.ins.getIconAward(() => { }) },
                            window["slotidIcon"]
                        )
                    }, this)
                }
                //推啊
                else if (res.data.type == 1) {
                    this["tuiaGroup"].visible = true;
                    NetManager.ins.showLog(getlogItem(13))
                    this["tuiaGroup"].addEventListener(egret.TouchEvent.TOUCH_TAP, () => {
                        NetManager.ins.clickLog(getlogItem(13))
                        this['tuiaRewardMark'] = false;
                        NetManager.ins.getTuiaAd(
                            () => {
                                Loading.instace.show();
                                NetManager.ins.getIconAward((succ, ress) => {
                                    Loading.instace.hide();
                                    if (succ) {
                                        PanelCtrl.instance.show("DailyIconPrizePanel");
                                        //如果次数没了就隐藏icon
                                        if (!ress.data.remainAwardTimes) {
                                            this["tuiaGroup"].visible = false;
                                        }
                                    } else {
                                        showToast("领取失败");
                                    }
                                })
                                this['tuiaRewardMark'] = true;
                                //关闭弹框
                                // window['TAIsdk'].iframeNode.remove()
                                // setTimeout(function () {
                                //     window['TAIsdk'].iframeNode.src = ''
                                // })
                                // window['TAIsdk'].closeBtn.style.display = 'none'
                            },
                            () => {
                                //上面没回调过。就显示toast
                                if (!this['tuiaRewardMark']) showToast("活动未完成，无法领取奖励");
                            }
                        )
                    }, this)
                }
            }
        })

        // PanelCtrl.instance.show('RedBombAlert');
        // NetManager.ins.hc_submit(()=>{
        //     // const submitData = DataManager.ins.getData('hc_submit').data;
        //     // PanelCtrl.instance.show(ModuleTypes.PRIZE_PANEL,{ level:1, option: submitData.option })
        // },1,1,'','')

        //隐藏一些icon 为了下面那些去掉
        var icons = ["adBtn"]
        for (var i = 0; i < icons.length; i++) {
            this[icons[i]].visible = false;
        }

        this.updateMyInfo();

        //广告去掉
        // this.updateAdData();

        GDispatcher.dispatchEvent("getInviteInfo"); // 查询邀请信息，控制邀请有礼角标
        this['avatar'].mask = this['avatarMask'];

        if (getBgOn() && MapScene['firstPlayBgTag'] == true) {
            playBg();
        }

        stopGamebg();

        NetManager.ins.getSignInfo(() => {
            const panels = [];
            const date = new Date();
            date.setHours(0, 0, 0, 0);
            const nowTimerStr = date.getTime() + '';
            const oldTimerStr = localStorage.getItem('nowTimerStr' + window['CFG'].consumerId);

            const nowTimerStr2 = date.getTime() + '';
            const oldTimerStr2 = localStorage.getItem('nowTimer2Str' + window['CFG'].consumerId);

            //广告相关，去掉
            /*const hc_advert = DataManager.ins.getData('hc_advert').data || {};
            let {noticeAdvert} = hc_advert;
            if(noticeAdvert == null) {
                noticeAdvert = {enable: false}
            }

            if(noticeAdvert && noticeAdvert.enable && nowTimerStr2 != oldTimerStr2) {
                // if (!adTag) {
                panels.push('ad');
                // adTag = true;
                // }
                localStorage.setItem('nowTimer2Str' + window['CFG'].consumerId, nowTimerStr2);
            }
*/

            const { signInfoVO } = DataManager.ins.getData('getSignInfo');
            if (signInfoVO.continueDay < 7) { //表示明天还可以签到
                if (signInfoVO.todaySigned == 0 && oldTimerStr != nowTimerStr) {
                    panels.push('sign');
                    localStorage.setItem('nowTimerStr' + window['CFG'].consumerId, nowTimerStr);
                }
            }
            this.updateSign();

            if (!readCache() && getHomeData().levels.length <= 0) { //引导
                const guide = new GuideCon(() => {
                    PanelCtrl.instance.showPanels(panels, [], this.onAllPanelHide);
                });
                this.addChild(guide);
                guide.play(1)
                // console.log(guide)
            } else { //不用引导
                PanelCtrl.instance.showPanels(panels, [], this.onAllPanelHide);
            }
        }, window['signActivityId']);

        this.initSound();

        this._data = data;
        //滚动的背景变黑
        this['rectbg'].height = this.stage.stageHeight;
        //进度条的遮罩
        this['progressfront'].mask = this['rect'];
        this['rect'].scaleX = 0.5
        //进度条文本发光
        // setGlow(this['totalStarTxt'], 0x0083e8, 1);

        this.topPart = data.top;
        this.repeatsPart = data.list;
        this.bottomPart = data.bottom;

        this.scroll.height = this.stage.stageHeight;
        this.scrollGroup.addChild(data.top);

        data.list.forEach((ele, index) => {
            this.scrollGroup.addChild(ele);
            ele.y = data.top.height + (index * ele.height);
        });

        this.scrollGroup.addChild(data.bottom);
        data.bottom.y = data.top.height + (data.list.length * data.list[0].height);

        let target;
        const homeData = getHomeData();
        if (homeData.levels.length == 0) {
            target = 1;
        } else if (homeData.levels.length == window['total_level']) {
            target = window['total_level'] + 1;
        } else {
            target = homeData.levels.length + 1;
        }
        for (const key in MapScene.iconHash) {
            const levelOrder = parseInt(key);
            const element = MapScene.iconHash[key];
            if (!element.hasEventListener(egret.TouchEvent.TOUCH_TAP)) {
                element.addEventListener(egret.TouchEvent.TOUCH_TAP, () => {
                    if (
                        (levelOrder > (getHomeData().levels.length + 1) && levelOrder > 1)
                        || (levelOrder > window['last_level'])
                    ) {
                        // showToast('必须通关前面的关卡才能开启本关');
                        console.log('必须通关前面的关卡才能开启本关');
                    } else
                        PanelCtrl.instance.show('StartPanel', key);
                    // NetManager.ins.clickLog(getlogItem(19))//关卡按钮点击埋点，去掉
                }, this);
            }
        }

        if (homeData.levels.length < window['total_level']) {
            const targetIcon = MapScene.iconHash[target];
            const light = RES.getRes('lightani_png');

            const pic = new egret.Bitmap(light);//76 61
            pic.x = targetIcon.x + 50 - 2;
            pic.y = targetIcon.y + 37 + 10;
            targetIcon.mappart.addChildAt(pic, 1);
            // targetIcon.parent.addChildAt(pic, 0);
            pic.anchorOffsetX = 76;
            pic.anchorOffsetY = 61;
            // pic.x = 50 - 2;
            // pic.y = 37 + 10;
            egret.Tween.get(pic, { loop: true }).to({ scaleX: 2, scaleY: 2, alpha: 0 }, 1000).wait(1000);
            this['pic'] = pic;
        }


        this.updateHomeData();

        this.updateBox();

        if (data.level) {
            if (homeData.remainEnargy == 0)

                PanelCtrl.instance.show('bloodPanel')
            else
                PanelCtrl.instance.show('StartPanel', data.level)
        }

        this.stage.once(egret.TouchEvent.TOUCH_TAP, () => {
            if (!MapScene['firstPlayBgTag']) {
                if (getBgOn()) {
                    playBg();
                }
                MapScene['firstPlayBgTag'] = true;
            }
        }, this);

        let lastOrder = homeData.levels.length + 1;
        if (homeData.levels.length >= window['total_level'])
            lastOrder = window['total_level'];
        this.scroll.viewport.scrollV = this.getScrollV(lastOrder, this.stage.stageHeight);
        // console.warn(this.getScrollV(lastOrder, this.stage.stageHeight))

        try {
            const key = 'main2';
            Promise.all([
                RES.getResAsync(`${key}_json`),
                RES.getResAsync(`${key}_png`)]);
        } catch (error) {

        }

        this.scroll.addEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame, this);
    }

    onAllPanelHide = () => {
        /* 红包雨引导，去掉
        
        */
    }

    onEnterFrame() {
        const offset = 0;
        const y0 = this.scroll.viewport.scrollV + offset;
        const y1 = this.stage.stageHeight + this.scroll.viewport.scrollV - offset;
        // console.log(y0, y1);
        let count = 0;
        for (const key in MapScene.iconHash) {
            const icon = MapScene.iconHash[key];
            if (icon['visibleY'] >= y0 && icon['visibleY'] <= y1) {
                icon.show();
            } else if (icon.parent) {
                icon.hide();
            }

            if (icon.parent)
                count++;
        }

        if (this._avatarsCache) {
            this._avatarsCache.forEach((item) => {
                if (item.parent) item.parent.addChild(item);
            });
        }

    }

    updateMyInfo() {
        this['avatar'].visible = true;
        this['nameTxt'].text = '';

        var avatar = getUrl("avatar");
        this['avatar'].source = avatar ? decodeURIComponent(avatar) : "http://yun.duiba.com.cn/db_games/default_avatar.png";
        //注意dcustom里大小写
        var nickName = getUrl("nickname");
        if (nickName) this['nameTxt'].text = getNick(nickName);

    }

    updateSign() {
        const { signInfoVO } = DataManager.ins.getData('getSignInfo');
        if (signInfoVO.continueDay < 7) { //表示明天还可以签到
            this['sign_s1'].visible = signInfoVO.todaySigned == 0;
            this['sign_s2'].visible = !this['sign_s1'].visible;
        } else {
            this['sign_s2'].visible = true;
        }
    }

    updateAdData() {
        const hc_advert = DataManager.ins.getData('hc_advert').data || {};
        let { mapAdvert } = hc_advert;
        if (mapAdvert == null)
            mapAdvert = { enable: false, advertList: [] }
        this['adBtn'].visible = mapAdvert.enable;
        if (this['adBtn'].visible) {

        }
        if (mapAdvert.enable) {
            let result;
            result = mapAdvert.advertList;
            if (Array.isArray(mapAdvert.advertList)) {
                const index = Math.floor(mapAdvert.advertList.length * Math.random());
                result = mapAdvert.advertList[index];
            }
            this['adBtn'].source = result.img;
            this['adBtn'].addEventListener(egret.TouchEvent.TOUCH_TAP, () => {
                window.location.href = result.url;
            }, this);
        }
    }

    destroy() {
        super.destroy();

        if (this['pic'])
            egret.Tween.removeTweens(this['pic']);

        if (this.inviteTimer) {
            this.inviteTimer.stop();
            this.inviteTimer.removeEventListener(egret.TimerEvent.TIMER, this.inviteCutTimer, this);
        }

        this.scroll.removeEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame, this);

        this._avatarsCache.forEach((item) => {
            if (item.parent) item.parent.removeChild(item);
        });
        this._avatarsCache = null;
    }

    getScrollV(lastOrder, stageHeight) {
        // lastOrder = 69;
        if (lastOrder <= 7) {//顶部的1-7关
            return this.getScrollV1(lastOrder, stageHeight);
        }

        if (lastOrder >= window['total_level'] - 10) {//底部的60-70关  70-10
            return this.getScrollV2(lastOrder, stageHeight);
        }
        //中部的4个循环*13   8~59
        return this.getScrollV3(lastOrder, stageHeight);
    }

    getScrollV3(lastOrder, stageHeight) {
        const ylist = [26, 158, 302, 435, 547, 674, 821, 897, 969, 1072, 1137, 1254, 1367];
        const y0 = this._data.top.height;//顶部的高度
        let a0 = (lastOrder - MapTopPart.LEVEL_NUMS) % MapRpeatPart.LEVEL_NUMS;  //减去7后的order  8-7 = 1
        if (a0 == 0) a0 = MapRpeatPart.LEVEL_NUMS
        const a1 = Math.ceil((lastOrder - MapTopPart.LEVEL_NUMS) / MapRpeatPart.LEVEL_NUMS) - 1;//当前地图repeat的顺序
        const y1 = ylist[a0 - 1];
        const y2 = y0 + y1 + a1 * this._data.list[0].height;
        return y2 - stageHeight / 2;
    }

    getScrollV1(lastOrder, stageHeight) {
        const ylist = [492, 550.35, 744, 803, 810, 975, 1089.69].map(i => i + 40);
        const targetY = ylist[lastOrder - 1] - stageHeight / 2;
        if (targetY <= 0) return 0
        return targetY;
    }

    getScrollV2(lastOrder, stageHeight) {
        const y0 = this._data.bottom.y;
        lastOrder = lastOrder - this._data.list.length * MapRpeatPart.LEVEL_NUMS - 7;
        const totalHeight = this._data.top.height +
            (this._data.list.length * this._data.list[0].height)
            + this._data.bottom.height;
        const ylist = [44, 148.44, 331, 403, 513, 660, 829.69, 949.69, 1052.69, 1148.69, 1209.69].map(i => i + 40);
        const targetY = y0 + ylist[lastOrder - 1] - stageHeight / 2;
        if (targetY >= (totalHeight - stageHeight)) return totalHeight - stageHeight
        return targetY;
    }

    disableIcon(level) {
        this.setGray(level);
        MapScene.starHash[level].visible = false;
    }

    enableIcon(level) {
        this.resetGray(level);
        MapScene.starHash[level].visible = true;
    }

    updateBox() {
        const homeData = getHomeData();
        if (homeData.canReceiveTreasureBoxNum <= 0)
            setGray(this['box']);
        this['boxiconWrapper'].visible = homeData.canReceiveTreasureBoxNum > 0;
        this['totalStarTxt'].text = `${homeData.totalStars}/${homeData.nextRangeStarsNum}`;
        this['boxNumsTxt'].text = `${homeData.canReceiveTreasureBoxNum}`;
        this['treasureboxBtn'].visible = !homeData.isGetAllTreasureBox;
    }

    updateScene() {
        this.updateHomeData();
        this.updateSign();
    }

    private _avatarsCache = [];

    addAvatar(level, ele?) {
        const item = MapScene.iconHash[level];
        const parent = item['mappart'];
        const avatar = new AvatarComp();
        avatar.loadSkin();
        avatar.start(ele);
        parent.addChild(avatar);
        avatar.x = item.x + 10;
        avatar.y = item.y - avatar.height - 30;
        if (!MapScene.starHash[level].visible) {
            avatar.y = item.y - avatar.height;
        }
        this._avatarsCache.push(avatar);
    }

    updateHomeData() {
        const homeData = getHomeData();

        this['goldTxt'].text = `${homeData.wealth}`;

        for (let j = 1; j < window['total_level']; j++) {
            this.disableIcon(j + 1);
        }
        for (let i = 0; i < homeData.levels.length; i++) {
            const level = homeData.levels[i];
            const star = MapScene.starHash[i + 1];
            if (level) {
                star.setStar(level.stars);
                this.enableIcon(level.levelNum);
            } else {
                this.disableIcon(level.levelNum);
            }
        }
        if (homeData.levels.length == 0) {
            const star = MapScene.starHash[1];
            star.setStar(0);
            this.enableIcon(1);
        } else if (homeData.levels.length == window['last_level']) {

        } else {
            const star = MapScene.starHash[homeData.levels.length + 1];
            this.enableIcon(homeData.levels.length + 1);
        }

        this.updateTimerView();
    }

    private _countDown: CountDown;

    updateTimerView() {
        //更新倒计时
        if (this._countDown == null) {
            this._countDown = new CountDown(this['countdown']);
        }
        const data = getHomeData();
        if (data.remainEnargy >= BLOOD_NUMS_MAX) { //满了
            this._countDown.stop();

            this['fullTxt'].visible = true;
            this['countdown'].visible = false;
        } else {
            const left = data.refectionCountdown - Math.floor(new Date().getTime() / 1000);
            this._countDown.reset(left);
            this['countdown'].visible = true;
            this['fullTxt'].visible = false;
        }
        this['bloodTxt'].text = `${data.remainEnargy}`;
    }

    loadsvga(res) {
        if (MapScene['svga']) {
            const mv = MapScene['svga']
            mv.gotoAndStop(1);
            res.data.svga = mv;
            PanelCtrl.instance.show('invite', res.data);
            return;
        }
        Loading.instace.show();
        loadSvga(getResPath() + 'resource/assets/svgas/invite.svga').then(async (mv: any) => {
            console.log('svga', mv)
            MapScene['svga'] = mv;
            await wait(200);
            Loading.instace.hide();
            mv.gotoAndStop(1);
            res.data.svga = mv;
            PanelCtrl.instance.show('invite', res.data);
        })
    }

    //////////////////////////////////////// 邀请有礼角标 //////////////////////////////////////////////
    /**
     * 查询邀请信息
     */
    getInviteInfo() {
        const hc_advert = DataManager.ins.getData('hc_advert').data || {};
        const { mapAdvert } = hc_advert;
        // tslint:disable-next-line: cyclomatic-complexity
        NetManager.ins.getInviteInfo((success, res) => {
            if (!success || !res.data) {
                return;
            }
            const flag = res.data.completeFlag;
            if (this.inviteTimer) {
                this.inviteTimer.stop();
            }
            switch (true) {
                case (flag == 0):   // 	未完成 显示倒计时
                    this["inviteGroup"].visible = true;
                    this["inviteGroup"].touchEnabled = true;
                    if (!mapAdvert || mapAdvert.enable == false) {
                        this['activitys'].y = 458;
                        this['guideInner'].y = 185;
                    }
                    this["inviteTipsBg"].visible = true;
                    this["inviteTips"].visible = true;
                    this.cutTime = res.data.endTime - res.data.sysTime + 5000;
                    this.inviteTimer = new egret.Timer(1000, 0);
                    this.inviteTimer.addEventListener(egret.TimerEvent.TIMER, this.inviteCutTimer, this);
                    this.inviteTimer.start();
                    this.inviteCutTimer();
                    break;
                case (flag == 1):   // 完成未开奖 待领奖 显示待领奖
                    this["inviteGroup"].visible = true;
                    this["inviteGroup"].touchEnabled = true;
                    if (!mapAdvert || mapAdvert.enable == false) {
                        this['activitys'].y = 458;
                        this['guideInner'].y = 185;
                    }
                    this["inviteTipsBg"].visible = true;
                    this["inviteTips"].visible = true;
                    this["inviteTips"].text = "待领奖";
                    break;
                case (flag == 2):   // 领奖成功 无角标
                case (flag == 3):   // 领奖失败 无角标
                    this["inviteGroup"].visible = true;
                    this["inviteGroup"].touchEnabled = true;
                    if (!mapAdvert || mapAdvert.enable == false) {
                        this['activitys'].y = 458;
                        this['guideInner'].y = 185;
                    }
                    this["inviteTipsBg"].visible = false;
                    this["inviteTips"].visible = false;
                    break;
                case (flag == 4):   // 可以开启下一次发任务 显示立即到账
                    this["inviteGroup"].visible = true;
                    this["inviteGroup"].touchEnabled = true;
                    if (!mapAdvert || mapAdvert.enable == false) {
                        this['activitys'].y = 458;
                        this['guideInner'].y = 185;
                    }
                    this["inviteTipsBg"].visible = true;
                    this["inviteTips"].visible = true;
                    this["inviteTips"].text = "立即到账";
                    break;
                case (flag == 5):   // 等待开启下一次发任务 无角标
                    this["inviteGroup"].visible = true;
                    this["inviteGroup"].touchEnabled = true;
                    if (!mapAdvert || mapAdvert.enable == false) {
                        this['activitys'].y = 458;
                        this['guideInner'].y = 185;
                    }
                    this["inviteTipsBg"].visible = false;
                    this["inviteTips"].visible = false;
                    break;
                case (flag == 6):   // 无入口
                    this["inviteGroup"].visible = false;
                    this["inviteGroup"].touchEnabled = false;
                    this['adBtn'].y = 323.76;
                    if (mapAdvert && mapAdvert.enable) {
                        this['guideInner'].y = 185;
                        this['activitys'].y = 458;
                    } else {
                        this['guideInner'].y = 30;
                        this['activitys'].y = 303.76;
                    }
                    break;
                default:
                    break;
            }
        });
    }

    // 倒计时
    private inviteCutTimer() {
        const timer = this.convertTime(this.cutTime -= 1000);
        if (timer.hour === "00"
            && timer.min === "00"
            && timer.sec === "00") {
            this.inviteTimer.stop();
            GDispatcher.dispatchEvent("getInviteInfo");
        }
        this["inviteTips"].text = `${timer.hour}:${timer.min}:${timer.sec}`;
    }

    // 通过时间戳获取时间计数（时，分，秒）
    private convertTime(time: number) {
        const hour = ~~(time / 3600000);                              // 小时
        const min = ~~((time - hour * 3600000) / 60000);              // 分
        const sec = ~~((time - hour * 3600000 - min * 60000) / 1000); // 秒

        return {
            hour: Utils.prefixInteger(hour, 2),
            min: Utils.prefixInteger(min, 2),
            sec: Utils.prefixInteger(sec, 2)
        }
    }
    ////////////////////////////////////////////////////////////////////////////////////////////////////

    onTap_friendBtn() {
        PanelCtrl.instance.show('friend');
    }

    onTap_adBtn() {
        console.log('onTap_adBtn')
    }

    onTap_signBtn() {
        NetManager.ins.getSignInfo(() => {
            PanelCtrl.instance.show('sign');
        }, window['signActivityId'])
    }

    protected initEvents() {
        // this['goldBtn'].addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_goldBtn, this)


        this['friendBtn'].addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_friendBtn, this)
        this['adBtn'].addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_adBtn, this)
        this['signBtn'].addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_signBtn, this)
        this['bloodBtn'].addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_bloodBtn, this)
        this['settingBtn'].addEventListener(egret.TouchEvent.TOUCH_TAP, this.toggleSettings, this)
        this['shopBtn'].addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_shopBtn, this)
        this['questionBtn'].addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_questionBtn, this);
        this['box'].addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_boxLayer, this);
        this['boxani'].addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_box, this);
        this['soundBtn'].addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_sound, this);
        this['soundOffBtn'].addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_sound, this);
        this['musicOffBtn'].addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_music, this);
        this['musicBtn'].addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_music, this);
        this['recordBtn'].addEventListener(egret.TouchEvent.TOUCH_TAP, () => {
            PanelCtrl.instance.show('bag');
        }, this);

        // 消消乐查询信息
        // GDispatcher.addEvent('getInviteInfo', this.getInviteInfo, this);
    }

    initSound() {
        this['soundBtn'].visible = getSoundOn();
        this['soundOffBtn'].visible = !getSoundOn();
        this['musicBtn'].visible = getBgOn();
        this['musicOffBtn'].visible = !getBgOn();
    }

    onTap_sound() {
        this['soundBtn'].visible = !this['soundBtn'].visible;
        this['soundOffBtn'].visible = !this['soundOffBtn'].visible;
        toggleSound();
    }

    onTap_music() {
        this['musicBtn'].visible = !this['musicBtn'].visible;
        this['musicOffBtn'].visible = !this['musicOffBtn'].visible;
        toggleBg();
    }

    private _mc;

    async onTap_boxLayer() {
        const data = getHomeData();
        if (data.canReceiveTreasureBoxNum > 0) {
            this['boxLayer'].visible = true;
            if (!this._mc)
                this._mc = await loadSvga(getResPath() + 'resource/assets/svgas/box.svga', this['boxani']);
            this._mc.stop();
            this._mc.gotoAndStop(1);
            this._mc.anchorOffsetX = 750 / 2;
            this._mc.anchorOffsetY = 500 + 50 + 30;
            this._mc.x = 750 / 2;
            this._mc.y = 500 + 50 + 30;
            this._mc.visible = false;
            await wait(50);
            this._mc.visible = true;
            const a = 100, b = 10;
            egret.Tween.get(this._mc, { loop: true }).set({ rotation: b })
                .to({ rotation: -b }, a).to({ rotation: b }, a)
                .to({ rotation: -b }, a).to({ rotation: b }, a)
                .to({ rotation: -b }, a).to({ rotation: b }, a)
                .to({ rotation: 0 }, a / 2)
                .wait(1000);

        }
    }

    async playAni() {
        if (this._mc) {
            egret.Tween.removeTweens(this._mc);
            this._mc.gotoAndPlay(1, true);
            await this.onPlaySTOP();
        }
        this['boxLayer'].visible = false;
    }

    async onPlaySTOP() {
        return new Promise((r) => {
            const func = () => {
                if (this._mc.currentFrame >= 100) {
                    this._mc.removeEventListener(egret.Event.ENTER_FRAME, func, this);
                    this._mc.stop();
                    r();
                }
            }
            this._mc.addEventListener(egret.Event.ENTER_FRAME, func, this);
        });

    }

    async onTap_box() {
        console.log(1)
        // const data = getHomeData();
        // if (data.canReceiveTreasureBoxNum > 0) {
        this['boxani'].touchEnabled = false;
        this['boxani'].touchChildren = false;
        await this.playAni();
        try {
            if (window['getRST']) window['getRST']();
        } catch (error) {
            console.warn(error)
        }
        NetManager.ins.hc_openTreasureBox((success) => {
            this['boxani'].touchEnabled = true;
            this['boxani'].touchChildren = true;
            if (success) {
                const hc_openTreasureBox = DataManager.ins.getData('hc_openTreasureBox');
                const boxdata = hc_openTreasureBox.data;
                const homeData = DataManager.ins.getData('hc_home').data;
                homeData.canReceiveTreasureBoxNum = boxdata.canReceiveTreasureBoxNum;
                homeData.nextRangeStarsNum = boxdata.nextRangeStarsNum;
                homeData.totalStars = boxdata.totalStars;
                homeData.isGetAllTreasureBox = boxdata.isGetAllTreasureBox;
                this.updateBox();

                if (hc_openTreasureBox.success && boxdata && boxdata.option) {
                    PanelCtrl.instance.show('box');
                } else {

                    showToast('哎呀！奖励与您擦肩而过！快继续闯关！');
                }

                NetManager.ins.hc_home(() => {
                    this.updateScene();
                }, window['collectRuleId']);

            } else {
                PanelCtrl.instance.show('box2');
            }
        })
        // }
    }

    onTap_questionBtn() {
        PanelCtrl.instance.show(ModuleTypes.RULE_PANEL);
        this.toggleSettings();
    }

    onTap_shopBtn() {
        PanelCtrl.instance.show('Shop');
    }

    toggleSettings() {
        this['settingGroup'].visible = !this['settingGroup'].visible;
    }

    onTap_bloodBtn() {
        if (getHomeData().remainEnargy > 0)
            PanelCtrl.instance.show('bloodPanel')
        else
            PanelCtrl.instance.show('blood2Panel')
    }

    setGray(order: number) {
        const icon = MapScene.iconHash[order];
        (icon['nums'] as eui.Image).source = 'icongray_png';
        (icon['bmptxt'] as eui.BitmapLabel).font = 'nums3_fnt';
    }

    resetGray(order: number) {
        const icon = MapScene.iconHash[order];
        (icon['nums'] as eui.Image).source = 'icon_png';
        (icon['bmptxt'] as eui.BitmapLabel).font = 'nums_fnt';
    }

    get skinKey() {
        return 'Map'
    }

    showRedBagAni() {
        const hash = MapScene.iconHash;
        const keys = [];
        for (const key in hash) {
            const ele = hash[key];
            if (ele.parent)
                keys.push(key);
        }
        const p0 = new egret.Point(750 / 2, 750 / 1.5);
        const pics = [];
        for (const key of keys) {
            const icon = MapScene.iconHash[key] as egret.DisplayObject;
            const p = (icon.localToGlobal(0, 0));
            const pic = createRedBagIcon(this);
            pic.visible = false;
            pic['__p2__'] = p;
            pic['__icon__'] = icon;
            p.x += 50;
            p.y += 25;
            pics.push(pic);
        }
        // console.log(keys);
        pics.forEach((pic, index) => {
            wait(50 * index).then(() => {
                pic.visible = true;
                const p2 = pic['__p2__'] as egret.Point;
                let dir = 100;
                if (p2.y < p0.y)
                    dir *= -1;
                const p1x = (p0.x + p2.x) / 2 + dir;
                const p1y = (p0.y + p2.y) / 2;
                const p1 = new egret.Point(p1x, p1y);
                new RedBagAni(p0, p1, p2, pic, () => {
                    const mc = createEffect2MovieClip(p2.x, p2.y);
                    this.addChild(mc);
                    const x0 = pic['__icon__'].x;
                    const y0 = pic['__icon__'].y;
                    egret.Tween.get(pic['__icon__']).to({ y: y0 + 10 }, 100).to({ y: y0 }, 100);
                    const light = new egret.Bitmap(RES.getRes('maplight2_png'));
                    light.anchorOffsetX = 75;
                    light.anchorOffsetY = 49;
                    light.x = 50;
                    light.y = 40 + 5;
                    pic['__icon__'].addChildAt(light, 0);
                    egret.Tween.get(light).to({ scaleX: 1.5, scaleY: 1.5, }, 200).call(() => {
                        pic['__icon__'].removeChild(light);
                    });

                });
            });
        })
    }
}
export const getNick = (nickname, max = 4) => {
    if (!nickname) return nickname;

    if (nickname.length > max)
        return nickname.slice(0, max) + '...';
    return nickname;
}