

import layers from "../views/layers";
import Toast2 from "../components/Toast2";

let inited = false;
let _toast: Toast2;

const initToast = () => {
    if (!inited) {
        inited = true;
        const toast = new Toast2();
        toast.loadSkin();
        layers.toastLayer.addChild(toast);
        toast.alpha = 0;
        _toast = toast;
    }
    return _toast;
}
export const showToast2 = () => {
    const toast = initToast().start();
    egret.Tween.removeTweens(toast);
    toast.touchEnabled=true;
    toast.touchChildren=true;
    const tw = egret.Tween.get(toast);
    tw.set({ y: -200, alpha: 1 }).to({ y: 400 }, 500, egret.Ease.quartOut)
        .wait(3500)
        .to({ alpha: 0 }, 300).call(()=>{
            toast.touchEnabled=false;
            toast.touchChildren=false;
        })
}
