import { CurScoreNum } from "./CurScoreNum";

/**
 * 分数条的托管类，不需要继承
 */
export class ScoreProgress {
    hasOver: boolean
    starCount: number = 0;
    /**
     * 各星数的对应分数
     */
    starScores: number[];

    star1: eui.Image;
    star2: eui.Image;
    star3: eui.Image;

    starProgress: eui.Image;
    scoreTxt: CurScoreNum;
    allScore: number;
    private _score: number;
    get score() {
        return this._score
    }
    set score(value: number) {
        if (this._score == value) return
        this._score = value
        this.scoreTxt.num = Math.ceil(value);
        var diss = [
            188,
            446,
            522,
            595,
            663
        ]
        var w: number, scale: number;
        //先计算是否达到了3星
        if (value >= this.starScores[2]) {
            var aa = (value - this.starScores[2]) / (this.allScore - this.starScores[2]);
            scale = aa > 1 ? 1 : aa;
            if (scale >= 1) {
                if (!this.hasOver) {
                    this.hasOver = true;
                } else {
                    return
                }
            }
            w = (663 - 595) * scale + 595;
            if (this.star3.source != "lightedStar_png") {
                this.star3.source = "lightedStar_png";
                this.star2.source = "lightedStar_png";
                this.star1.source = "lightedStar_png";
                this.starCount = 3;
            };
        }
        //是否超过2星
        else if (value >= this.starScores[1]) {
            scale = (value - this.starScores[1]) / (this.starScores[2] - this.starScores[1]);
            w = (595 - 522) * scale + 522;
            if (this.star2.source != "lightedStar_png") {
                this.star2.source = "lightedStar_png";
                this.star1.source = "lightedStar_png";
                this.starCount = 2;
            };
        }
        //是否超过1星
        else if (value >= this.starScores[0]) {
            scale = (value - this.starScores[0]) / (this.starScores[1] - this.starScores[0]);
            w = (522 - 446) * scale + 446;
            if (this.star1.source != "lightedStar_png") {
                this.star1.source = "lightedStar_png";
                this.starCount = 1;
            };
        } else {
            scale = value / this.starScores[0];
            w = (446 - 188) * scale + 188;
        }
        //(466-428)/428,扩分数
        //星星
        //进度条遮罩
        var mask: any = this.starProgress.mask;
        mask.graphics.clear()
        mask.graphics.beginFill(0xff0000, 1);
        mask.graphics.drawRoundRect(0, 75, w, 48, 50)
        mask.graphics.endFill();


    }

    /**
     * 
     * @param starProgress 托管
     * @param scoreTxt 托管
     * @param starScores 
     */
    constructor(starProgress: eui.Image, scoreTxt: CurScoreNum, starScores: number[]) {
        this.starProgress = starProgress;
        this.scoreTxt = scoreTxt;
        this.starScores = starScores;
        this.allScore = 466 / 428 * this.starScores[2];
        //加遮罩，加到starProgress的父级中
        var p = starProgress.parent;
        var mask = new egret.Shape();
        mask.graphics.beginFill(0xff0000, 1);
        mask.graphics.drawRoundRect(0, 75, 188, 48, 50)
        mask.graphics.endFill();
        this.starProgress.mask = mask;
        p.addChild(mask);
        //星星1   lightedStar_png
        var textureStar = RES.getRes("unlightedStar_png")
        this.star1 = new eui.Image(textureStar)
        this.star1.x = 423;
        this.star1.y = 78;
        p.addChild(this.star1);
        this.star2 = new eui.Image(textureStar);
        this.star2.x = 498;
        this.star2.y = 78;
        p.addChild(this.star2);
        this.star3 = new eui.Image(textureStar);
        this.star3.x = 573;
        this.star3.y = 76;
        p.addChild(this.star3);
    }
}