

import { State } from "../class/State";
import { Pool } from "../Pool";
import { RecoverName } from "../enum/RecoverName";
import { ElementType } from "../enum/ElementType";

/**
 * 黑色毛球状态
 * 两次消除，需要修改图片，，，再说，还没写，切换眩晕状态，是否有动画，都再说
 */
export class HairballBlackState extends State {
    private showImage: egret.Bitmap;
    /**
     * 是否激活
     */
    _isAwake: boolean;
    get isAwake(): boolean {
        return this._isAwake;
    }
    set isAwake(value: boolean) {
        this._isAwake = value;
        //换图
    }
    constructor() {
        super();
        this.showImage = new egret.Bitmap();
        this.addChild(this.showImage);
        this.changeSource("ele" + ElementType.HAIRBALLBLACK + "_png")
        this._isAwake = true;
    }
    reset() {
        this._isAwake = true;
        //换图
        this.changeSource("ele" + ElementType.HAIRBALLBLACK + "_png")
    }
    recover() {
        if (this.parent) this.parent.removeChild(this);
        Pool.recover(RecoverName.HAIRBALLBLACK_STATE, this);
    }

    private changeSource(source: string) {
        var texture: egret.Texture = RES.getRes(source);
        this.showImage.texture = texture;
        this.showImage.x = -texture.textureWidth / 2;
        this.showImage.y = -texture.textureHeight / 2
    }
}