import { Pool } from "../Pool";

/**
 * 动效的基类，包含一些固定方法
 * play无参数，不需要回调，只播放一次
 * 有自动回收方法recover
 * 子类必须重写aniName，否则回收会出问题
 */
export class Ani extends egret.DisplayObjectContainer {
    /**
     * 动效名字,也是实例名称，子类继承重写
     * 和回收名字一致
     */
    aniName: string;
    constructor() {
        super();
    }
   
    /**
     * 从初始位置播放
     */
    play(){

    }

    /**
     * 播放完后的移除和回收
     */
    recover() {
        if(this.$parent){
            this.$parent.removeChild(this)
        };
        Pool.recover(this.aniName, this)
    }


}