import { ChapterData } from "../interface/ChapterData";
import { PassType } from "../enum/PassType";
import { ElementType } from "../enum/ElementType";

/**
 * 141到160关数据
 */
export const Chapters8: ChapterData[] = [
    //141
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0.6,
        stepCount: 22,
        passTarget: {
            type: 1,
            elements: [
                {
                    type: 9,
                    count: 31
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                2, 0, 2, 2, 1, 0, 3, 3, 3,
                2, 0, 0, 0, 0, 0, 3, 3, 3,
                0, 0, 0, 0, 0, 0, 3, 3, 3,
                0, 0, 1, 1, 1, 0, 3, 3, 3,
                0, 0, 1, 1, 1, 0, 3, 3, 3,
                0, 0, 1, 1, 1, 0, 3, 3, 3,
                0, 0, 1, 1, 1, 0, 3, 3, 3,
                0, 0, 1, 1, 1, 0, 3, 3, 3,
                0, 0, 1, 1, 1, 0, 3, 3, 3,
            ],
            elements: [
                1, 0, 2, 2, 2, 0, 2, 0, 2,
                1, 0, 0, 0, 0, 0, 2, 0, 2,
                0, 0, 0, 0, 0, 0, 2, 0, 2,
                0, 0, 2, 2, 2, 0, 2, 0, 2,
                0, 0, 2, 2, 2, 0, 0, 2, 0,
                0, 0, 2, 2, 2, 0, 2, 0, 2,
                0, 0, 2, 2, 2, 0, 2, 0, 2,
                0, 0, 2, 2, 2, 0, 2, 0, 2,
                0, 0, 2, 2, 2, 0, 2, 0, 2,
            ],
            baseElements: [
                11, 0, 2, 2, 2, 0, 2, 0, 2,
                23, 0, 0, 0, 0, 0, 2, 0, 2,
                0, 0, 0, 0, 0, 0, 2, 0, 2,
                0, 0, 2, 2, 2, 0, 2, 0, 2,
                0, 0, 2, 2, 2, 0, 0, 2, 0,
                0, 0, 2, 2, 2, 0, 2, 0, 2,
                0, 0, 2, 2, 2, 0, 2, 0, 2,
                0, 0, 2, 2, 2, 0, 2, 0, 2,
                0, 0, 2, 2, 2, 0, 2, 0, 2,
            ],
            generateLats: [
                { index: 0, type: [0], cus: [] },
                { index: 2, type: [0], cus: [33] },
                { index: 3, type: [0], cus: [21] },
                { index: 4, type: [0], cus: [] },
            ],
            connectedLats: [[2, 29], [3, 30], [4, 31], [74, 6], [75, 7], [76, 8]]
        },
    },
    //142
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0.1,
        stepCount: 27,
        passTarget: { type: 1, elements: [{ type: 6, count: 2 }] },
        starScores: [5000, 12000, 21000],
        map: {
            lattices: [
                0, 0, 0, 0, 1, 0, 0, 0, 0,
                1, 1, 1, 0, 1, 0, 1, 1, 1,
                1, 1, 1, 0, 1, 0, 1, 1, 1,
                1, 1, 1, 0, 1, 0, 1, 1, 1,
                1, 1, 1, 0, 1, 0, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 0, 1, 0, 1, 1, 1
            ],
            connectedLats: [[72, 15], [73, 16], [74, 17]],
            elements: [
                1, 1, 1, 1, 3, 1, 1, 1, 1,
                1, 1, 1, 1, 2, 1, 1, 1, 1,
                1, 1, 1, 1, 2, 1, 1, 1, 1,
                1, 1, 1, 1, 2, 1, 1, 1, 1,
                1, 1, 1, 1, 2, 1, 1, 1, 1,
                1, 1, 1, 2, 5, 2, 1, 1, 1,
                1, 1, 2, 2, 5, 2, 2, 1, 1,
                1, 2, 2, 2, 5, 2, 2, 2, 1,
                2, 2, 2, 1, 5, 1, 2, 2, 2
            ],
            recycles: [76, 72, 73, 74, 78, 79, 80],
            generateLats: [{ index: 4, type: null }, { index: 9, type: null }, { index: 10, type: null }, { index: 11, type: null }, { index: 15, type: null }, { index: 16, type: null }, { index: 17, type: null }, { index: 48, type: null }, { index: 50, type: null }]
        }
    },
    //143
    {
        baseElementTypes: [0, 2, 3, 4, 1],
        bubbleProbability: 0.1,
        stepCount: 25,
        passTarget: { type: 1, elements: [{ type: 5, count: 24 }, { type: 1, count: 90 }] },
        starScores: [5000, 12000, 21000],
        map: {
            lattices: [
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1
            ],
            connectedLats: [[72, 5], [73, 6], [74, 7], [75, 8]],
            elements: [
                2, 2, 2, 2, 1, 4, 1, 4, 1,
                2, 2, 2, 2, 6, 1, 4, 1, 4,
                2, 2, 2, 2, 1, 4, 1, 4, 1,
                2, 2, 2, 2, 6, 1, 4, 1, 4,
                2, 2, 2, 2, 1, 4, 1, 4, 1,
                1, 1, 1, 1, 6, 2, 2, 2, 2,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 6, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1
            ],
            baseElements: [
                0, 0, 0, 0, 0, 20, 0, 20, 0,
                0, 0, 0, 0, 0, 0, 20, 0, 20, 0, 0, 0, 0, 0, 20, 0, 20, 0, 0, 0, 0, 0, 0, 0, 20, 0, 20, 0, 0, 0, 0, 0, 20, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 52, 33, 41, 52, 0, 0, 0, 0, 0],
            recycles: [],
            generateLats: [
                { index: 0, type: null },
                { index: 1, type: null },
                { index: 2, type: null },
                { index: 3, type: null },
                { index: 5, type: null },
                { index: 6, type: null },
                { index: 7, type: null },
                { index: 8, type: null },
                { index: 13, type: null },
                { index: 45, type: null },
                { index: 46, type: null },
                { index: 47, type: null },
                { index: 48, type: null },
                { index: 59, type: null },
                { index: 60, type: null },
                { index: 61, type: null },
                { index: 62, type: null },
            ]
        }
    },
    //144
    {
        baseElementTypes: [1, 2, 0, 4],
        bubbleProbability: 0.6,
        stepCount: 24,
        passTarget: { type: 1, elements: [{ type: 5, count: 16 }] }, starScores: [6000, 12000, 20000],
        map: {
            lattices:
                [
                    0, 0, 0, 0, 0, 1, 1, 1, 1,
                    0, 0, 0, 0, 0, 1, 1, 1, 1,
                    0, 0, 0, 0, 0, 1, 1, 1, 1,
                    0, 0, 0, 0, 0, 1, 1, 1, 1,
                    1, 1, 1, 1, 0, 1, 1, 1, 1,
                    0, 0, 0, 0, 0, 1, 1, 1, 1,
                    1, 1, 1, 1, 0, 1, 1, 1, 1,
                    1, 1, 1, 1, 0, 1, 1, 1, 1,
                    1, 1, 1, 1, 0, 1, 1, 1, 1
                ],
            connectedLats: [],
            elements: [
                0, 0, 0, 0, 0, 2, 2, 2, 2,
                0, 0, 0, 0, 0, 2, 2, 2, 2,
                0, 0, 0, 0, 0, 2, 2, 2, 2,
                0, 0, 0, 0, 0, 2, 2, 2, 2,
                1, 1, 1, 1, 0, 4, 4, 4, 4,
                0, 0, 0, 0, 0, 5, 5, 5, 5,
                1, 1, 1, 1, 0, 0, 0, 0, 0,
                1, 1, 1, 1, 0, 0, 0, 0, 0,
                1, 1, 1, 1, 0, 0, 0, 0, 0
            ],
            baseElements: [
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                12, 31, 12, 31, 0, 12, 30, 30, 12,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                30, 10, 30, 10, 0, 0, 0, 0, 0,
                10, 30, 10, 30, 0, 0, 0, 0, 0,
                30, 10, 30, 10, 0, 0, 0, 0, 0
            ],
            recycles: [],
            generateLats: [
                { index: 5, type: 0 },
                { index: 6, type: 0 },
                { index: 7, type: 0 },
                { index: 8, type: 0 },
                { index: 14, type: 0 },
                { index: 15, type: 0 },
                { index: 16, type: 0 },
                { index: 17, type: 0 },
                { index: 23, type: 0 },
                { index: 24, type: 0 },
                { index: 25, type: 0 },
                { index: 26, type: 0 },
                { index: 32, type: 0 },
                { index: 33, type: 0 },
                { index: 34, type: 0 },
                { index: 35, type: 0 },
                { index: 41, type: 0 },
                { index: 42, type: 0 },
                { index: 43, type: 0 },
                { index: 44, type: 0 },
                { index: 36, type: 0 },
                { index: 37, type: 0 },
                { index: 38, type: 0 },
                { index: 39, type: 0 },
                { index: 54, type: 0 },
                { index: 55, type: 0 },
                { index: 56, type: 0 },
                { index: 57, type: 0 }
            ]
        }
    },
    //145
    {
        baseElementTypes: [1, 0, 2, 3, 4],
        bubbleProbability: 0.2,
        stepCount: 28,
        passTarget: { type: 1, elements: [{ type: 9, count: 32 }] },
        starScores: [5000, 12000, 21000],
        map: {
            lattices: [0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 2, 2, 2, 2, 2, 1, 1, 1, 2, 0, 2, 2, 2, 0, 2, 1, 1, 2, 0, 2, 2, 2, 0, 2, 1, 1, 2, 0, 2, 2, 2, 0, 2, 1, 1, 2, 0, 2, 2, 2, 0, 2, 1, 1, 2, 0, 0, 0, 0, 0, 2, 1, 1, 1, 2, 2, 2, 2, 2, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0], connectedLats: [[63, 3], [48, 66], [50, 68], [49, 67], [71, 5]], elements: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 7, 7, 7, 7, 7, 1, 1, 1, 7, 1, 4, 4, 4, 1, 7, 1, 1, 7, 1, 7, 7, 7, 1, 7, 1, 1, 7, 1, 7, 7, 7, 1, 7, 1, 1, 7, 1, 7, 7, 7, 1, 7, 1, 1, 7, 1, 1, 1, 1, 1, 7, 1, 1, 1, 7, 7, 7, 7, 7, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 1, type: null }, { index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 7, type: null }, { index: 9, type: null }, { index: 17, type: null }]
        }
    },
    //146
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0.1,
        stepCount: 25,
        passTarget: { type: 1, elements: [{ type: 5, count: 32 }] },
        starScores: [5000, 12000, 21000],
        map: {
            lattices: [
                1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0], connectedLats: [], elements: [8, 1, 1, 1, 1, 1, 1, 1, 8, 1, 8, 1, 1, 1, 1, 1, 8, 1, 1, 1, 8, 2, 2, 2, 8, 1, 1, 2, 2, 2, 8, 2, 8, 2, 2, 2, 2, 2, 2, 2, 8, 2, 2, 2, 2, 1, 4, 4, 2, 2, 2, 4, 4, 1, 1, 4, 4, 4, 2, 4, 4, 4, 1, 2, 2, 4, 4, 4, 4, 4, 2, 2, 1, 2, 2, 2, 2, 2, 2, 1, 1], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 31, 0, 0, 0, 31, 0, 0, 0, 0, 0, 31, 0, 31, 0, 0, 0, 0, 0, 0, 0, 31, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [],
            generateLats: [
                { index: 0, type: null },
                { index: 1, type: null },
                { index: 2, type: null },
                { index: 3, type: null },
                { index: 4, type: null },
                { index: 5, type: null },
                { index: 6, type: null },
                { index: 7, type: null },
                { index: 8, type: null },

                { index: 27, type: null },
                { index: 35, type: null },
            ]
        }
    },
    //147
    {
        baseElementTypes: [0, 1, 2, 3, 4], bubbleProbability: 0.5, stepCount: 27, passTarget: { type: 1, elements: [{ type: 9, count: 34 }] }, starScores: [6000, 14000, 24000], map: { lattices: [0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 1], connectedLats: [], elements: [0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 4, 2, 1, 1, 1, 1, 1, 2, 4, 2, 4, 2, 1, 1, 1, 2, 4, 2, 0, 2, 4, 2, 1, 2, 4, 2, 0, 0, 0, 2, 4, 2, 4, 2, 0, 0, 0, 0, 0, 2, 4, 2, 0, 0, 0], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 2, type: 0 }, { index: 3, type: 0 }, { index: 4, type: 0 }, { index: 5, type: 0 }, { index: 6, type: 0 }, { index: 10, type: 0 }, { index: 16, type: 0 }, { index: 18, type: 0 }, { index: 26, type: 0 }] }
    },
    //148
    {
        baseElementTypes: [0, 2, 3, 4], bubbleProbability: 0.1, stepCount: 31, passTarget: { type: 1, elements: [{ type: 5, count: 8 }, { type: 1, count: 38 }] }, starScores: [5000, 12000, 21000], map: { lattices: [1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1], connectedLats: [[72, 0], [80, 8], [57, 21], [59, 23]], elements: [2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 6, 1, 1, 1, 2, 1, 1, 1, 6, 6, 1, 1, 2, 7, 2, 1, 1, 6, 6, 1, 1, 1, 2, 1, 1, 1, 6, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 0, type: null }, { index: 1, type: null }, { index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 7, type: null }, { index: 8, type: null }] }
    },
    //149
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0.2,
        stepCount: 28,
        passTarget: { type: 1, elements: [{ type: 5, count: 22 }] },
        starScores: [5000, 12000, 21000],
        map: { lattices: [1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1], connectedLats: [[72, 10], [80, 16]], elements: [4, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 2, 2, 1, 2, 2, 2, 1, 2, 2, 2, 2, 1, 2, 2, 2, 1, 2, 2, 2, 2, 1, 4, 2, 4, 1, 2, 2], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 0, type: null }, { index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 8, type: null }, { index: 10, type: null }, { index: 16, type: null }] }
    },
    //150
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0.5,
        stepCount: 24,
        passTarget: {
            type: 1,
            elements: [
                {
                    type: 9,
                    count: 48
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                0, 0, 1, 1, 0, 1, 1, 0, 0,
                0, 3, 3, 3, 3, 3, 3, 3, 0,
                1, 2, 2, 2, 2, 2, 2, 2, 1,
                0, 3, 3, 3, 3, 3, 3, 3, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                1, 1, 3, 3, 1, 3, 3, 1, 1,
                1, 1, 1, 0, 1, 0, 1, 1, 1,
            ],
            elements: [
                0, 0, 2, 2, 0, 2, 2, 0, 0,
                0, 2, 2, 2, 2, 2, 2, 2, 0,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                0, 2, 2, 2, 2, 2, 2, 2, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                2, 0, 0, 0, 2, 0, 0, 0, 2,
                2, 0, 0, 0, 2, 0, 0, 0, 2,
                2, 1, 0, 0, 1, 0, 0, 1, 2,
                1, 2, 1, 0, 1, 0, 1, 2, 1,
            ],
            baseElements: [
                0, 0, 2, 2, 0, 2, 2, 0, 0,
                0, 2, 2, 2, 2, 2, 2, 2, 0,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                0, 2, 2, 2, 2, 2, 2, 2, 0,
                0, 0, 2, 2, 2, 2, 2, 0, 0,
                2, 0, 0, 0, 2, 0, 0, 0, 2,
                2, 0, 0, 0, 2, 3, 0, 0, 2,
                2, 32, 0, 0, 22, 0, 0, 32, 2,
                32, 2, 32, 0, 23, 0, 32, 2, 32,
            ],
            generateLats: [
                { index: 10, type: [0], cus: [] },
                { index: 3, type: [0], cus: [] },
                { index: 2, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
                { index: 16, type: [0], cus: [] },
                { index: 45, type: [0], cus: [] },
                { index: 53, type: [0], cus: [] },
            ],
        },
    },
    //151
    {
        baseElementTypes: [0, 1, 2, 3, 4], bubbleProbability: 0.1, stepCount: 25, passTarget: { type: 1, elements: [{ type: 6, count: 4 }] }, starScores: [5000, 12000, 21000], map: { lattices: [1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1], connectedLats: [[36, 54], [28, 46], [20, 38], [13, 31], [24, 42], [34, 52], [44, 62]], elements: [1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 7, 7, 7, 7, 7, 1, 1, 1, 2, 7, 7, 7, 7, 7, 2, 1, 7, 7, 7, 7, 7, 7, 7, 7, 7, 2, 2, 7, 2, 2, 2, 7, 2, 2, 9, 2, 7, 2, 9, 2, 7, 2, 9], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [72, 73, 74, 75, 76, 77, 78, 79, 80], generateLats: [{ index: 0, type: null }, { index: 1, type: null }, { index: 2, type: null }, { index: 4, type: null }, { index: 6, type: null }, { index: 7, type: null }, { index: 8, type: null }, { index: 30, type: null }, { index: 32, type: null }] }
    },
    //152
    {
        baseElementTypes: [0, 1, 2, 3, 4], bubbleProbability: 0.1, stepCount: 25, passTarget: { type: 1, elements: [{ type: 6, count: 4 }] }, starScores: [5000, 12000, 21000], map: { lattices: [0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 0, 1, 0], connectedLats: [], elements: [1, 1, 3, 2, 3, 2, 3, 1, 1, 1, 1, 1, 2, 1, 2, 1, 1, 1, 7, 1, 2, 2, 2, 2, 2, 1, 7, 7, 1, 1, 2, 5, 2, 1, 1, 7, 7, 1, 1, 2, 2, 2, 1, 1, 7, 7, 1, 2, 2, 2, 2, 2, 1, 7, 7, 2, 1, 2, 1, 2, 1, 2, 7, 7, 2, 2, 2, 2, 2, 2, 2, 7, 1, 2, 1, 2, 2, 2, 1, 2, 1], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 42, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 41, 0, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [63, 65, 69, 71, 73, 75, 76, 77, 79], generateLats: [{ index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 10, type: null }, { index: 16, type: null }, { index: 18, type: null }, { index: 26, type: null }] }
    },
    //153
    {
        baseElementTypes: [4, 1, 2, 3],
        bubbleProbability: 0.8,
        stepCount: 24,
        passTarget: {
            type: PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType.ICE,
                    count: 24
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                1, 0, 1, 1, 1, 1, 1, 0, 1,
                1, 0, 1, 1, 1, 1, 1, 0, 1,
                1, 2, 2, 2, 2, 2, 2, 2, 1,
                1, 1, 2, 2, 1, 2, 2, 1, 1,
                1, 1, 2, 2, 1, 2, 2, 1, 1,
            ],
            elements: [
                4, 4, 4, 4, 4, 4, 4, 4, 4,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                0, 0, 4, 4, 4, 4, 4, 0, 0,
                0, 0, 4, 4, 1, 4, 4, 0, 0,
                0, 2, 2, 2, 4, 2, 2, 2, 0,
                0, 0, 2, 2, 1, 2, 2, 0, 0,
                0, 0, 2, 2, 1, 2, 2, 0, 0,
            ],
            baseElements: [
                30, 20, 30, 20, 30, 20, 30, 20, 30,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                0, 0, 50, 50, 40, 50, 50, 0, 0,
                0, 0, 40, 40, 50, 40, 40, 0, 0,
                0, 2, 2, 2, 50, 2, 2, 2, 1,
                1, 1, 2, 2, 40, 2, 2, 1, 1,
                1, 1, 2, 2, 44, 2, 2, 1, 1,
            ],
            generateLats: [
                { index: 0, type: [0], cus: [] },
                { index: 2, type: [0], cus: [] },
                { index: 1, type: [0], cus: [] },
                { index: 3, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
                { index: 7, type: [0], cus: [] },
                { index: 8, type: [0], cus: [] },
            ],
        },
    },
    //154
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0.1,
        stepCount: 25,
        passTarget: { type: 1, elements: [{ type: 9, count: 26 }] },
        starScores: [5000, 12000, 21000],
        map: {
            lattices: [
                0, 0, 1, 1, 1, 1, 1, 0, 0,
                0, 1, 1, 3, 3, 3, 3, 1, 0,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 0, 0, 0, 1, 1, 1,
                1, 1, 1, 1, 1, 1, 1, 1, 1,
                3, 3, 3, 3, 3, 3, 3, 3, 3,
                0, 1, 3, 3, 3, 3, 1, 1, 0,
                0, 0, 1, 1, 1, 1, 1, 0, 0
            ],
            connectedLats: [[30, 48], [31, 49], [32, 50]], elements: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 7, 1, 2, 1, 1, 1, 2, 1, 7, 7, 1, 1, 2, 2, 2, 1, 1, 7, 7, 1, 2, 1, 1, 1, 2, 1, 7, 7, 1, 1, 2, 2, 2, 1, 1, 7, 7, 1, 1, 1, 1, 1, 1, 1, 7, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 10, type: null }, { index: 16, type: null }, { index: 18, type: null }, { index: 26, type: null }]
        }
    },
    //155
    {
        baseElementTypes: [0, 2, 3, 4],
        bubbleProbability: 0,
        stepCount: 20,
        passTarget: { type: 1, elements: [{ type: 1, count: 88 }, { type: 10, count: 18 }] }, starScores: [5000, 12000, 21000], map: { lattices: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1], connectedLats: [], elements: [4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 6, 6, 6, 6, 6, 6, 6, 6, 6, 9, 9, 6, 9, 6, 9, 6, 9, 9, 9, 9, 6, 9, 6, 9, 6, 9, 9, 9, 9, 6, 9, 6, 9, 6, 9, 9], baseElements: [20, 0, 20, 0, 20, 0, 20, 0, 20, 0, 20, 0, 20, 0, 20, 0, 20, 0, 20, 0, 20, 0, 20, 0, 20, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 0, type: null }, { index: 1, type: null }, { index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 7, type: null }, { index: 8, type: null }] }
    },
    //156
    {
        baseElementTypes: [4, 1, 2, 3],
        bubbleProbability: 0.5,
        stepCount: 28,
        passTarget: {
            type: PassType.ELEMENT_TARGET,
            elements: [
                {
                    type: ElementType.ICE,
                    count: 64
                },
            ]
        },
        starScores: [4000, 8000, 12000],
        map: {
            lattices: [
                3, 3, 0, 0, 3, 3, 3, 3, 1,
                3, 3, 3, 3, 3, 3, 3, 3, 1,
                3, 3, 3, 3, 3, 3, 3, 3, 1,
                3, 3, 0, 0, 3, 3, 3, 3, 1,
                3, 3, 3, 3, 3, 3, 3, 3, 1,
                3, 3, 0, 0, 3, 3, 3, 3, 1,
                3, 3, 3, 3, 3, 3, 3, 3, 1,
                3, 3, 3, 3, 3, 3, 3, 3, 1,
                3, 3, 0, 0, 3, 3, 3, 3, 1,
            ],
            elements: [
                2, 2, 0, 0, 2, 2, 2, 2, 4,
                2, 2, 4, 4, 2, 2, 2, 2, 4,
                2, 2, 4, 4, 2, 2, 2, 2, 4,
                2, 2, 0, 0, 2, 2, 2, 2, 4,
                1, 1, 4, 1, 2, 2, 2, 2, 4,
                4, 1, 0, 0, 2, 2, 2, 2, 4,
                2, 2, 4, 4, 2, 2, 2, 2, 4,
                2, 2, 4, 4, 2, 2, 2, 2, 4,
                2, 2, 0, 0, 2, 2, 2, 2, 4,
            ],
            baseElements: [
                2, 2, 0, 0, 2, 2, 2, 2, 0,
                2, 2, 51, 52, 2, 2, 2, 2, 0,
                2, 2, 51, 52, 2, 2, 2, 2, 0,
                2, 2, 0, 0, 2, 2, 2, 2, 0,
                40, 30, 41, 23, 2, 2, 2, 2, 0,
                4, 40, 0, 0, 2, 2, 2, 2, 0,
                2, 2, 52, 51, 2, 2, 2, 2, 0,
                2, 2, 52, 51, 2, 2, 2, 2, 0,
                2, 2, 0, 0, 2, 2, 2, 2, 0,
            ],
            generateLats: [
                { index: 0, type: [0], cus: [] },
                { index: 1, type: [0], cus: [] },
                { index: 4, type: [0], cus: [] },
                { index: 5, type: [0], cus: [] },
                { index: 6, type: [0], cus: [] },
                { index: 7, type: [0], cus: [] },
                { index: 8, type: [0], cus: [] },
                { index: 11, type: [0], cus: [] },
                { index: 12, type: [0], cus: [] },
                { index: 39, type: [0], cus: [] },
                { index: 38, type: [0], cus: [] },
                { index: 46, type: [0], cus: [] },
                { index: 47, type: [0], cus: [] },
            ],
        },
    },
    //157
    {
        baseElementTypes: [0, 1, 2, 3, 4], bubbleProbability: 0, stepCount: 36, passTarget: { type: 1, elements: [{ type: 6, count: 13 }] }, starScores: [5000, 12000, 21000], map: { lattices: [0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0], connectedLats: [[30, 48], [31, 49], [32, 50], [74, 18], [78, 26]], elements: [1, 1, 1, 3, 3, 3, 1, 1, 1, 1, 1, 1, 2, 3, 2, 1, 1, 1, 1, 1, 1, 3, 3, 3, 1, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [75, 76, 77], generateLats: [{ index: 2, type: null }, { index: 3, type: null }, { index: 4, type: null }, { index: 5, type: null }, { index: 6, type: null }, { index: 10, type: null }, { index: 16, type: null }, { index: 18, type: null }, { index: 26, type: null }] }
    },
    //158
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0.2,
        stepCount: 30,
        passTarget: { type: 1, elements: [{ type: 9, count: 37 }] },
        starScores: [5000, 12000, 21000], map: { lattices: [1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 1, 1, 1, 1, 1, 2, 0, 2, 2, 1, 1, 1, 1, 1, 2, 2, 2, 2, 1, 1, 1, 1, 1, 2, 2, 0, 0, 1, 1, 1, 1, 1, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2], connectedLats: [[0, 27], [2, 54], [6, 62], [8, 35]], elements: [9, 1, 9, 1, 1, 1, 9, 1, 9, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 2], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [], generateLats: [{ index: 0, type: null }, { index: 2, type: null }, { index: 6, type: null }, { index: 8, type: null }, { index: 19, type: null }, { index: 21, type: null }, { index: 22, type: null }, { index: 23, type: null }, { index: 25, type: null }] }
    },
    //159
    {
        baseElementTypes: [0, 1, 2, 3],
        bubbleProbability: 0.6,
        stepCount: 25,
        passTarget: {
            type: 1,
            elements: [{ type: 5, count: 12 }]
        },
        starScores: [6000, 12000, 24000],
        map: {
            lattices: [
                0, 0, 0, 1, 1, 1, 1, 1, 1,
                0, 0, 1, 1, 1, 1, 1, 1, 1,
                0, 1, 1, 1, 1, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 0, 0, 0, 0,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1,
                1, 1, 1, 1, 0, 1, 1, 1, 1
            ],
            connectedLats: [[32, 50], [33, 51], [34, 52], [35, 53]],
            elements: [
                0, 0, 0, 2, 2, 4, 4, 4, 4,
                0, 0, 0, 0, 2, 4, 4, 4, 4,
                0, 0, 0, 0, 2, 1, 1, 1, 1,
                0, 0, 0, 0, 0, 1, 1, 1, 1,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                4, 4, 4, 4, 0, 1, 1, 1, 1,
                2, 2, 2, 2, 0, 1, 1, 1, 1,
                4, 4, 4, 4, 0, 1, 1, 1, 1,
                2, 2, 2, 2, 0, 1, 1, 1, 1
            ],
            baseElements: [
                0, 0, 0, 0, 0, 30, 50, 20, 30,
                0, 0, 0, 0, 0, 30, 20, 30, 20,
                0, 0, 0, 0, 0, 20, 50, 20, 50,
                0, 0, 0, 0, 0, 12, 30, 12, 30,
                0, 0, 0, 0, 0, 0, 0, 0, 0,
                20, 20, 50, 50, 0, 10, 50, 10, 50,
                0, 0, 0, 0, 0, 20, 30, 30, 10,
                10, 10, 20, 20, 0, 10, 20, 20, 10,
                0, 0, 0, 0, 0, 30, 20, 30, 30
            ],
            recycles: [],
            generateLats: [
                { index: 3, type: 0 },
                { index: 4, type: 0 },
                { index: 5, type: 0 },
                { index: 6, type: 0 },
                { index: 7, type: 0 },
                { index: 8, type: 0 }
            ]
        }
    },
    //160
    {
        baseElementTypes: [0, 1, 2, 3, 4],
        bubbleProbability: 0.2,
        stepCount: 26,
        passTarget: { type: 1, elements: [{ type: 9, count: 62 }] },
        starScores: [5000, 12000, 21000],
        map: {
            lattices: [
                2, 2, 2, 2, 2, 2, 2, 2, 2,
                0, 2, 2, 2, 2, 2, 2, 2, 0,
                2, 1, 2, 2, 2, 2, 2, 1, 2,
                2, 1, 2, 2, 2, 2, 2, 1, 2, 2, 1, 2, 1, 1, 1, 2, 1, 2, 2, 1, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 2, 2, 2, 2, 2, 2, 2, 0, 0, 2, 2, 2, 2, 2, 2, 2, 0], connectedLats: [[0, 55], [8, 61]], elements: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 7, 1, 1, 2, 1, 1, 7, 1, 1, 7, 1, 2, 2, 2, 1, 7, 1, 1, 7, 2, 6, 6, 6, 2, 7, 1, 1, 7, 1, 2, 2, 2, 1, 7, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1], baseElements: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], recycles: [],
            generateLats: [
                { index: 0, type: null },
                { index: 1, type: null },
                { index: 2, type: null },
                { index: 3, type: null },
                { index: 4, type: null },
                { index: 5, type: null },
                { index: 6, type: null },
                { index: 7, type: null },
                { index: 8, type: null },
                { index: 49, type: null }
            ]
        }
    },
]